/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.core.ui.quickfix.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.validation.ConstraintStatusDiagnostic;
import org.polarsys.capella.common.mdsofa.common.misc.Couple;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;
import org.polarsys.capella.common.ui.toolkit.viewers.AbstractContextMenuFiller;
import org.polarsys.capella.common.utils.graph.BasicDirectedGraph;
import org.polarsys.capella.common.utils.graph.IDirectedGraph;
import org.polarsys.capella.common.utils.graph.SCCSearch;
import org.polarsys.capella.core.data.capellacore.AbstractDependenciesPkg;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.capellamodeller.validation.PkgDependenciesCycleValidationRule;
import org.polarsys.capella.core.data.core.ui.quickfix.messages.CoreQuickFixMessages;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.helpers.InterfacePkgExt;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.LocateInCapellaExplorerAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.Messages;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractCapellaMarkerResolution;
import org.polarsys.capella.core.validation.ui.ide.quickfix.EObjectNavigatorDialog;

public class DWF_D25_Resolver
extends AbstractCapellaMarkerResolution {
    public void run(IMarker marker) {
        List<AbstractDependenciesPkg> cycle = this.getMarkerCycle(marker);
        if (cycle.isEmpty()) {
            return;
        }
        Couple<IDirectedGraph<EObject>, Collection<List<EObject>>> result = this.computeCycleGraph(this.buildMapOfCycles(cycle));
        final IDirectedGraph graph = (IDirectedGraph)result.getKey();
        Collection cycles = (Collection)result.getValue();
        if (cycles != null && cycles.iterator().hasNext()) {
            EObjectNavigatorDialog dialog = new EObjectNavigatorDialog((List)cycles.iterator().next(), CoreQuickFixMessages.cycle_details_dialog_title, CoreQuickFixMessages.cycle_details_dialog_message, CoreQuickFixMessages.cycle_details_dialog_combo_lbl, CoreQuickFixMessages.cycle_details_dialog_combo_cycle_prefix);
            dialog.setCycles(cycles);
            dialog.setContextMenuManagerFiller(new AbstractContextMenuFiller(){

                public void fillMenuManager(IMenuManager contextMenuManager, ISelection selection) {
                    EObject selectedEObject = (EObject)((TreeSelection)selection).iterator().next();
                    if (!(selectedEObject instanceof AbstractDependenciesPkg)) {
                        ArrayList<EObject> successors = new ArrayList<EObject>();
                        Iterator it = graph.getSucessors((Object)selectedEObject);
                        while (it.hasNext()) {
                            EObject referenced = (EObject)it.next();
                            if (referenced instanceof AbstractDependenciesPkg) continue;
                            successors.add(referenced);
                        }
                        for (EObject referenced : successors) {
                            IAction action = LocateInCapellaExplorerAction.createLocateTowards((EObject)referenced, (String)Messages.LocateInCapellaExplorerAction_GoToReferencedElement, (boolean)false);
                            if (!action.isEnabled()) continue;
                            contextMenuManager.add(action);
                        }
                    }
                }
            });
            dialog.open();
        }
    }

    protected String[] getResolvableRuleIds() {
        return noRuleIds;
    }

    private void addSubpackageDependencies(BasicDirectedGraph<? super EObject> graph, AbstractDependenciesPkg current) {
        EList subpackages = null;
        if (current instanceof DataPkg) {
            subpackages = ((DataPkg)current).getOwnedDataPkgs();
        } else if (current instanceof InterfacePkg) {
            subpackages = ((InterfacePkg)current).getOwnedInterfacePkgs();
        }
        if (subpackages != null) {
            for (AbstractDependenciesPkg sub : subpackages) {
                graph.addEdge((Object)current, (Object)sub);
                this.addSubpackageDependencies(graph, sub);
            }
        }
    }

    private AbstractDependenciesPkg getPkg(EObject eobject) {
        if (eobject instanceof AbstractDependenciesPkg) {
            return (AbstractDependenciesPkg)eobject;
        }
        AbstractDependenciesPkg adp = null;
        if (eobject != null) {
            adp = (AbstractDependenciesPkg)EcoreUtil2.getFirstContainer((EObject)eobject, (EClass)CapellacorePackage.Literals.ABSTRACT_DEPENDENCIES_PKG);
        }
        return adp;
    }

    private void debugPrintCycle(List<EObject> cycle) {
        StringBuilder builder = new StringBuilder();
        for (EObject e : cycle) {
            builder.append(((NamedElement)e).getName());
            builder.append(":" + this.getPkg(e).getName() + ", ");
        }
        System.out.println(builder);
    }

    private Map<AbstractDependenciesPkg, Collection<AbstractDependenciesPkg>> buildMapOfCycles(List<AbstractDependenciesPkg> cycle) {
        HashMap<AbstractDependenciesPkg, Collection<AbstractDependenciesPkg>> result = new HashMap<AbstractDependenciesPkg, Collection<AbstractDependenciesPkg>>();
        for (AbstractDependenciesPkg pkg : cycle) {
            ArrayList<AbstractDependenciesPkg> cycleCopy = new ArrayList<AbstractDependenciesPkg>(cycle);
            cycleCopy.remove(pkg);
            result.put(pkg, cycleCopy);
        }
        return result;
    }

    public Couple<IDirectedGraph<EObject>, Collection<List<EObject>>> computeCycleGraph(Map<AbstractDependenciesPkg, Collection<AbstractDependenciesPkg>> mapOfCycles) {
        List cycle;
        Map dependencyDescriptors = null;
        BasicDirectedGraph graph = new BasicDirectedGraph();
        EClass eclass = null;
        for (AbstractDependenciesPkg current : mapOfCycles.keySet()) {
            this.addSubpackageDependencies((BasicDirectedGraph<? super EObject>)graph, current);
            eclass = current.eClass();
            if (InformationPackage.Literals.DATA_PKG.isSuperTypeOf(eclass)) {
                dependencyDescriptors = DataPkgExt.getDataPkgDependenciesHierarchy2((DataPkg)((DataPkg)current));
            } else if (CsPackage.Literals.INTERFACE_PKG.isSuperTypeOf(eclass)) {
                dependencyDescriptors = InterfacePkgExt.getInterfacePkgDependenciesHierarchy2((InterfacePkg)((InterfacePkg)current));
            }
            if (dependencyDescriptors == null) continue;
            for (Map.Entry entry : dependencyDescriptors.entrySet()) {
                for (Couple objectDependency : (Collection)entry.getValue()) {
                    EObject dependent = (EObject)objectDependency.getKey();
                    EObject container = dependent.eContainer();
                    while (container != null) {
                        if (container instanceof AbstractDependenciesPkg) {
                            graph.addEdge((Object)container, (Object)dependent);
                            container = null;
                            continue;
                        }
                        container = container.eContainer();
                    }
                    for (EObject dependee : (Collection)objectDependency.getValue()) {
                        Object pkg = (AbstractDependenciesPkg)entry.getKey();
                        while (pkg != null) {
                            graph.addEdge((Object)dependee, pkg);
                            pkg = pkg.eContainer() instanceof AbstractDependenciesPkg ? (AbstractDependenciesPkg)pkg.eContainer() : null;
                        }
                        graph.addEdge((Object)dependent, (Object)dependee);
                    }
                }
            }
        }
        List scc = new SCCSearch().findSCC((IDirectedGraph)graph, false);
        Iterator l = scc.iterator();
        while (l.hasNext()) {
            cycle = (List)l.next();
            AbstractDependenciesPkg ap = null;
            boolean exclude = true;
            for (EObject o : cycle) {
                AbstractDependenciesPkg oap = this.getPkg(o);
                if (ap == null) {
                    ap = oap;
                    continue;
                }
                if (ap == oap) continue;
                exclude = false;
                break;
            }
            if (!exclude) continue;
            l.remove();
        }
        l = scc.iterator();
        while (l.hasNext()) {
            cycle = (List)l.next();
            AbstractDependenciesPkg mostSpecificPkg = null;
            boolean remove = true;
            for (EObject elem : cycle) {
                AbstractDependenciesPkg p = this.getPkg(elem);
                if (mostSpecificPkg != null) {
                    if (mostSpecificPkg == p) continue;
                    if (EcoreUtil.isAncestor((EObject)mostSpecificPkg, (EObject)p)) {
                        mostSpecificPkg = p;
                        continue;
                    }
                    if (EcoreUtil.isAncestor((EObject)p, (EObject)mostSpecificPkg)) continue;
                    remove = false;
                    break;
                }
                mostSpecificPkg = p;
            }
            if (!remove) continue;
            l.remove();
        }
        for (List cycle2 : scc) {
            Iterator elems = cycle2.iterator();
            while (elems.hasNext()) {
                EObject elem = (EObject)elems.next();
                if (!(elem instanceof AbstractDependenciesPkg)) continue;
                elems.remove();
            }
        }
        return new Couple((Object)graph, (Object)scc);
    }

    private List<AbstractDependenciesPkg> getMarkerCycle(IMarker marker) {
        IConstraintStatus constraintStatus;
        ArrayList<AbstractDependenciesPkg> result = new ArrayList<AbstractDependenciesPkg>();
        Diagnostic diagnostic = MarkerViewHelper.getDiagnostic((IMarker)marker);
        if (diagnostic instanceof ConstraintStatusDiagnostic && (constraintStatus = ((ConstraintStatusDiagnostic)diagnostic).getConstraintStatus()) != null) {
            for (EObject obj : constraintStatus.getResultLocus()) {
                if (!(obj instanceof AbstractDependenciesPkg)) continue;
                result.add((AbstractDependenciesPkg)obj);
            }
        }
        return result;
    }

    public Couple<IDirectedGraph<EObject>, Collection<List<EObject>>> computeCyclesGraph(SystemEngineering context) {
        PkgDependenciesCycleValidationRule rule = new PkgDependenciesCycleValidationRule();
        List interPackageCycles = rule.getInterPackageCycles((EObject)context);
        HashMap<AbstractDependenciesPkg, Collection<AbstractDependenciesPkg>> mapOfCycles = new HashMap<AbstractDependenciesPkg, Collection<AbstractDependenciesPkg>>();
        for (List cycle : interPackageCycles) {
            Map<AbstractDependenciesPkg, Collection<AbstractDependenciesPkg>> builtMapOfCycles = this.buildMapOfCycles(cycle);
            mapOfCycles.putAll(builtMapOfCycles);
        }
        return this.computeCycleGraph(mapOfCycles);
    }
}

