/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.util.NumericUtils;

public final class GeoEncodingUtils {
    public static final short BITS = 32;
    private static final double LAT_SCALE = 2.3860929422222223E7;
    private static final double LAT_DECODE = 4.190951585769653E-8;
    private static final double LON_SCALE = 1.1930464711111112E7;
    private static final double LON_DECODE = 8.381903171539307E-8;

    private GeoEncodingUtils() {
    }

    public static int encodeLatitude(double latitude) {
        GeoUtils.checkLatitude(latitude);
        if (latitude == 90.0) {
            latitude = Math.nextDown(latitude);
        }
        return (int)Math.floor(latitude / 4.190951585769653E-8);
    }

    public static int encodeLatitudeCeil(double latitude) {
        GeoUtils.checkLatitude(latitude);
        if (latitude == 90.0) {
            latitude = Math.nextDown(latitude);
        }
        return (int)Math.ceil(latitude / 4.190951585769653E-8);
    }

    public static int encodeLongitude(double longitude) {
        GeoUtils.checkLongitude(longitude);
        if (longitude == 180.0) {
            longitude = Math.nextDown(longitude);
        }
        return (int)Math.floor(longitude / 8.381903171539307E-8);
    }

    public static int encodeLongitudeCeil(double longitude) {
        GeoUtils.checkLongitude(longitude);
        if (longitude == 180.0) {
            longitude = Math.nextDown(longitude);
        }
        return (int)Math.ceil(longitude / 8.381903171539307E-8);
    }

    public static double decodeLatitude(int encoded) {
        double result = (double)encoded * 4.190951585769653E-8;
        assert (result >= -90.0 && result < 90.0);
        return result;
    }

    public static double decodeLatitude(byte[] src, int offset) {
        return GeoEncodingUtils.decodeLatitude(NumericUtils.sortableBytesToInt(src, offset));
    }

    public static double decodeLongitude(int encoded) {
        double result = (double)encoded * 8.381903171539307E-8;
        assert (result >= -180.0 && result < 180.0);
        return result;
    }

    public static double decodeLongitude(byte[] src, int offset) {
        return GeoEncodingUtils.decodeLongitude(NumericUtils.sortableBytesToInt(src, offset));
    }
}

