/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.semantic.browser.sirius.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserView;

public class DiagramOpenAction {
    private ISelection selection;
    private SemanticBrowserView semanticBrowserView;

    public void init(IWorkbenchPart part) {
        this.semanticBrowserView = (SemanticBrowserView)part;
    }

    protected void postEditorOpen(Object element, IEditorPart openEditor) {
    }

    public void run(IAction action) {
        IStructuredSelection structuredSelection = (IStructuredSelection)this.selection;
        DRepresentationDescriptor representation = (DRepresentationDescriptor)structuredSelection.getFirstElement();
        Object currentElement = this.semanticBrowserView.getCurrentViewer().getInput();
        boolean listeningToPageSelectionEvents = this.semanticBrowserView.getModel().isListeningToPageSelectionEvents();
        EObject target = representation.getTarget();
        if (target != null) {
            try {
                if (listeningToPageSelectionEvents) {
                    this.semanticBrowserView.deactivateListeningToPageSelectionEvents();
                }
                Session session = SessionManager.INSTANCE.getSession(target);
                IEditorPart openEditor = DialectUIManager.INSTANCE.openEditor(session, representation.getRepresentation(), (IProgressMonitor)new NullProgressMonitor());
                this.postEditorOpen(currentElement, openEditor);
            }
            finally {
                if (listeningToPageSelectionEvents) {
                    this.semanticBrowserView.activateListeningToPageSelectionEvents();
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection.isEmpty() ? null : selection;
    }
}

