/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commandline.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.app.IApplicationContext;
import org.polarsys.capella.common.application.CommonArgumentsConstants;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.common.tools.report.util.LogExt;
import org.polarsys.capella.core.af.integration.CapellaMetadataProvider;
import org.polarsys.capella.core.commandline.core.CommandLineArgumentHelper;
import org.polarsys.capella.core.commandline.core.CommandLineException;
import org.polarsys.capella.core.commandline.core.CommandLineMode;
import org.polarsys.capella.core.commandline.core.ICommandLine;
import org.polarsys.capella.core.commandline.core.IFileImporter;
import org.polarsys.capella.core.commandline.core.ImporterRegistry;
import org.polarsys.capella.core.commandline.core.Messages;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;

@Deprecated
public class AbstractCommandLine
implements ICommandLine {
    public static int FATAL = 8;
    protected Logger logger;
    protected CommandLineArgumentHelper argHelper;
    protected CommandLineMode mode;
    private List<String> importedProjects = new ArrayList<String>();

    public AbstractCommandLine() {
        this.argHelper = CommandLineArgumentHelper.getInstance();
        this.logger = ReportManagerRegistry.getInstance().subscribe("Default");
    }

    @Override
    public void parseContext(IApplicationContext context) throws CommandLineException {
        String[] args = CommandLineArgumentHelper.parseContext(context);
        this.argHelper.parseArgs(args);
    }

    @Override
    public void checkArgs(IApplicationContext context) throws CommandLineException {
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException exception) {
            this.logErrorAndThrowException(Messages.refresh_problem);
        }
        if (this.isEmtyOrNull(this.argHelper.getFilePath())) {
            this.logErrorAndThrowException(Messages.representation_mandatory);
        }
        if (this.isEmtyOrNull(this.argHelper.getOutputFolder())) {
            this.logErrorAndThrowException(Messages.outputfolder_mandatory);
        }
        if (this.isEmtyOrNull(this.argHelper.getImportProjects())) {
            this.setMode(CommandLineMode.NO_IMPORT);
            this.checkFilePath();
            if (!this.argHelper.isCreateFolder()) {
                this.checkoutputFolder();
            }
        } else if (!this.isEmtyOrNull(this.argHelper.getImportProjects())) {
            this.setMode(CommandLineMode.IMPORT);
        }
    }

    @Override
    public void prepare(IApplicationContext context) throws CommandLineException {
        if (!CommandLineMode.NO_IMPORT.equals((Object)this.mode) && CommandLineMode.IMPORT.equals((Object)this.mode)) {
            try {
                this.importProjects(this.toList(this.argHelper.getImportProjects()));
            }
            catch (CoreException exception) {
                throw new CommandLineException(exception.getMessage());
            }
        }
        if (this.argHelper.isCreateFolder() && this.argHelper.getOutputFolder() != null) {
            this.createOutputFolder(this.argHelper.getOutputFolder());
        }
        if (!this.projectVersionIsCompliant()) {
            this.logErrorAndThrowException(Messages.Error_versionCompliancy);
        }
    }

    @Override
    public void postExecute(IApplicationContext context) throws CommandLineException {
    }

    public boolean projectVersionIsCompliant() throws CommandLineException {
        String projectName = AbstractCommandLine.getProjectName(this.argHelper.getFilePath());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            this.logError(String.valueOf(Messages.project) + projectName + Messages.not_exist);
        } else {
            try {
                project.open((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException exception) {
                StringBuilder loggerMessage = new StringBuilder("HTMLCommandLine.checkArgs(..) _ ");
                this.logger.warn((Object)loggerMessage.toString(), (Throwable)exception);
            }
            List<IFile> melodymodellerFiles = this.getCapellamodellerFiles(project);
            for (IFile modeller : melodymodellerFiles) {
                this.compliancyCheck(modeller);
            }
        }
        return true;
    }

    public void compliancyCheck(IFile modeller) throws CommandLineException {
        IStatus status = new CapellaMetadataProvider().checkVersion(modeller);
        if (!status.isOK()) {
            throw new CommandLineException(status.getMessage());
        }
    }

    protected int getMajorVersion(String version) {
        return Integer.parseInt("" + version.charAt(2));
    }

    protected int getMinorVersion(String version) {
        return Integer.parseInt("" + version.charAt(4));
    }

    protected int getReleaseVersion(String version) {
        return Integer.parseInt("" + version.charAt(0));
    }

    protected List<IFile> getCapellamodellerFiles(IProject project) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        try {
            IResource[] iResourceArray = project.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                if (CapellaResourceHelper.isCapellaResource((IResource)res, (boolean)false)) {
                    files.add((IFile)res);
                }
                ++n2;
            }
        }
        catch (CoreException exception) {
            StringBuilder loggerMessage = new StringBuilder(Messages.compliance_check_pb);
            this.logger.warn((Object)loggerMessage.toString(), (Throwable)exception);
        }
        return files;
    }

    @Override
    public boolean execute(IApplicationContext context) throws CommandLineException {
        return false;
    }

    protected void logErrorAndThrowException(String message) throws CommandLineException {
        this.logError(message);
        throw new CommandLineException(message);
    }

    protected boolean isEmtyOrNull(String var) {
        return var == null || var.isEmpty();
    }

    private void checkoutputFolder() throws CommandLineException {
        Path path = new Path(this.argHelper.getOutputFolder());
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
        if (!folder.exists()) {
            String message = "folder " + this.argHelper.getOutputFolder() + Messages.not_exist;
            this.logError(message);
            throw new CommandLineException(message);
        }
    }

    private void checkFilePath() throws CommandLineException {
        String projectName = AbstractCommandLine.getProjectName(this.argHelper.getFilePath());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            this.logError(String.valueOf(Messages.project) + projectName + Messages.not_exist);
        }
        try {
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException exception) {
            StringBuilder loggerMessage = new StringBuilder(String.valueOf(Messages.unable_open_project) + project.getName());
            this.logger.warn((Object)loggerMessage.toString(), (Throwable)exception);
        }
        IFile file = project.getFile(AbstractCommandLine.getRelativeFilePath(this.argHelper.getFilePath()));
        if (!file.exists()) {
            String message = String.valueOf(Messages.aird) + this.argHelper.getFilePath() + Messages.not_exist;
            this.logError(message);
            throw new CommandLineException(message);
        }
    }

    protected void logStatus(IStatus status) {
        if (status.isOK()) {
            this.logger.info((Object)status.getMessage());
        } else if (FATAL == status.getSeverity()) {
            this.logger.fatal((Object)status.getMessage());
        } else if (4 == status.getSeverity()) {
            this.logger.error((Object)status.getMessage());
        } else if (2 == status.getSeverity()) {
            this.logger.warn((Object)status.getMessage());
        } else {
            this.logger.info((Object)status.getMessage());
        }
        if (status.isMultiStatus()) {
            MultiStatus mStatus = (MultiStatus)status;
            IStatus[] iStatusArray = mStatus.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus childStatus = iStatusArray[n2];
                this.logStatus(childStatus);
                ++n2;
            }
        }
    }

    protected void logError(String message) {
        StringBuilder loggerMessage = new StringBuilder(message);
        this.logger.error((Object)loggerMessage.toString());
    }

    protected void logInfo(String message) {
        StringBuilder loggerMessage = new StringBuilder(message);
        this.logger.info((Object)loggerMessage.toString());
    }

    @Deprecated
    protected void LogInfo(String message) {
        this.logInfo(message);
    }

    public void setMode(CommandLineMode mode) {
        this.mode = mode;
    }

    protected List<String> toList(String string) {
        ArrayList<String> list = new ArrayList<String>();
        for (String path : Arrays.asList(string.split("\\|"))) {
            list.add(path.trim());
        }
        return list;
    }

    protected void importProjects(List<String> projectsToImport) throws CoreException {
        for (String projectPath : projectsToImport) {
            IProject project = null;
            if (projectPath.endsWith(".zip")) {
                List<IFileImporter> importers = ImporterRegistry.getInstance().getImporters("zip");
                if (importers.isEmpty()) continue;
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(projectPath));
                Collection<IProject> projects = importers.get(0).importFile(file, this.argHelper.isForceImport());
                for (IProject prj : projects) {
                    this.importedProjects.add(prj.getName());
                }
                continue;
            }
            IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription(new Path(projectPath).append(".project"));
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
            if (!this.argHelper.isForceImport()) {
                if (project.exists()) {
                    Status status = new Status(4, "org.polarsys.capella.core.commandline.core", "Problem while importing project into the workspace: A project with the same name is referenced from the workspace. This should be removed from the workspace.");
                    LogExt.log((String)"Model Management", (IStatus)status);
                    continue;
                }
                project.create(description, null);
                project.open(null);
                this.importedProjects.add(project.getName());
                continue;
            }
            if (project.exists()) {
                project.delete(8, (IProgressMonitor)new NullProgressMonitor());
            }
            project.create(description, null);
            project.open(null);
            this.importedProjects.add(project.getName());
        }
    }

    private void createOutputFolder(String outputFolder) throws CommandLineException {
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(outputFolder));
        try {
            IProject project = folder.getProject();
            if (!project.exists()) {
                project.create((IProgressMonitor)new NullProgressMonitor());
            }
            if (!project.isOpen()) {
                project.open((IProgressMonitor)new NullProgressMonitor());
            }
            if (!folder.exists()) {
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            } else {
                this.logInfo(String.valueOf(outputFolder) + Messages.already_exist);
            }
        }
        catch (CoreException exception) {
            StringBuilder message = new StringBuilder(Messages.cannot_create_folder);
            this.logger.error((Object)message.toString(), (Throwable)exception);
            throw new CommandLineException(message.toString());
        }
    }

    @Override
    public void printHelp() {
        System.out.println("*** Capella Command Line Core Mechanism ***");
        System.out.println("-appid value : defines the id of the command line application to launch, see org.polarsys.capella.core.commandline.core.commandline extension point.");
        System.out.println("-data value : defines the path to the workspace.");
        System.out.println("-import value : defines a list of projects to import into the workspace before doing the actual job. List of projects is a '|' separated list.");
        System.out.println("-forceimport : delete/unreference the project if it exists already in the workspace.");
        System.out.println("-filepath value : defines the path to your aird file.");
        System.out.println("-outputfolder value : defines the path to the output folder.");
        System.out.println("-forceoutputfoldercreation value : create the output folder if it does not exist.");
        System.out.println("-help : prints the help message");
        System.out.println(CommonArgumentsConstants.LOG_FILE_PATH__DESCRIPTION);
    }

    public static String getProjectName(String filePath) {
        URI fileURI = URI.createFileURI((String)filePath);
        return URI.decode((String)fileURI.segment(0));
    }

    public static String getRelativeFilePath(String filePath) {
        URI fileURI = URI.createFileURI((String)filePath);
        ArrayList<String> segments = new ArrayList<String>(Arrays.asList(fileURI.segments()));
        segments.remove(0);
        if (segments.isEmpty()) {
            return "";
        }
        URI uri = URI.createFileURI((String)((String)segments.get(0)));
        int i = 1;
        while (i < segments.size()) {
            uri = uri.appendSegment((String)segments.get(i));
            ++i;
        }
        return URI.decode((String)uri.toFileString());
    }

    public List<String> getImportedProjects() {
        return this.importedProjects;
    }
}

