/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.preferences.transferer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.preferences.PreferenceTransferElement;
import org.eclipse.ui.internal.wizards.preferences.PreferencesMessages;
import org.eclipse.ui.internal.wizards.preferences.WizardPreferencesPage;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.osgi.service.prefs.BackingStoreException;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.commands.preferences.util.PreferencesHelper;
import org.polarsys.capella.core.preferences.transferer.CapellaImportExportPreferences;
import org.polarsys.capella.core.preferences.transferer.PreferenceProjectSelectionDialog;
import org.polarsys.capella.core.preferences.transferer.PreferencesProjectFilter;

public class WizardPreferencesTransfererExportPage
extends WizardPreferencesPage {
    private static final String PREFERENCESEXPORTPAGE1 = "preferencesExportPage1";
    private static final String CONFIGURABLE_PROJECT_SELECTION_TITLE = "Project Selection";
    private static final String CONFIGURABLE_PROJECT_SELECTION_MESSAGE = "Select the project destination form the tree :";
    private static final Logger __logger = ReportManagerRegistry.getInstance().subscribe("User Interface");

    protected WizardPreferencesTransfererExportPage(String name) {
        super(name);
        this.setTitle(PreferencesMessages.WizardPreferencesExportPage1_exportTitle);
        this.setDescription(PreferencesMessages.WizardPreferencesExportPage1_exportDescription);
    }

    public WizardPreferencesTransfererExportPage() {
        this(PREFERENCESEXPORTPAGE1);
    }

    protected String getOutputSuffix() {
        return ".epf";
    }

    protected String getDestinationValue() {
        String idealSuffix = this.getOutputSuffix();
        String destinationText = super.getDestinationValue();
        if (destinationText.length() != 0 && !destinationText.endsWith(File.separator)) {
            int dotIndex = destinationText.lastIndexOf(46);
            if (dotIndex != -1) {
                int pathSepIndex = destinationText.lastIndexOf(File.separator);
                if (pathSepIndex != -1 && dotIndex < pathSepIndex) {
                    destinationText = String.valueOf(destinationText) + idealSuffix;
                }
            } else {
                destinationText = String.valueOf(destinationText) + idealSuffix;
            }
        }
        return destinationText;
    }

    protected String getAllButtonText() {
        return PreferencesMessages.WizardPreferencesExportPage1_all;
    }

    protected String getChooseButtonText() {
        return PreferencesMessages.WizardPreferencesExportPage1_choose;
    }

    protected void createTransferArea(Composite composite) {
        String activePerspectiveId = PreferencesHelper.getActivePerpectiveId();
        this.createTransfersList(composite);
        if ("capella.sirius.perspective".equals(activePerspectiveId)) {
            this.createCustomDestinationGroup(composite);
        } else {
            super.createDestinationGroup(composite);
        }
        this.createOptionsGroup(composite);
    }

    protected void createDestinationGroup(Composite parent) {
    }

    protected void createCustomDestinationGroup(Composite parent) {
        Composite destinationSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        destinationSelectionGroup.setLayout((Layout)layout);
        destinationSelectionGroup.setLayoutData((Object)new GridData(272));
        Label dest = new Label(destinationSelectionGroup, 0);
        dest.setText(this.getDestinationLabel());
        this.destinationNameField = new Combo(destinationSelectionGroup, 2052);
        this.destinationNameField.addListener(24, (Listener)this);
        this.destinationNameField.addListener(13, (Listener)this);
        GridData data = new GridData(768);
        this.destinationNameField.setLayoutData((Object)data);
        Button destinationBrowseButton = new Button(destinationSelectionGroup, 8);
        destinationBrowseButton.setText("Workspace...");
        this.setButtonLayoutData(destinationBrowseButton);
        destinationBrowseButton.setToolTipText("B&rowse Workspace ...");
        Button destinationExplorerBrowseButton = new Button(destinationSelectionGroup, 8);
        destinationExplorerBrowseButton.setText("File System...");
        this.setButtonLayoutData(destinationExplorerBrowseButton);
        destinationExplorerBrowseButton.addListener(13, (Listener)this);
        destinationExplorerBrowseButton.setToolTipText("B&rowse File System...");
        destinationBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e_p) {
                WizardPreferencesTransfererExportPage.this.handleProjectSelectionButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e_p) {
            }
        });
        new Label(parent, 0);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.export_wizard_selection_wizard_page_context");
    }

    protected String getDestinationLabel() {
        return PreferencesMessages.WizardPreferencesExportPage1_file;
    }

    protected PreferenceTransferElement[] getTransfers() {
        String activePerspectiveId = PreferencesHelper.getActivePerpectiveId();
        if ("capella.sirius.perspective".equals(activePerspectiveId)) {
            PreferenceTransferElement[] elements = this.getCapellaTransfers();
            PreferenceTransferElement[] returnElements = new PreferenceTransferElement[elements.length + 20];
            IPreferenceFilter[] filters = new IPreferenceFilter[1];
            IPreferencesService service = Platform.getPreferencesService();
            int count = 0;
            try {
                IPreferenceFilter[] matches;
                PreferenceTransferElement element;
                PreferenceTransferElement[] preferenceTransferElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    element = preferenceTransferElementArray[n2];
                    filters[0] = element.getFilter();
                    matches = service.matches((IEclipsePreferences)service.getRootNode().node("default"), filters);
                    if (matches.length > 0) {
                        returnElements[count] = element;
                        ++count;
                    }
                    ++n2;
                }
                preferenceTransferElementArray = elements;
                n = elements.length;
                n2 = 0;
                while (n2 < n) {
                    element = preferenceTransferElementArray[n2];
                    filters[0] = element.getFilter();
                    matches = service.matches((IEclipsePreferences)service.getRootNode().node("instance"), filters);
                    if (matches.length > 0) {
                        returnElements[count] = element;
                        ++count;
                    }
                    ++n2;
                }
                elements = new PreferenceTransferElement[count];
                System.arraycopy(returnElements, 0, elements, 0, count);
            }
            catch (CoreException e) {
                WorkbenchPlugin.log((String)e.getMessage(), (Throwable)e);
                return new PreferenceTransferElement[0];
            }
            return elements;
        }
        return super.getTransfers();
    }

    private PreferenceTransferElement[] getCapellaTransfers() {
        PreferenceTransferElement[] transfers = super.getTransfers() != null ? super.getTransfers() : new PreferenceTransferElement[]{};
        ArrayList<PreferenceTransferElement> capellaTransfers = new ArrayList<PreferenceTransferElement>();
        PreferenceTransferElement[] preferenceTransferElementArray = transfers;
        int n = transfers.length;
        int n2 = 0;
        while (n2 < n) {
            PreferenceTransferElement currentPreferenceTransferElement = preferenceTransferElementArray[n2];
            if (currentPreferenceTransferElement.getID().contains("capella")) {
                capellaTransfers.add(currentPreferenceTransferElement);
            }
            ++n2;
        }
        transfers = new PreferenceTransferElement[capellaTransfers.size()];
        int i = 0;
        while (i < capellaTransfers.size()) {
            PreferenceTransferElement preferenceTransferElement;
            transfers[i] = preferenceTransferElement = (PreferenceTransferElement)capellaTransfers.get(i);
            ++i;
        }
        return transfers;
    }

    protected boolean transfer(IPreferenceFilter[] transfers) {
        File exportFile = new File(this.getDestinationValue());
        if (!this.ensureTargetIsValid(exportFile)) {
            return false;
        }
        if (transfers.length > 0) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileOutputStream fos = new FileOutputStream(exportFile);){
                    IPreferencesService service = Platform.getPreferencesService();
                    service.exportPreferences(service.getRootNode(), transfers, (OutputStream)fos);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException e) {
                WorkbenchPlugin.log((String)e.getMessage(), (Throwable)e);
                MessageDialog.open((int)1, (Shell)this.getControl().getShell(), (String)"", (String)e.getLocalizedMessage(), (int)0x10000000);
                return false;
            }
        }
        return true;
    }

    protected String getFileDialogTitle() {
        return PreferencesMessages.WizardPreferencesExportPage1_title;
    }

    protected int getFileDialogStyle() {
        return 0x10002000;
    }

    protected String getInvalidDestinationMessage() {
        return PreferencesMessages.WizardPreferencesExportPage1_noPrefFile;
    }

    protected boolean shouldSaveTransferAll() {
        return true;
    }

    public void handleEvent(Event e) {
        Widget source = e.widget;
        if (source instanceof Button) {
            this.handleDestinationBrowseButtonPressed();
        }
    }

    protected void handleDestinationBrowseButtonPressed() {
        FileDialog dialog = new FileDialog(this.getContainer().getShell(), this.getFileDialogStyle());
        dialog.setText(this.getFileDialogTitle());
        dialog.setFilterPath(this.getDestinationValue());
        dialog.setFilterExtensions(new String[]{"*.epf", "*.*"});
        String selectedFileName = dialog.open();
        if (selectedFileName != null) {
            this.setDestinationValue(selectedFileName);
            if (this.getWizard() != null && this.getWizard() instanceof CapellaImportExportPreferences) {
                CapellaImportExportPreferences wizard = (CapellaImportExportPreferences)this.getWizard();
                wizard.setPageCompleted(!selectedFileName.isEmpty());
                this.updatePageCompletion();
            }
        }
    }

    public boolean performFinish() {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (PreferencesHelper.hasConfigurationProject(project)) {
                StringBuilder loggerMessage;
                try {
                    IProject configProject = PreferencesHelper.getReferencedProjectConfiguration(project);
                    new ProjectScope(configProject).getNode("org.polarsys.capella.core.preferences").flush();
                    configProject.refreshLocal(2, null);
                    project.refreshLocal(2, null);
                }
                catch (BackingStoreException exception) {
                    loggerMessage = new StringBuilder("WizardPreferencesTransfererExportPage.performFinish(..) _ ");
                    __logger.warn((Object)loggerMessage.toString(), (Throwable)exception);
                    return super.finish();
                }
                catch (CoreException exception) {
                    loggerMessage = new StringBuilder("WizardPreferencesTransfererExportPage.performFinish(..) _ ");
                    __logger.warn((Object)loggerMessage.toString(), (Throwable)exception);
                }
            }
            ++n2;
        }
        return super.finish();
    }

    protected void handleProjectSelectionButtonPressed() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        PreferenceProjectSelectionDialog dialog = new PreferenceProjectSelectionDialog(this, window.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setTitle(CONFIGURABLE_PROJECT_SELECTION_TITLE);
        dialog.setMessage(CONFIGURABLE_PROJECT_SELECTION_MESSAGE);
        dialog.setInput(ResourcesPlugin.getWorkspace().getRoot());
        dialog.addFilter(new PreferencesProjectFilter());
        dialog.open();
    }

    protected void addDestinationItem(String value) {
        super.addDestinationItem(value);
        this.setDestinationValue(value);
        CapellaImportExportPreferences wizard = (CapellaImportExportPreferences)this.getWizard();
        wizard.setPageCompleted(value != null && !value.isEmpty());
        this.updatePageCompletion();
    }
}

