/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.preferences.transferer;

import java.util.ArrayList;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.activities.ITriggerPoint;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.dialogs.ImportExportPage;
import org.eclipse.ui.internal.dialogs.WizardActivityFilter;
import org.eclipse.ui.internal.dialogs.WizardContentProvider;
import org.eclipse.ui.internal.dialogs.WizardPatternFilter;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardNode;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.wizards.IWizardCategory;
import org.polarsys.capella.core.commands.preferences.properties.ExportPreferencesHandler;
import org.polarsys.capella.core.preferences.transferer.WizardPreferencesTransfererExportPage;

public class PreferencesImportExportPage
extends ImportExportPage {
    private static final String STORE_SELECTED_EXPORT_WIZARD_ID = "ImportExportPage.STORE_SELECTED_EXPORT_WIZARD_ID";
    private static final String STORE_EXPANDED_EXPORT_CATEGORIES = "ImportExportPage.STORE_EXPANDED_EXPORT_CATEGORIES";
    CategorizedWizardSelectionTree exportTree;
    private WizardPreferencesTransfererExportPage wizardPreferencesTransfererExportPage;

    public PreferencesImportExportPage(IWorkbench aWorkbench, IStructuredSelection currentSelection) {
        super(aWorkbench, currentSelection);
    }

    protected void initialize() {
        this.workbench.getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.export_wizard_selection_wizard_page_context");
    }

    protected ITriggerPoint getTriggerPoint() {
        return this.getWorkbench().getActivitySupport().getTriggerPointManager().getTriggerPoint("org.eclipse.ui.exportWizards");
    }

    protected void updateMessage() {
        this.setMessage(WorkbenchMessages.ImportExportPage_chooseExportWizard);
        super.updateMessage();
    }

    protected Composite createTreeViewer(Composite parent) {
        IWizardCategory root = WorkbenchPlugin.getDefault().getExportWizardRegistry().getRootCategory();
        this.exportTree = new CategorizedWizardSelectionTree(root, WorkbenchMessages.ExportWizard_selectWizard);
        Composite exportComp = this.exportTree.createControl(parent);
        this.exportTree.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PreferencesImportExportPage.this.listSelectionChanged(event.getSelection());
            }
        });
        this.exportTree.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PreferencesImportExportPage.this.treeDoubleClicked(event);
            }
        });
        this.setTreeViewer(this.exportTree.getViewer());
        return exportComp;
    }

    public IWizardPage getNextPage() {
        WorkbenchWizardNode selectedNode = (WorkbenchWizardNode)this.getSelectedNode();
        if (selectedNode == null || selectedNode.getWizardElement() == null || !selectedNode.getWizardElement().getId().equals("org.eclipse.ui.wizards.export.Preferences")) {
            return super.getNextPage();
        }
        ITriggerPoint triggerPoint = this.getTriggerPoint();
        if (triggerPoint == null || WorkbenchActivityHelper.allowUseOf((ITriggerPoint)triggerPoint, (Object)this.getSelectedNode())) {
            this.wizardPreferencesTransfererExportPage = new WizardPreferencesTransfererExportPage("Export");
            this.wizardPreferencesTransfererExportPage.setWizard((IWizard)ExportPreferencesHandler.getWizard());
            return this.wizardPreferencesTransfererExportPage;
        }
        return null;
    }

    public void saveWidgetValues() {
        this.storeExpandedCategories(STORE_EXPANDED_EXPORT_CATEGORIES, this.exportTree.getViewer());
        this.storeSelectedCategoryAndWizard(STORE_SELECTED_EXPORT_WIZARD_ID, this.exportTree.getViewer());
        super.saveWidgetValues();
        if (this.wizardPreferencesTransfererExportPage != null) {
            this.wizardPreferencesTransfererExportPage.performFinish();
        }
    }

    protected class CategorizedWizardSelectionTree {
        private static final int SIZING_LISTS_HEIGHT = 200;
        private IWizardCategory wizardCategories;
        private String message;
        private TreeViewer viewer;

        protected CategorizedWizardSelectionTree(IWizardCategory categories, String msg) {
            this.wizardCategories = categories;
            this.message = msg;
        }

        protected Composite createControl(Composite parent) {
            Font font = parent.getFont();
            Composite outerContainer = new Composite(parent, 0);
            outerContainer.setLayout((Layout)new GridLayout());
            outerContainer.setLayoutData((Object)new GridData(1808));
            outerContainer.setFont(font);
            Label messageLabel = new Label(outerContainer, 0);
            if (this.message != null) {
                messageLabel.setText(this.message);
            }
            messageLabel.setFont(font);
            this.createFilteredTree(outerContainer);
            this.layoutTopControl(this.viewer.getControl());
            return outerContainer;
        }

        private void createFilteredTree(Composite parent) {
            FilteredTree filteredTree = new FilteredTree(parent, 2820, (PatternFilter)new WizardPatternFilter(), true);
            this.viewer = filteredTree.getViewer();
            filteredTree.setFont(parent.getFont());
            this.viewer.setContentProvider((IContentProvider)new WizardContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            ArrayList<IWizardCategory> inputArray = new ArrayList<IWizardCategory>();
            boolean expandTop = false;
            if (this.wizardCategories != null) {
                if (this.wizardCategories.getParent() == null) {
                    IWizardCategory[] children;
                    IWizardCategory[] iWizardCategoryArray = children = this.wizardCategories.getCategories();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWizardCategory element = iWizardCategoryArray[n2];
                        inputArray.add(element);
                        ++n2;
                    }
                } else {
                    expandTop = true;
                    inputArray.add(this.wizardCategories);
                }
            }
            if (expandTop) {
                this.viewer.setAutoExpandLevel(2);
            }
            AdaptableList input = new AdaptableList(inputArray);
            this.viewer.addFilter((ViewerFilter)new WizardActivityFilter());
            this.viewer.setInput((Object)input);
        }

        protected TreeViewer getViewer() {
            return this.viewer;
        }

        private void layoutTopControl(Control control) {
            GridData data = new GridData(1808);
            int availableRows = DialogUtil.availableRows((Composite)control.getParent());
            data.heightHint = availableRows > 50 ? 200 : availableRows * 3;
            control.setLayoutData((Object)data);
        }
    }
}

