/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.validation.internal.util.XmlConfigurationElement;
import org.polarsys.capella.core.commands.preferences.model.CategoryPreferences;
import org.polarsys.capella.core.commands.preferences.model.CategoryPreferencesManager;
import org.polarsys.capella.core.commands.preferences.util.ExtensionPointItemDescriptor;
import org.polarsys.capella.core.preferences.commands.exceptions.ItemExistsException;

public class XmlPreferencesConfig {
    public static final String ELEMENT_ITEM = "item";
    public static final String ITEM_ID = "id";
    public static final String ITEM_NAME = "name";
    public static final String ITEM_IS_ENABLED_BY_DEFAULT = "enableByDefault";
    public static final String ITEM_DESCRIPTION = "description";
    public static final String CATEGORY_DESCRIPTION = "description";
    public static final String ELEMENT_CATEGORY = "category";
    public static final String ELEMENT_PROJECT_NATURE = "projectNature";
    public static final String PROJECT_NATURE_ID = "id";
    public static final String USER_PROFILE_MODE_NAME = "User Profile";
    public static final String USER_PROFILE_MODE_ID = "com.thalsegroup.mde.capella.preferences.user.expert.profile";
    public static final String E_CONSTRAINT_PROVIDER = "constraintProvider";
    public static final String A_MODE = "mode";
    public static final String A_CACHE = "cache";
    public static final String E_PACKAGE = "package";
    public static final String A_NAMESPACE_URI = "namespaceUri";
    public static final String E_CONSTRAINTS = "constraints";
    public static final String A_CATEGORIES = "categories";
    public static final String E_INCLUDED_CONSTRAINTS = "includedConstraints";
    public static final String A_LANG = "lang";
    public static final String A_SEVERITY = "severity";
    public static final String A_STATUS_CODE = "statusCode";
    public static final String A_CLASS = "class";
    public static final String E_INCLUDE = "include";
    public static final String A_PATH = "path";
    public static final String E_TARGET = "target";
    public static final String E_EVENT = "event";
    public static final String E_CUSTOM_EVENT = "customEvent";
    public static final String E_FEATURE = "feature";
    public static final String E_MESSAGE = "message";
    public static final String E_PARAM = "param";
    public static final String A_VALUE = "value";
    public static final String A_MANDATORY = "code";
    public static final String A_ENABLED = "enabled";

    private XmlPreferencesConfig() {
    }

    public static CategoryPreferences loadCategoryItems(IConfigurationElement constraints, CategoryPreferences parentCategory) throws CoreException, ItemExistsException {
        IConfigurationElement[] items = constraints.getChildren(ELEMENT_ITEM);
        if (items.length > 0 && parentCategory != null) {
            int i = 0;
            while (i < items.length) {
                IConfigurationElement currentItem = items[i];
                String path = currentItem.getAttribute("id");
                if (path != null && path.length() > 0) {
                    ExtensionPointItemDescriptor item = new ExtensionPointItemDescriptor(currentItem);
                    String name = currentItem.getAttribute(ITEM_NAME);
                    String mandatory = currentItem.getAttribute(A_MANDATORY);
                    parentCategory.addItem(item);
                }
                ++i;
            }
        }
        return parentCategory;
    }

    public static String getParameter(IConfigurationElement constraint, String name) {
        IConfigurationElement match = null;
        String result = null;
        IConfigurationElement[] parms = constraint.getChildren(E_PARAM);
        int i = 0;
        while (match == null && i < parms.length) {
            if (name.equals(parms[i].getAttribute(ITEM_NAME))) {
                match = parms[i];
            }
            ++i;
        }
        if (match != null && (result = match.getAttribute(A_VALUE)) == null) {
            result = match.getValue();
        }
        return result;
    }

    public static String[] getParameterValues(IConfigurationElement constraint, String name) {
        IConfigurationElement[] parms;
        ArrayList<String> result = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = parms = constraint.getChildren(E_PARAM);
        int n = parms.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (name.equals(element.getAttribute(ITEM_NAME))) {
                String value = element.getAttribute(A_VALUE);
                if (value == null) {
                    value = element.getValue();
                }
                if (value != null) {
                    result.add(value);
                }
            }
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    public static IConfigurationElement resolveCategories(IConfigurationElement constraints) {
        CategoryPreferencesManager mgr = CategoryPreferencesManager.getInstance();
        IConfigurationElement[] children = constraints.getChildren(ELEMENT_ITEM);
        String categories = constraints.getAttribute(A_CATEGORIES);
        if (categories == null) {
            categories = "";
        }
        ArrayList<CategoryPreferences> categoryList = new ArrayList<CategoryPreferences>(4);
        StringTokenizer tokens = new StringTokenizer(categories, ",");
        while (tokens.hasMoreTokens()) {
            CategoryPreferences category;
            String path = tokens.nextToken().trim();
            if (path.length() <= 0 || (category = mgr.findCategory(path)) == null) continue;
            categoryList.add(category);
        }
        if (!categoryList.isEmpty()) {
            CategoryPreferences[] categoryArray = categoryList.toArray(new CategoryPreferences[categoryList.size()]);
            IConfigurationElement[] iConfigurationElementArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    ExtensionPointItemDescriptor constraint = new ExtensionPointItemDescriptor(element);
                    CategoryPreferences[] categoryPreferencesArray = categoryArray;
                    int n3 = categoryArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        CategoryPreferences next = categoryPreferencesArray[n4];
                        next.addItem(constraint);
                        ++n4;
                    }
                }
                catch (ItemExistsException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        return constraints;
    }

    private static URL getBaseUrl(IConfigurationElement element) {
        if (element instanceof XmlConfigurationElement) {
            return ((XmlConfigurationElement)element).getBaseUrl();
        }
        return Platform.getBundle((String)element.getDeclaringExtension().getNamespaceIdentifier()).getEntry("/");
    }

    public static IConfigurationElement[] getEvents(IConfigurationElement config) {
        IConfigurationElement[] events = config.getChildren(E_EVENT);
        IConfigurationElement[] customEvents = config.getChildren(E_CUSTOM_EVENT);
        IConfigurationElement[] result = new IConfigurationElement[events.length + customEvents.length];
        System.arraycopy(events, 0, result, 0, events.length);
        System.arraycopy(customEvents, 0, result, events.length, customEvents.length);
        return result;
    }
}

