/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.ui;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.polarsys.capella.core.commands.preferences.internalization.l10n.PreferencesUIMessages;
import org.polarsys.capella.core.commands.preferences.preferences.ConfigurabilityPreferences;
import org.polarsys.capella.core.commands.preferences.service.AbstractDefaultPreferencePage;
import org.polarsys.capella.core.commands.preferences.service.PreferencesItemsRegistry;
import org.polarsys.capella.core.commands.preferences.service.UserProfileModeEnum;
import org.polarsys.capella.core.commands.preferences.util.IUserProfileDescriptor;
import org.polarsys.capella.core.preferences.Activator;

public class UserProfilePreferencePage
extends AbstractDefaultPreferencePage {
    public static final String PROPERTY_PAGE_ID = "org.polarsys.capella.core.commands.preferences.ui.validationPreferencePage";
    private Composite expertUserComposite;
    private Composite userCompsite;
    private Button expertUserField;
    private Button userField;
    private IUserProfileDescriptor userProfileDescriptor;

    public UserProfilePreferencePage() {
        super(PROPERTY_PAGE_ID);
    }

    @Override
    protected Control createContents(Composite parent) {
        Composite fieldEditorParent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        fieldEditorParent.setLayout((Layout)layout);
        fieldEditorParent.setFont(parent.getFont());
        this.createFieldEditors(fieldEditorParent);
        return fieldEditorParent;
    }

    public void applyToPreferences() {
        ConfigurabilityPreferences.setInstanceScopePreferenceItem(this.userProfileDescriptor.getId(), this.expertUserField.getSelection());
    }

    protected void performApply() {
        this.applyToPreferences();
        this.enablePreferencesPage(ConfigurabilityPreferences.isInstanceScopePreferenceItemEnabled("com.thalsegroup.mde.capella.preferences.user.expert.profile"));
    }

    @Override
    protected void createFieldEditors() {
    }

    protected void createFieldEditors(Composite panel) {
        GridLayout panelLayout = new GridLayout();
        panelLayout.numColumns = 1;
        panel.setLayout((Layout)panelLayout);
        GridData blockData = new GridData();
        blockData.grabExcessHorizontalSpace = true;
        blockData.horizontalAlignment = 4;
        blockData.horizontalSpan = 1;
        panel.setLayoutData((Object)blockData);
        this.createUserProfileGroup(panel);
        this.applyDialogFont(panel);
    }

    protected void initialize() {
        super.initialize();
    }

    private void createUserProfileGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PreferencesUIMessages.Validation_liveValidationGroupLabel);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        GridLayout subLayout = new GridLayout();
        subLayout.numColumns = 2;
        this.expertUserComposite = new Composite((Composite)group, 0);
        this.expertUserComposite.setLayout((Layout)subLayout);
        this.expertUserField = new Button(this.expertUserComposite, 16400);
        this.expertUserField.setSelection(false);
        new Label(this.expertUserComposite, 1).setText("Expert");
        this.expertUserField.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e_p) {
                UserProfilePreferencePage.this.setCheckboxesEnablement(UserProfileModeEnum.Expert);
            }

            public void widgetDefaultSelected(SelectionEvent e_p) {
            }
        });
        this.userCompsite = new Composite((Composite)group, 0);
        this.userCompsite.setLayout((Layout)subLayout);
        this.userField = new Button(this.userCompsite, 16400);
        this.userField.setSelection(true);
        new Label(this.userCompsite, 1).setText("Standard");
        this.userField.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e_p) {
                UserProfilePreferencePage.this.setCheckboxesEnablement(UserProfileModeEnum.User);
            }

            public void widgetDefaultSelected(SelectionEvent e_p) {
            }
        });
        this.initializeUserModeProfile();
    }

    private void initializeUserModeProfile() {
        this.userProfileDescriptor = (IUserProfileDescriptor)PreferencesItemsRegistry.getProfileDescriptor();
        boolean isExpertMode = ConfigurabilityPreferences.isInstanceScopePreferenceItemEnabled(this.userProfileDescriptor.getId());
        this.expertUserComposite.setEnabled(!isExpertMode);
        this.userCompsite.setEnabled(isExpertMode);
        this.expertUserField.setSelection(isExpertMode);
        this.userField.setSelection(!isExpertMode);
    }

    void setCheckboxesEnablement(UserProfileModeEnum newUserProfileMode) {
        if (newUserProfileMode != null) {
            this.expertUserComposite.setEnabled(!UserProfileModeEnum.Expert.equals((Object)newUserProfileMode));
            this.userCompsite.setEnabled(!UserProfileModeEnum.User.equals((Object)newUserProfileMode));
            this.expertUserField.setSelection(UserProfileModeEnum.Expert.equals((Object)newUserProfileMode));
            this.userField.setSelection(UserProfileModeEnum.User.equals((Object)newUserProfileMode));
        } else {
            this.expertUserComposite.setEnabled(true);
            this.userCompsite.setEnabled(true);
            this.userField.setSelection(true);
            this.expertUserField.setSelection(false);
        }
    }

    @Override
    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    @Override
    public boolean performOk() {
        this.applyToPreferences();
        ConfigurabilityPreferences.save();
        return super.performOk();
    }

    @Override
    protected void performDefaults() {
        this.expertUserField.setSelection(true);
        this.expertUserComposite.setEnabled(true);
        this.userField.setSelection(false);
        this.userCompsite.setEnabled(true);
        super.performDefaults();
    }

    @Override
    public void init(IWorkbench workbench) {
    }

    @Override
    protected String getPageTitle() {
        return PreferencesUIMessages.Validation_liveValidationGroupLabel;
    }

    @Override
    protected String getPageDescription() {
        return "";
    }

    @Override
    protected String getPageId() {
        return PROPERTY_PAGE_ID;
    }
}

