/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.service;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.osgi.service.prefs.BackingStoreException;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.commands.preferences.service.IPropertyPersistentPreferenceStore;

public class PropertyStore
extends PreferenceStore
implements IPropertyPersistentPreferenceStore {
    private static final Logger logger = ReportManagerRegistry.getInstance().subscribe("User Interface");
    private static Set<IPropertyChangeListener> guestListener = new HashSet<IPropertyChangeListener>();
    private IResource resource;
    private IPreferenceStore workbenchStore;
    private String pageId;
    private boolean inserting = false;
    private boolean isCanceled;

    public IResource getResource() {
        return this.resource;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public PropertyStore(IResource _resource, IPreferenceStore _workbenchStore, String id) {
        this.resource = _resource;
        this.workbenchStore = _workbenchStore;
        this.pageId = id;
    }

    @Override
    public void initilizeGuestListeners() {
        for (IPropertyChangeListener iPropertyChangeListener : guestListener) {
            this.addPropertyChangeListener(iPropertyChangeListener);
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        super.firePropertyChangeEvent(name, oldValue, newValue);
    }

    @Override
    public void save() throws IOException {
        try {
            if (this.resource instanceof IProject && !this.isCanceled) {
                ProjectScope project = new ProjectScope((IProject)this.resource);
                this.writeProperties(project);
                project.getNode("org.polarsys.capella.core.preferences").flush();
            }
        }
        catch (BackingStoreException exception) {
            StringBuilder loggerMessage = new StringBuilder("PropertyStore : ");
            logger.warn((Object)loggerMessage.toString(), (Throwable)exception);
        }
    }

    public void save(OutputStream out, String header) throws IOException {
        this.writeProperties();
    }

    private void writeProperties() throws IOException {
        String[] preferences;
        String[] stringArray = preferences = super.preferenceNames();
        int n = preferences.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            try {
                this.setProperty(name, this.getString(name));
            }
            catch (CoreException e) {
                throw new IOException("PropertyStore.Cannot_write_resource_property" + name);
            }
            ++n2;
        }
    }

    private void writeProperties(ProjectScope project) throws IOException {
        String[] preferences;
        String[] stringArray = preferences = super.preferenceNames();
        int n = preferences.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            try {
                this.setProperty(name, this.getString(name));
                project.getNode("org.polarsys.capella.core.preferences").put(name, this.getString(name));
            }
            catch (CoreException e) {
                throw new IOException("PropertyStore.Cannot_write_resource_property" + name);
            }
            ++n2;
        }
    }

    private void setProperty(String name, String value) throws CoreException {
        this.resource.setPersistentProperty(new QualifiedName(this.pageId, name), value);
    }

    public boolean getDefaultBoolean(String name) {
        return this.workbenchStore.getDefaultBoolean(name);
    }

    public double getDefaultDouble(String name) {
        return this.workbenchStore.getDefaultDouble(name);
    }

    public float getDefaultFloat(String name) {
        return this.workbenchStore.getDefaultFloat(name);
    }

    public int getDefaultInt(String name) {
        return this.workbenchStore.getDefaultInt(name);
    }

    public long getDefaultLong(String name) {
        return this.workbenchStore.getDefaultLong(name);
    }

    public String getDefaultString(String name) {
        return this.workbenchStore.getDefaultString(name);
    }

    public boolean getBoolean(String name) {
        this.insertValue(name);
        return super.getBoolean(name);
    }

    public double getDouble(String name) {
        this.insertValue(name);
        return super.getDouble(name);
    }

    public float getFloat(String name) {
        this.insertValue(name);
        return super.getFloat(name);
    }

    public int getInt(String name) {
        this.insertValue(name);
        return super.getInt(name);
    }

    public long getLong(String name) {
        this.insertValue(name);
        return super.getLong(name);
    }

    public String getString(String name) {
        this.insertValue(name);
        return super.getString(name);
    }

    private synchronized void insertValue(String name) {
        if (this.inserting) {
            return;
        }
        if (super.contains(name)) {
            return;
        }
        this.inserting = true;
        String prop = null;
        try {
            prop = this.getProperty(name);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (prop == null) {
            prop = this.workbenchStore.getString(name);
        }
        if (prop != null) {
            this.setValue(name, prop);
        }
        this.inserting = false;
    }

    private String getProperty(String name) throws CoreException {
        return this.resource.getPersistentProperty(new QualifiedName(this.pageId, name));
    }

    public boolean contains(String name) {
        return this.workbenchStore.contains(name);
    }

    public void setToDefault(String name) {
        this.setValue(name, this.getDefaultString(name));
    }

    public boolean isDefault(String name) {
        String defaultValue = this.getDefaultString(name);
        if (defaultValue == null) {
            return false;
        }
        return defaultValue.equals(this.getString(name));
    }

    public static void addToGuestListener(IPropertyChangeListener listener) {
        guestListener.add(listener);
    }

    public void setCanceled(boolean b) {
        this.isCanceled = true;
    }
}

