/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.service;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.core.commands.preferences.util.PreferencesHelper;
import org.polarsys.capella.core.preferences.Activator;

public class PreferenceIntegerFieldEditor
extends IntegerFieldEditor {
    private int txtWidth;

    public PreferenceIntegerFieldEditor(String name, String labelText, Composite parent, int textLimit, int txtWidth) {
        this.txtWidth = txtWidth;
        this.init(name, labelText);
        this.setTextLimit(textLimit);
        this.setEmptyStringAllowed(false);
        this.setErrorMessage(JFaceResources.getString((String)"IntegerFieldEditor.errorMessage"));
        this.createControl(parent);
    }

    public PreferenceIntegerFieldEditor(String name, String labelText, Composite parent, int textLimit) {
        this(name, labelText, parent, textLimit, StringFieldEditor.UNLIMITED);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns);
        if (StringFieldEditor.UNLIMITED != this.txtWidth) {
            Text text = this.getTextControl();
            GridData gd = new GridData();
            gd.widthHint = this.txtWidth;
            text.setLayoutData((Object)gd);
        }
    }

    public IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    protected void fireValueChanged(String property, Object oldValue, Object newValue) {
        super.fireValueChanged(property, oldValue, newValue);
    }

    public String getPreferenceName() {
        IProject selectedProject;
        IProject iProject = selectedProject = PreferencesHelper.getSelectedEclipseProject() != null ? PreferencesHelper.getSelectedEclipseProject() : PreferencesHelper.getSelectedCapellaProject();
        if (selectedProject != null) {
            return String.valueOf(selectedProject.getName()) + "." + super.getPreferenceName();
        }
        return super.getPreferenceName();
    }
}

