/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.properties;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.wizards.IWizardRegistry;
import org.polarsys.capella.core.preferences.transferer.CapellaImportExportPreferences;

public class ExportPreferencesHandler
extends AbstractHandler {
    private static ExportPreferencesHandler instance;
    private static final int SIZING_WIZARD_WIDTH = 470;
    private static final int SIZING_WIZARD_HEIGHT = 550;
    private Command currentCommand;
    IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
    private static CapellaImportExportPreferences wizard;

    public static ExportPreferencesHandler getInstance(Command command) {
        if (instance == null) {
            instance = new ExportPreferencesHandler(command);
        }
        return instance;
    }

    protected String getWizardIdParameterId() {
        return "exportWizardId";
    }

    protected IWizardRegistry getWizardRegistry() {
        return PlatformUI.getWorkbench().getExportWizardRegistry();
    }

    private ExportPreferencesHandler(Command command_p) {
        this.currentCommand = command_p;
        this.activatePreferenceHandler();
    }

    private void activatePreferenceHandler() {
        this.handlerService.activateHandler(this.currentCommand.getId(), (IHandler)this, new Expression(){

            public EvaluationResult evaluate(IEvaluationContext context_p) throws CoreException {
                Object selection = context_p.getVariable("selection");
                boolean result = true;
                if (selection != null && selection instanceof ISelection) {
                    result = true;
                }
                return EvaluationResult.valueOf((boolean)result);
            }

            public void collectExpressionInfo(ExpressionInfo info) {
                info.markDefaultVariableAccessed();
            }
        });
        this.currentCommand.setHandler((IHandler)this);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (activeWorkbenchWindow == null) {
            return null;
        }
        wizard = new CapellaImportExportPreferences("export");
        IStructuredSelection selectionToPass = this.getSelectionToUse(event);
        wizard.init(activeWorkbenchWindow.getWorkbench(), selectionToPass);
        IDialogSettings workbenchSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings wizardSettings = workbenchSettings.getSection("ImportExportAction");
        if (wizardSettings == null) {
            wizardSettings = workbenchSettings.addNewSection("ImportExportAction");
        }
        wizard.setDialogSettings(wizardSettings);
        wizard.setForcePreviousAndNextButtons(true);
        Shell parent = activeWorkbenchWindow.getShell();
        WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
        dialog.create();
        dialog.getShell().setSize(Math.max(470, dialog.getShell().getSize().x), 550);
        activeWorkbenchWindow.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.ui.export_wizard_context");
        dialog.open();
        return null;
    }

    public static CapellaImportExportPreferences getWizard() {
        return wizard;
    }

    public void setWizard(CapellaImportExportPreferences wizard_p) {
        wizard = wizard_p;
    }

    protected IStructuredSelection getSelectionToUse(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }
}

