/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.metric.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class MetricTree<T> {
    private MetricTree<T> parent = null;
    private List<MetricTree<T>> children = new ArrayList<MetricTree<T>>();
    private T element;
    private int count = 0;

    public MetricTree(T element, MetricTree<T> parent) {
        this.element = element;
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public T getElement() {
        return this.element;
    }

    public int getCount() {
        return this.count;
    }

    public void increaseCount(int count) {
        this.count += count;
    }

    public MetricTree<T> getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public List<MetricTree<T>> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void addChild(MetricTree<T> child) {
        this.children.add(child);
    }

    public void clear() {
        this.parent = null;
        this.element = null;
        if (this.getChildren() != null) {
            for (MetricTree<T> current : this.getChildren()) {
                current.clear();
            }
            this.children.clear();
        }
    }

    public List<MetricTree<T>> getLeafs() {
        ArrayList<MetricTree<T>> leafs = new ArrayList<MetricTree<T>>();
        Stack<MetricTree<T>> stack = new Stack<MetricTree<T>>();
        stack.push(this);
        while (!stack.isEmpty()) {
            MetricTree tree = (MetricTree)stack.pop();
            if (tree.getChildren().isEmpty()) {
                leafs.add(tree);
                continue;
            }
            stack.addAll(tree.getChildren());
        }
        return leafs;
    }
}

