/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.handler.helpers;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.kitalpha.emde.model.Element;

public class CapellaAdapterHelper {
    public static EObject resolveEObject(Object object) {
        return CapellaAdapterHelper.resolveEObject(object, false, false);
    }

    public static EObject resolveSemanticObject(Object object) {
        return CapellaAdapterHelper.resolveEObject(object, true, false);
    }

    public static EObject resolveBusinessObject(Object object) {
        return CapellaAdapterHelper.resolveEObject(object, true, true);
    }

    public static Collection<EObject> resolveEObjects(Collection<?> objects) {
        return CapellaAdapterHelper.resolveEObjects(objects, false, false);
    }

    public static Collection<EObject> resolveSemanticObjects(Collection<?> objects) {
        return CapellaAdapterHelper.resolveEObjects(objects, true, false);
    }

    public static Collection<EObject> resolveBusinessObjects(Collection<?> objects) {
        return CapellaAdapterHelper.resolveEObjects(objects, true, true);
    }

    public static Collection<EObject> resolveDescriptorsOrBusinessObjects(Collection<?> objects) {
        return objects.stream().map(CapellaAdapterHelper::resolveDescriptorOrBusinessObject).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Collection<EObject> resolveEObjects(Collection<?> objects, boolean onlySemantic, boolean onlyBusiness) {
        return objects.stream().map(x -> CapellaAdapterHelper.resolveEObject(x, onlySemantic, onlyBusiness)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static EObject resolveEObject(Object object, boolean onlySemantic, boolean onlyBusiness) {
        EObject result = null;
        EObject adapt = null;
        if (object instanceof DRepresentation) {
            object = RepresentationHelper.getRepresentationDescriptor((DRepresentation)object);
        }
        if ((adapt = (EObject)Adapters.adapt((Object)object, EObject.class, (boolean)true)) instanceof EObject) {
            result = adapt;
        }
        if (onlySemantic) {
            if (result instanceof DSemanticDecorator) {
                result = ((DSemanticDecorator)result).getTarget();
            } else if (result instanceof DRepresentationDescriptor) {
                result = ((DRepresentationDescriptor)result).getTarget();
            }
            adapt = result != null ? (EObject)Adapters.adapt((Object)result, Element.class, (boolean)true) : (EObject)Adapters.adapt((Object)object, Element.class, (boolean)true);
            if (adapt instanceof Element) {
                result = adapt;
            }
            if (result instanceof Element ? !(object instanceof Project) && result.eContainer() == null || result.eResource() == null : !CapellaResourceHelper.isSemanticElement(result)) {
                return null;
            }
        }
        if (onlyBusiness && result instanceof Element) {
            result = CapellaAdapterHelper.getBusinessObject((Element)result);
        }
        return result;
    }

    private static EObject getBusinessObject(Element object) {
        AbstractType type;
        boolean allowMultiplePart;
        if (object.eClass().equals(CsPackage.eINSTANCE.getPart()) && !(allowMultiplePart = CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)object))) && (type = ((Part)object).getAbstractType()) != null && !(type instanceof ConfigurationItem)) {
            return type;
        }
        return object;
    }

    @Deprecated
    public static Collection<EObject> resolveSemanticsObjects(Collection<?> objects) {
        return CapellaAdapterHelper.resolveSemanticObjects(objects);
    }

    @Deprecated
    public static Collection<EObject> resolveSemanticObjects(Collection<?> objects, boolean onlySemantic) {
        return objects.stream().map(x -> CapellaAdapterHelper.resolveSemanticObject(x, onlySemantic)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Deprecated
    public static EObject resolveSemanticObject(Object object, boolean onlySemantic) {
        EObject result = CapellaAdapterHelper.resolveEObject(object, false, false);
        if (result instanceof DRepresentation || result instanceof DRepresentationDescriptor) {
            return CapellaAdapterHelper.resolveEObject(result, onlySemantic, false);
        }
        if (result != null) {
            return CapellaAdapterHelper.resolveEObject(result, true, true);
        }
        return CapellaAdapterHelper.resolveEObject(object, true, true);
    }

    public static EObject resolveDescriptorOrBusinessObject(Object object) {
        return CapellaAdapterHelper.resolveSemanticObject(object, false);
    }
}

