/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.StrictCompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.PasteFromClipboardCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.model.copypaste.SharedCopyPasteElements;
import org.polarsys.capella.common.model.copypaste.SharedCutPasteClipboard;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.capellacore.InvolverElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalPathInvolvement;
import org.polarsys.capella.core.data.fa.AbstractFunctionAllocation;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.datatype.Enumeration;
import org.polarsys.capella.core.data.information.datavalue.EnumerationLiteral;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.platform.sirius.ui.commands.NameCollisionHelper;
import org.polarsys.capella.core.platform.sirius.ui.commands.PasteCommandHelper;

public class CapellaPasteCommand
extends PasteFromClipboardCommand {
    private NameCollisionHelper ncHelper = NameCollisionHelper.getDefault();
    private boolean pasteAfterCut;
    private CopyCommand.Helper _copyHelper;

    public CapellaPasteCommand(EditingDomain domain, Object owner, Object feature, int index) {
        super(domain, owner, feature, index);
    }

    public void doExecute() {
        Collection clipboard = this.domain.getClipboard();
        if (this.pasteAfterCut) {
            clipboard = SharedCutPasteClipboard.getCutClipboard().getClipboard();
            clipboard.clear();
        }
        Collection<AbstractNamedElement> collidingObjects = this.ncHelper.findConflictingElements((Collection<?>)((EObject)this.owner).eContents(), clipboard);
        super.doExecute();
        ArrayList<AbstractNamedElement> pastedObjectsWithNameCollision = new ArrayList<AbstractNamedElement>(collidingObjects.size());
        for (AbstractNamedElement object : collidingObjects) {
            pastedObjectsWithNameCollision.add((AbstractNamedElement)this._copyHelper.getCopy((EObject)object));
        }
        this.ncHelper.handleNamingCollision(pastedObjectsWithNameCollision, (EObject)this.owner);
        if (this._copyHelper != null) {
            this._copyHelper.clear();
        }
    }

    protected boolean doPrepare() {
        this.command = new StrictCompoundCommand(){

            protected boolean prepare() {
                this.isPessimistic = true;
                return super.prepare();
            }
        };
        final Command copyCommand = this.createCopyCommand();
        if (copyCommand != UnexecutableCommand.INSTANCE) {
            this.command.append(copyCommand);
        }
        if (this.domain != null) {
            this.command.append((Command)new CommandWrapper(){

                protected Command createCommand() {
                    CompoundCommand compoundCommand = new CompoundCommand();
                    for (Object objectToCopy : CapellaPasteCommand.this.domain.getClipboard()) {
                        if (objectToCopy instanceof Association) {
                            Association association = (Association)objectToCopy;
                            CapellaPasteCommand.this.prepareAssociationPaste(association, compoundCommand);
                            continue;
                        }
                        if (objectToCopy instanceof ComponentFunctionalAllocation) {
                            ComponentFunctionalAllocation componentFunctionalAllocation = (ComponentFunctionalAllocation)objectToCopy;
                            CapellaPasteCommand.this.prepareComponentFunctionalAllocationPaste(componentFunctionalAllocation, compoundCommand);
                            continue;
                        }
                        if (objectToCopy instanceof EnumerationLiteral) {
                            EnumerationLiteral enumerationLiteral = (EnumerationLiteral)objectToCopy;
                            CapellaPasteCommand.this.prepareEnumerationLiteralPaste(enumerationLiteral, compoundCommand);
                            continue;
                        }
                        if (objectToCopy instanceof FunctionalChainInvolvement || objectToCopy instanceof PhysicalPathInvolvement) {
                            Involvement involvement = (Involvement)objectToCopy;
                            CapellaPasteCommand.this.prepareInvolvementPaste(involvement, compoundCommand);
                            continue;
                        }
                        if (!(objectToCopy instanceof Component)) continue;
                        Component component = (Component)objectToCopy;
                        if (!(CapellaPasteCommand.this.owner instanceof EObject) || CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)((EObject)CapellaPasteCommand.this.owner)))) continue;
                        CapellaPasteCommand.this.prepareComponentPaste(component, compoundCommand);
                    }
                    if (compoundCommand.isEmpty()) {
                        compoundCommand.appendAndExecute((Command)new IdentityCommand());
                    }
                    return compoundCommand;
                }
            });
        }
        this.command.append((Command)new CommandWrapper(){

            protected Command createCommand() {
                CompoundCommand addCommands;
                Collection pasteElements = copyCommand.getResult();
                final IStatus status = PasteCommandHelper.createPasteCommands(pasteElements, addCommands = new CompoundCommand(), (EObject)CapellaPasteCommand.this.owner, (EStructuralFeature)CapellaPasteCommand.this.feature, CapellaPasteCommand.this.domain, CapellaPasteCommand.this.index, true);
                if (!status.isOK()) {
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            StatusManager.getManager().handle(status, 2);
                        }
                    });
                }
                return addCommands;
            }
        });
        boolean result = false;
        result = this.optimize && this.domain != null ? this.optimizedCanExecute() : this.command.canExecute();
        return result;
    }

    private Command createCopyCommand() {
        Collection collection = null;
        if (this.domain != null) {
            collection = this.domain.getClipboard();
        }
        if (collection == null || collection.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        this._copyHelper = new CopyCommand.Helper();
        CompoundCommand copyCommand = new CompoundCommand(Integer.MAX_VALUE);
        for (Object object : collection) {
            copyCommand.append(this.domain.createCommand(CopyCommand.class, new CommandParameter(object, null, (Object)this._copyHelper)));
        }
        return copyCommand.unwrap();
    }

    private Property getOppositeEnd(Association association, Property property) {
        Property result = null;
        if (association.getNavigableMembers().size() == 2) {
            ArrayList ends = new ArrayList(association.getNavigableMembers());
            ends.remove(property);
            if (ends.size() == 1) {
                result = (Property)ends.get(0);
            }
        }
        return result;
    }

    protected boolean prepare() {
        if (!(this.owner instanceof EObject)) {
            return false;
        }
        if (SharedCutPasteClipboard.getCutClipboard().hasCut()) {
            Collection cutElements = SharedCutPasteClipboard.getCutClipboard().getClipboard();
            this.command = new StrictCompoundCommand();
            CompoundCommand addCommands = new CompoundCommand();
            PasteCommandHelper.createPasteCommands(cutElements, addCommands, (EObject)this.owner, (EStructuralFeature)this.feature, this.domain, this.index, true);
            this.command.append((Command)addCommands);
            boolean result = this.command.canExecute();
            this.pasteAfterCut = true;
            return result;
        }
        return this.doPrepare();
    }

    protected void prepareEnumerationLiteralPaste(EnumerationLiteral enumerationLiteral, CompoundCommand compoundCommand) {
        EnumerationLiteral copiedEnumerationLiteral = (EnumerationLiteral)this._copyHelper.getCopy((EObject)enumerationLiteral);
        if (this.owner instanceof Enumeration) {
            compoundCommand.appendAndExecute(SetCommand.create((EditingDomain)this.domain, (Object)copiedEnumerationLiteral, (Object)ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE, (Object)this.owner));
        }
    }

    private void prepareComponentFunctionalAllocationPaste(ComponentFunctionalAllocation componentFunctionalAllocation, CompoundCommand compoundCommand) {
        if (this.owner != null && componentFunctionalAllocation != null && componentFunctionalAllocation.getTargetElement() != null && this.owner instanceof TraceableElement) {
            AbstractFunctionAllocation functionalAllocation = (AbstractFunctionAllocation)this._copyHelper.get((Object)componentFunctionalAllocation);
            compoundCommand.appendAndExecute(SetCommand.create((EditingDomain)this.domain, (Object)functionalAllocation, (Object)ModellingcorePackage.Literals.ABSTRACT_TRACE__SOURCE_ELEMENT, (Object)this.owner));
        }
    }

    private void prepareInvolvementPaste(Involvement involvement, CompoundCommand compoundCommand) {
        block6: {
            if (involvement == null || involvement.getInvolver() == null) break block6;
            Involvement inv = (Involvement)this._copyHelper.getCopy((EObject)involvement);
            if (this.owner instanceof InvolverElement) {
                if (inv instanceof FunctionalChainInvolvement) {
                    for (FunctionalChainInvolvement nextInv : ((FunctionalChainInvolvement)inv).getNextFunctionalChainInvolvements()) {
                        if (nextInv.eContainer() == null) continue;
                        compoundCommand.append(RemoveCommand.create((EditingDomain)this.domain, (Object)inv, (Object)FaPackage.Literals.FUNCTIONAL_CHAIN_INVOLVEMENT__NEXT_FUNCTIONAL_CHAIN_INVOLVEMENTS, (Object)nextInv));
                    }
                } else if (inv instanceof PhysicalPathInvolvement) {
                    for (PhysicalPathInvolvement nextInv : ((PhysicalPathInvolvement)inv).getNextInvolvements()) {
                        if (nextInv.eContainer() == null) continue;
                        compoundCommand.append(RemoveCommand.create((EditingDomain)this.domain, (Object)inv, (Object)CsPackage.Literals.PHYSICAL_PATH_INVOLVEMENT__NEXT_INVOLVEMENTS, (Object)nextInv));
                    }
                }
            }
        }
    }

    private void prepareComponentPaste(Component component, CompoundCommand compoundCommand) {
        EObject pastedComponent = this._copyHelper.getCopy((EObject)component);
        EReference ownedPartFeature = null;
        if (this.owner instanceof Component) {
            ownedPartFeature = CapellacorePackage.Literals.CLASSIFIER__OWNED_FEATURES;
        } else if (this.owner instanceof ComponentPkg) {
            ownedPartFeature = CsPackage.Literals.COMPONENT_PKG__OWNED_PARTS;
        }
        if (pastedComponent instanceof Component && ownedPartFeature != null) {
            Object createdPart;
            Command createPartCmd = CreateChildCommand.create((EditingDomain)this.domain, (Object)this.owner, (Object)new CommandParameter(this.owner, (Object)ownedPartFeature, (Object)CsFactory.eINSTANCE.createPart()), Collections.emptyList());
            compoundCommand.append(createPartCmd);
            Collection result = createPartCmd.getResult();
            if (result.size() == 1 && (createdPart = result.iterator().next()) instanceof Part) {
                compoundCommand.append(SetCommand.create((EditingDomain)this.domain, createdPart, (Object)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (Object)((Component)pastedComponent).getName()));
                compoundCommand.append(SetCommand.create((EditingDomain)this.domain, createdPart, (Object)ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE, (Object)pastedComponent));
            }
        }
    }

    protected void prepareAssociationPaste(Association association, CompoundCommand compoundCommand) {
        EList navigableMembers = association.getNavigableMembers();
        Association copiedAssociation = (Association)this._copyHelper.getCopy((EObject)association);
        for (Property property : navigableMembers) {
            if (this._copyHelper.get((Object)property) != null) continue;
            copiedAssociation.getNavigableMembers().remove((Object)property);
            compoundCommand.appendAndExecute(this.domain.createCommand(CopyCommand.class, new CommandParameter((Object)property, null, (Object)this._copyHelper)));
            final Property copiedProperty = (Property)this._copyHelper.getCopy((EObject)property);
            if (association.getNavigableMembers().size() == 2 && this._copyHelper.get((Object)property.eContainer()) == null && this._copyHelper.get((Object)this.getOppositeEnd(association, property).eContainer()) != null) {
                compoundCommand.appendAndExecute(AddCommand.create((EditingDomain)this.domain, (Object)copiedAssociation, (Object)InformationPackage.Literals.ASSOCIATION__OWNED_MEMBERS, (Object)copiedProperty));
                Object clipboardType = SharedCopyPasteElements.getInstance().getCopyObject((Object)property.getAbstractType());
                AbstractType copiedType = (AbstractType)this._copyHelper.get(clipboardType);
                compoundCommand.appendAndExecute(SetCommand.create((EditingDomain)this.domain, (Object)copiedProperty, (Object)ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE, (Object)copiedType));
                continue;
            }
            final EObject newPropertyOwner = property.eContainer();
            compoundCommand.appendAndExecute(AddCommand.create((EditingDomain)this.domain, (Object)newPropertyOwner, (Object)CapellacorePackage.Literals.CLASSIFIER__OWNED_FEATURES, (Object)copiedProperty));
            compoundCommand.appendAndExecute((Command)new CommandWrapper(){

                protected Command createCommand() {
                    CapellaPasteCommand.this.ncHelper.handleNamingCollision(Collections.singletonList(copiedProperty), newPropertyOwner);
                    return SetCommand.create((EditingDomain)CapellaPasteCommand.this.domain, (Object)copiedProperty, (Object)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (Object)copiedProperty.getName());
                }
            });
            compoundCommand.appendAndExecute(AddCommand.create((EditingDomain)this.domain, (Object)copiedAssociation, (Object)InformationPackage.Literals.ASSOCIATION__NAVIGABLE_MEMBERS, (Object)copiedProperty));
        }
    }
}

