/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.actions;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalLinkCategory;
import org.polarsys.capella.core.platform.sirius.ui.actions.CreateCategoriesController;
import org.polarsys.capella.core.platform.sirius.ui.actions.Messages;

public class CreatePLCategoriesController
extends CreateCategoriesController {
    @Override
    public void createAndAttachCategory(List<EObject> selection, String categoryNameToUse) {
        List<EClass> componentEClass = Arrays.asList(CsPackage.Literals.COMPONENT, CsPackage.Literals.COMPONENT_PKG);
        EObject categoryContainer = this.getBestContainerForCategory(selection, componentEClass);
        if (this.isNullOrNotInstanceOf(categoryContainer, componentEClass)) {
            return;
        }
        PhysicalLinkCategory category = (PhysicalLinkCategory)this.createCategory(categoryContainer);
        String categoryName = null;
        categoryName = categoryNameToUse != null ? categoryNameToUse : this.askCategoryName(category.getName());
        if (categoryName != null) {
            category.setName(categoryName);
            if (categoryContainer instanceof Component) {
                ((Component)categoryContainer).getOwnedPhysicalLinkCategories().add((Object)category);
            } else if (categoryContainer instanceof ComponentPkg) {
                ((ComponentPkg)categoryContainer).getOwnedPhysicalLinkCategories().add((Object)category);
            }
            for (EObject fe : selection) {
                if (!(fe instanceof PhysicalLink)) continue;
                category.getLinks().add((Object)((PhysicalLink)fe));
            }
            this.logResults(Messages.CreatePLCategoriesController_creation_msg, (NamedElement)category);
        }
    }

    @Override
    protected EObject createCategory(EObject container) {
        EReference feature;
        PhysicalLinkCategory category = CsFactory.eINSTANCE.createPhysicalLinkCategory();
        if (container instanceof Component) {
            feature = CsPackage.eINSTANCE.getComponent_OwnedPhysicalLinkCategories();
        } else if (container instanceof ComponentPkg) {
            feature = CsPackage.eINSTANCE.getComponentPkg_OwnedPhysicalLinkCategories();
        } else {
            return category;
        }
        String defaultName = EcoreUtil2.getUniqueName((EObject)category, (EObject)container, (EStructuralFeature)feature, (EAttribute)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (String)Messages.CreatePLCategoriesController_prefix);
        category.setName(defaultName);
        return category;
    }
}

