/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.actions;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.refresh.RefreshDiagramAction;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.ui.actions.AbstractTigAction;
import org.polarsys.capella.core.platform.sirius.ui.actions.CreateCategoriesController;
import org.polarsys.capella.core.platform.sirius.ui.actions.Messages;
import org.polarsys.capella.core.platform.sirius.ui.actions.UpdateCategoriesController;
import org.polarsys.capella.core.platform.sirius.ui.actions.WizardActionHelper;

public class CreateCategoriesWizardAction
extends AbstractTigAction {
    private CreateCategoriesController _createCatController;

    public void run(IAction action) {
        final List<EObject> selection = WizardActionHelper.converToEObjectList(this.getSelectedElements());
        if (selection.isEmpty()) {
            return;
        }
        if (UpdateCategoriesController.isValidSelection(selection)) {
            AbstractReadWriteCommand doModelUpdateCmd = new AbstractReadWriteCommand(){

                public String getName() {
                    return "Create Category";
                }

                public void run() {
                    CreateCategoriesWizardAction.this.handleChanges(selection);
                }
            };
            this.getExecutionManager().execute((ICommand)doModelUpdateCmd);
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ISelection diagramSelection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
                    RefreshDiagramAction.refresh((ISelection)diagramSelection);
                }
            });
        } else {
            WizardActionHelper.createMessageBox(this.getActiveShell(), Messages.UpdateCategoriesWizardAction_Warning_Message, 2);
        }
    }

    void handleChanges(List<EObject> selection) {
        this._createCatController = CreateCategoriesController.createCreateCategoriesController(selection);
        this._createCatController.createAndAttachCategory(selection);
    }
}

