/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.wizards.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.menus.AbstractContributionFactory;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.services.IServiceLocator;

public class SlavePopulatorMenuService
implements IMenuService {
    private Collection providers = new ArrayList();
    private Collection factories = new ArrayList();
    private final IMenuService parent;
    private IServiceLocator serviceLocator;
    private Set restrictionExpression;

    public SlavePopulatorMenuService(IMenuService parent, IServiceLocator serviceLocator, Set restrictions) {
        this.restrictionExpression = restrictions;
        this.parent = parent;
        this.serviceLocator = serviceLocator;
    }

    public void populateContributionManager(ContributionManager mgr, String uri) {
        this.parent.populateContributionManager(mgr, uri);
    }

    public IEvaluationContext getCurrentState() {
        IEvaluationContext parentA = this.parent.getCurrentState();
        ISelection value = ((ISelectionService)this.serviceLocator.getService(ISelectionService.class)).getSelection();
        if (value == null) {
            value = new StructuredSelection();
        }
        EvaluationContext context = new EvaluationContext(parentA, (Object)((IStructuredSelection)value).toList());
        context.addVariable("selection", (Object)value);
        return context;
    }

    public void addContributionFactory(AbstractContributionFactory cache) {
        if (!this.factories.contains(cache)) {
            this.factories.add(cache);
        }
        this.parent.addContributionFactory(cache);
    }

    public void releaseContributions(ContributionManager mgr) {
        this.parent.releaseContributions(mgr);
    }

    public void removeContributionFactory(AbstractContributionFactory factory) {
        this.factories.remove(factory);
        this.parent.removeContributionFactory(factory);
    }

    public void dispose() {
        Object element;
        int n;
        int n2;
        Object[] objectArray;
        Object[] array;
        if (!this.providers.isEmpty()) {
            objectArray = array = this.providers.toArray();
            n2 = array.length;
            n = 0;
            while (n < n2) {
                element = objectArray[n];
                this.parent.removeSourceProvider((ISourceProvider)element);
                ++n;
            }
            this.providers.clear();
        }
        if (!this.factories.isEmpty()) {
            objectArray = array = this.factories.toArray();
            n2 = array.length;
            n = 0;
            while (n < n2) {
                element = objectArray[n];
                this.parent.removeContributionFactory((AbstractContributionFactory)element);
                ++n;
            }
            this.factories.clear();
        }
        this.restrictionExpression = null;
        this.serviceLocator = null;
    }

    public void addSourceProvider(ISourceProvider provider) {
        if (!this.providers.contains(provider)) {
            this.providers.add(provider);
        }
        this.parent.addSourceProvider(provider);
    }

    public void removeSourceProvider(ISourceProvider provider) {
        this.providers.remove(provider);
        this.parent.removeSourceProvider(provider);
    }
}

