/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.wizards.loader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.polarsys.capella.common.flexibility.properties.schema.IProperties;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyGroup;
import org.polarsys.capella.common.flexibility.wizards.renderer.Renderers;
import org.polarsys.capella.common.flexibility.wizards.schema.IGroupRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IPropertyRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IRenderers;
import org.polarsys.capella.common.flexibility.wizards.schema.WizardsSchemaConstants;

public class RenderersLoader {
    HashMap<String, Renderers> renderersByProperties = new HashMap();

    protected Renderers getStoredProperties(String idProperties) {
        return this.renderersByProperties.get(idProperties);
    }

    protected void setStoredProperties(String idProperties, Renderers properties) {
        this.renderersByProperties.put(idProperties, properties);
    }

    protected Renderers getOrCreateStoredProperties(String idProperties) {
        if (this.getStoredProperties(idProperties) == null) {
            this.setStoredProperties(idProperties, new Renderers());
        }
        return this.getStoredProperties(idProperties);
    }

    public IRenderers getRenderers(IProperties properties) {
        Collection elements;
        HashMap<String, IConfigurationElement> renderersMap = new HashMap<String, IConfigurationElement>();
        HashMap<String, ArrayList<IConfigurationElement>> renderersBindingMapByProperties = new HashMap<String, ArrayList<IConfigurationElement>>();
        HashMap renderersBindingMapByProperty = new HashMap();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList<IConfigurationElement> extensions = new ArrayList<IConfigurationElement>();
        extensions.addAll(Arrays.asList(registry.getConfigurationElementsFor(WizardsSchemaConstants.PropertiesSchema_ID)));
        extensions.addAll(Arrays.asList(registry.getConfigurationElementsFor(WizardsSchemaConstants.PropertiesSchema_SCHEMA_ID)));
        for (IConfigurationElement extension : extensions) {
            String idRenderer;
            if (extension.getName().equals(WizardsSchemaConstants.PropertiesSchema_RENDERER)) {
                idRenderer = extension.getAttribute(WizardsSchemaConstants.PropertiesSchema_RENDERER_ID);
                renderersMap.put(idRenderer, extension);
                System.out.println("flexibility.wizards: migration is required for " + idRenderer);
            }
            if (extension.getName().equals(WizardsSchemaConstants.PropertiesSchema_PROPERTY_RENDERER)) {
                idRenderer = extension.getAttribute(WizardsSchemaConstants.PropertiesSchema_PROPERTY_RENDERER__ID);
                renderersMap.put(idRenderer, extension);
            }
            if (!extension.getName().equals(WizardsSchemaConstants.PropertiesSchema_GROUP_RENDERER)) continue;
            idRenderer = extension.getAttribute(WizardsSchemaConstants.PropertiesSchema_GROUP_RENDERER__ID);
            renderersMap.put(idRenderer, extension);
        }
        for (IConfigurationElement extension : extensions) {
            String propertiesId;
            if (extension.getName().equals(WizardsSchemaConstants.PropertiesSchema_RENDERERBINDING)) {
                propertiesId = extension.getAttribute(WizardsSchemaConstants.PropertiesSchema_RENDERERBINDING_PROPERTIESID);
                elements = (ArrayList<IConfigurationElement>)renderersBindingMapByProperties.get(propertiesId);
                if (elements == null) {
                    elements = new ArrayList<IConfigurationElement>();
                    renderersBindingMapByProperties.put(propertiesId, (ArrayList<IConfigurationElement>)elements);
                }
                elements.add(extension);
                System.out.println("flexibility.wizards: migration is required for binding to " + propertiesId);
            }
            if (!extension.getName().equals(WizardsSchemaConstants.PropertiesSchema_BINDINGS)) continue;
            propertiesId = extension.getAttribute(WizardsSchemaConstants.PropertiesSchema_BINDINGS__PROPERTIES);
            elements = (Collection)renderersBindingMapByProperties.get(propertiesId);
            if (elements == null) {
                elements = new ArrayList();
                renderersBindingMapByProperties.put(propertiesId, (ArrayList<IConfigurationElement>)elements);
            }
            elements.addAll(Arrays.asList(extension.getChildren(WizardsSchemaConstants.PropertiesSchema_PROPERTY_BINDING)));
            elements.addAll(Arrays.asList(extension.getChildren(WizardsSchemaConstants.PropertiesSchema_GROUP_BINDING)));
        }
        LinkedList<IProperties> toVisit = new LinkedList<IProperties>();
        toVisit.add(properties);
        while (toVisit.size() > 0) {
            IRenderer iRenderer;
            String nameClass;
            IConfigurationElement rendererExtention;
            String rendererId;
            String propertyId;
            IProperties parent = (IProperties)toVisit.removeFirst();
            if (parent == null) continue;
            Renderers childRenderers = this.getOrCreateStoredProperties(parent.getPropertiesId());
            for (IProperties properti : parent.getParents()) {
                Renderers parentRenderers = this.getOrCreateStoredProperties(properti.getPropertiesId());
                childRenderers.addParent(parentRenderers);
            }
            toVisit.addAll(parent.getParents());
            elements = (Collection)renderersBindingMapByProperties.get(parent.getPropertiesId());
            if (elements == null) continue;
            for (IProperty property : properties.getAllItems()) {
                for (IConfigurationElement extension : elements) {
                    propertyId = null;
                    rendererId = null;
                    if (extension.getName().equals(WizardsSchemaConstants.PropertiesSchema_RENDERERBINDING)) {
                        propertyId = extension.getAttribute(WizardsSchemaConstants.PropertiesSchema_RENDERERBINDING_PROPERTYID);
                        rendererId = extension.getAttribute(WizardsSchemaConstants.PropertiesSchema_RENDERERBINDING_RENDERERID);
                        System.out.println("flexibility.wizards: migration is required for renderer binding " + rendererId);
                    } else if (extension.getName().equals(WizardsSchemaConstants.PropertiesSchema_PROPERTY_BINDING)) {
                        propertyId = extension.getAttribute(WizardsSchemaConstants.PropertiesSchema_PROPERTY_BINDING__PROPERTY);
                        rendererId = extension.getAttribute(WizardsSchemaConstants.PropertiesSchema_PROPERTY_BINDING__RENDERER);
                    }
                    if (!property.getId().equals(propertyId)) continue;
                    try {
                        rendererExtention = (IConfigurationElement)renderersMap.get(rendererId);
                        if (rendererExtention == null) continue;
                        nameClass = "";
                        if (rendererExtention.getName().equals(WizardsSchemaConstants.PropertiesSchema_RENDERER)) {
                            nameClass = WizardsSchemaConstants.PropertiesSchema_RENDERER_CLASS;
                            System.out.println("flexibility.wizards: migration is required for renderer definition " + extension.getAttribute(nameClass));
                        } else if (rendererExtention.getName().equals(WizardsSchemaConstants.PropertiesSchema_PROPERTY_RENDERER)) {
                            nameClass = WizardsSchemaConstants.PropertiesSchema_PROPERTY_RENDERER__CLASS;
                        }
                        iRenderer = (IRenderer)rendererExtention.createExecutableExtension(nameClass);
                        if (iRenderer == null || !(iRenderer instanceof IPropertyRenderer)) continue;
                        childRenderers.addPropertyRenderer(property.getId(), (IPropertyRenderer)iRenderer);
                    }
                    catch (CoreException exception) {
                        exception.printStackTrace();
                    }
                }
            }
            for (IPropertyGroup group : properties.getAllGroups()) {
                for (IConfigurationElement extension : elements) {
                    propertyId = null;
                    rendererId = null;
                    if (extension.getName().equals(WizardsSchemaConstants.PropertiesSchema_GROUP_BINDING)) {
                        propertyId = extension.getAttribute(WizardsSchemaConstants.PropertiesSchema_GROUP_BINDING__GROUP);
                        rendererId = extension.getAttribute(WizardsSchemaConstants.PropertiesSchema_GROUP_BINDING__RENDERER);
                    }
                    if (!group.getId().equals(propertyId)) continue;
                    try {
                        rendererExtention = (IConfigurationElement)renderersMap.get(rendererId);
                        if (rendererExtention == null) continue;
                        nameClass = "";
                        if (rendererExtention.getName().equals(WizardsSchemaConstants.PropertiesSchema_GROUP_RENDERER)) {
                            nameClass = WizardsSchemaConstants.PropertiesSchema_GROUP_RENDERER__CLASS;
                        }
                        if ((iRenderer = (IRenderer)rendererExtention.createExecutableExtension(nameClass)) == null || !(iRenderer instanceof IGroupRenderer)) continue;
                        childRenderers.addGroupRenderer(group.getId(), (IGroupRenderer)iRenderer);
                    }
                    catch (CoreException exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        return this.getOrCreateStoredProperties(properties.getPropertiesId());
    }
}

