/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.menu.dynamic.contributions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EClass;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.common.menu.dynamic.contributions.IMDEMenuItemContribution;

public class ActionContributionProvider {
    public static final String CONTEXTUAL_MENU_PLUGIN_ID = "org.polarsys.capella.common.menu.dynamic";
    static final String MENU_ITEM_CONTRIBUTION_EXTENSION_ID = "MDEMenuItemContribution";
    private static ActionContributionProvider __instance;
    private Map<EClass, List<IMDEMenuItemContribution>> _menuContributions = new HashMap<EClass, List<IMDEMenuItemContribution>>(0);

    public static ActionContributionProvider getInstance() {
        if (__instance == null) {
            __instance = new ActionContributionProvider();
        }
        return __instance;
    }

    private ActionContributionProvider() {
        IConfigurationElement[] contributors;
        IConfigurationElement[] iConfigurationElementArray = contributors = ExtensionPointHelper.getConfigurationElements((String)CONTEXTUAL_MENU_PLUGIN_ID, (String)MENU_ITEM_CONTRIBUTION_EXTENSION_ID);
        int n = contributors.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement contributorElement = iConfigurationElementArray[n2];
            IMDEMenuItemContribution contribution = (IMDEMenuItemContribution)ExtensionPointHelper.createInstance((IConfigurationElement)contributorElement, (String)"class");
            EClass relatedMetaclass = contribution.getMetaclass();
            List<IMDEMenuItemContribution> menuContributionsForRelatedMetaclass = this._menuContributions.get(relatedMetaclass);
            if (menuContributionsForRelatedMetaclass == null) {
                menuContributionsForRelatedMetaclass = new ArrayList<IMDEMenuItemContribution>(1);
                this._menuContributions.put(relatedMetaclass, menuContributionsForRelatedMetaclass);
            }
            menuContributionsForRelatedMetaclass.add(contribution);
            ++n2;
        }
    }

    public List<IMDEMenuItemContribution> getAllActionContributions(EClass cls) {
        ArrayList<IMDEMenuItemContribution> result = new ArrayList<IMDEMenuItemContribution>();
        for (Map.Entry<EClass, List<IMDEMenuItemContribution>> entry : this._menuContributions.entrySet()) {
            EClass currentMetaclass = entry.getKey();
            if ((!currentMetaclass.isAbstract() || !currentMetaclass.isSuperTypeOf(cls)) && !currentMetaclass.equals(cls)) continue;
            result.addAll((Collection<IMDEMenuItemContribution>)entry.getValue());
        }
        return result;
    }
}

