/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.wizards;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.AbstractBijectiveTemplatePatternSpecification;
import org.eclipse.emf.diffmerge.patterns.ui.Messages;
import org.eclipse.emf.diffmerge.patterns.ui.viewers.ModelSubsetViewer;
import org.eclipse.emf.diffmerge.patterns.ui.viewers.RoleBindingViewer;
import org.eclipse.emf.diffmerge.patterns.ui.wizards.AbstractRoleSelectionPage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public abstract class AbstractTemplateElementsPage<T extends AbstractBijectiveTemplatePatternSpecification>
extends AbstractRoleSelectionPage<T> {
    public ModelSubsetViewer _templateElementsViewer;

    protected AbstractTemplateElementsPage(String title_p, String defaultMessage_p, T data_p) {
        super("ContentsPage", title_p, defaultMessage_p != null ? defaultMessage_p : Messages.AbstractTemplateElementsPage_Message, data_p, false);
    }

    protected boolean allowEdition() {
        return false;
    }

    public void createControl(Composite parent_p) {
        Composite mainComposite = new Composite(parent_p, 0);
        this.setControl((Control)mainComposite);
        GridLayout mainCompositeLayout = new GridLayout(2, false);
        mainComposite.setLayout((Layout)mainCompositeLayout);
        this.setDefaultMessage();
        this._templateElementsViewer = this.createTemplateElementControls(mainComposite);
        this.createRoleControls(mainComposite, this.allowEdition());
    }

    protected MenuItem createIsUniqueItem(Menu menu_p, final ModelSubsetViewer viewer_p) {
        final MenuItem result = new MenuItem(menu_p, 32);
        result.setText(Messages.AbstractTemplateElementsPage_Unique);
        result.setEnabled(false);
        result.setSelection(true);
        viewer_p.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enable;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                boolean bl = enable = AbstractTemplateElementsPage.this.allowEdition() && !selection.isEmpty();
                if (enable) {
                    EObject selected = (EObject)selection.getFirstElement();
                    enable = !((AbstractBijectiveTemplatePatternSpecification)AbstractTemplateElementsPage.this.getData()).isInstanceRelated(selected) && ((AbstractBijectiveTemplatePatternSpecification)AbstractTemplateElementsPage.this.getData()).getCounterpart(selected, false) != null;
                }
                result.setEnabled(enable);
            }
        });
        viewer_p.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                Object selected = viewer_p.getSelection().getFirstElement();
                if (selected instanceof EObject) {
                    EObject selectedElement = (EObject)selected;
                    EObject templateElement = ((AbstractBijectiveTemplatePatternSpecification)AbstractTemplateElementsPage.this.getData()).getCounterpart(selectedElement, false);
                    boolean select = !((AbstractBijectiveTemplatePatternSpecification)AbstractTemplateElementsPage.this.getData()).getPattern().getMultiElements().contains((Object)templateElement);
                    result.setSelection(select);
                }
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                Iterator it = viewer_p.getSelection().iterator();
                boolean first = true;
                while (it.hasNext()) {
                    boolean previouslySelected;
                    Object selected = it.next();
                    if (!(selected instanceof EObject)) continue;
                    EObject selectedElement = (EObject)selected;
                    EObject templateElement = ((AbstractBijectiveTemplatePatternSpecification)AbstractTemplateElementsPage.this.getData()).getCounterpart(selectedElement, false);
                    if (templateElement == null) continue;
                    EList multiElements = ((AbstractBijectiveTemplatePatternSpecification)AbstractTemplateElementsPage.this.getData()).getPattern().getMultiElements();
                    boolean bl = previouslySelected = !multiElements.contains(templateElement);
                    if (previouslySelected) {
                        multiElements.add(templateElement);
                    } else {
                        multiElements.remove(templateElement);
                    }
                    if (first) {
                        result.setSelection(!previouslySelected);
                        continue;
                    }
                    first = false;
                }
                viewer_p.refresh();
            }
        });
        return result;
    }

    protected void createMappingControls(Menu menu_p, ModelSubsetViewer viewer_p) {
    }

    protected void createNavigationControls(Menu menu_p, ModelSubsetViewer viewer_p) {
    }

    protected ModelSubsetViewer createModelViewer(Composite parent_p) {
        RoleBindingViewer resultViewer = new RoleBindingViewer(parent_p, true, false){

            @Override
            protected int getControlWidgetConfiguration() {
                int result = ModelSubsetViewer.SORT | ModelSubsetViewer.EXPAND | ModelSubsetViewer.COLLAPSE;
                if (AbstractTemplateElementsPage.this.showParentsCheckbox()) {
                    result |= ModelSubsetViewer.SHOW_PARENTS;
                }
                return result;
            }
        };
        ((ModelSubsetViewer)resultViewer).setInput(this.getData());
        return resultViewer;
    }

    protected void createScopeModificationControls(Menu menu_p, ModelSubsetViewer viewer_p) {
    }

    protected ModelSubsetViewer createTemplateElementControls(Composite parent_p) {
        Group contentsGroup = this.createTemplateElementsGroup(parent_p);
        ModelSubsetViewer result = this.createModelViewer((Composite)contentsGroup);
        Menu menu = new Menu((Control)result.getTreeViewer().getTree());
        this.createNavigationControls(menu, result);
        if (this.allowEdition()) {
            this.createMappingControls(menu, result);
        }
        this.createIsUniqueItem(menu, result);
        if (this.allowEdition()) {
            this.createScopeModificationControls(menu, result);
        }
        result.getTreeViewer().getTree().setMenu(menu);
        return result;
    }

    protected Group createTemplateElementsGroup(Composite parent_p) {
        return this.createGroup(parent_p, this.getElementsGroupName(), true, 1);
    }

    protected String getElementsGroupName() {
        return Messages.AbstractTemplateElementsPage_TemplateElements;
    }

    public boolean showParentsCheckbox() {
        return true;
    }
}

