/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.re.project.diffmerge;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.api.IComparison;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IElementPresence;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.diffdata.impl.EComparisonImpl;
import org.eclipse.emf.diffmerge.impl.scopes.FragmentedModelScope;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.model.skeleton.CapellaModelSkeleton;
import org.polarsys.capella.core.re.project.diffmerge.SkeletonMatchPolicy;

public class SkeletonUtil {
    private final EObject context;
    private IComparison comparison;

    public SkeletonUtil(EObject context) {
        this.context = context;
    }

    private static Project createSkeleton(EClass root, ExecutionManager manager) {
        return new CapellaModelSkeleton.Builder(manager).setRootType(root).build().getProject();
    }

    private IComparison getComparison() {
        if (this.comparison == null) {
            ExecutionManager skeletonManager = ExecutionManagerRegistry.getInstance().addNewManager();
            try {
                EObject first = this.context;
                Project project = SkeletonUtil.createSkeleton(EcoreUtil.getRootContainer((EObject)first).eClass(), skeletonManager);
                if (project != null) {
                    FragmentedModelScope targetScope = new FragmentedModelScope(first.eResource(), true);
                    FragmentedModelScope referenceScope = new FragmentedModelScope(project.eResource(), true);
                    this.comparison = new EComparisonImpl((IEditableModelScope)targetScope, (IEditableModelScope)referenceScope);
                    this.comparison.compute((IMatchPolicy)new SkeletonMatchPolicy(), null, null, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            finally {
                ExecutionManagerRegistry.getInstance().removeManager(skeletonManager);
            }
        }
        return this.comparison;
    }

    public boolean isSkeletonElement(EObject element) {
        IComparison c = this.getComparison();
        TreeIterator matchIterator = c.getAllContents(Role.REFERENCE);
        while (matchIterator.hasNext()) {
            IMatch next = (IMatch)matchIterator.next();
            if (next.get(Role.TARGET) != element) continue;
            return true;
        }
        return false;
    }

    public boolean hasReferenceToSkeleton(EObject element) {
        EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)element.eCrossReferences().iterator();
        while (featureIterator.hasNext()) {
            EObject referencedEObject = (EObject)featureIterator.next();
            EReference reference = (EReference)featureIterator.feature();
            if (reference.isDerived() || !this.isSkeletonElement(referencedEObject)) continue;
            return true;
        }
        return false;
    }

    public Collection<EObject> getSkeletonElements() {
        ArrayList<EObject> skeleton = new ArrayList<EObject>();
        IComparison c = this.getComparison();
        TreeIterator matchIterator = c.getAllContents(Role.REFERENCE);
        while (matchIterator.hasNext()) {
            IMatch next = (IMatch)matchIterator.next();
            if (next.get(Role.TARGET) == null) continue;
            skeleton.add(next.get(Role.TARGET));
        }
        return skeleton;
    }

    public Collection<EObject> getUserRoots() {
        ArrayList<EObject> elementsForRec = new ArrayList<EObject>();
        IComparison comparison = this.getComparison();
        for (IDifference diff : comparison.getRemainingDifferences()) {
            if (!(diff instanceof IElementPresence) || ((IElementPresence)diff).getPresenceRole() != Role.TARGET) continue;
            IElementPresence presence = (IElementPresence)diff;
            EObject element = presence.getElement();
            if (presence.getOwnerMatch() == null || presence.getOwnerMatch().get(Role.REFERENCE) == null) continue;
            elementsForRec.add(element);
        }
        return elementsForRec;
    }
}

