/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.viewer;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.ui.business.internal.session.SessionSaveable;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IJobRunnable;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.ActiveSessionManager;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.CapellaSaveSessionRunnable;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;

public class CapellaSaveable
extends SessionSaveable {
    public CapellaSaveable(Session session) {
        super(session);
    }

    public Object getAdapter(Class adapter) {
        if (Session.class == adapter) {
            return this.getSession();
        }
        return super.getAdapter(adapter);
    }

    public boolean isDirty() {
        Session currentSession;
        if (ActiveSessionManager.getInstance().isEnabledContentNotifications(this.getSession().getTransactionalEditingDomain()) && (currentSession = this.getSession()) != null && SessionManager.INSTANCE.getSessions().contains(currentSession)) {
            return SessionStatus.DIRTY.equals((Object)this.getSession().getStatus());
        }
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
        new CapellaSaveSessionRunnable(this.getSession()).run(monitor);
    }

    public IJobRunnable doSave(IProgressMonitor monitor, IShellProvider shellProvider) throws CoreException {
        return new CapellaSaveSessionRunnable(this.getSession());
    }

    public String getName() {
        String result = "";
        IFile analysisFile = SessionHelper.getFirstAnalysisFile((DAnalysisSession)((DAnalysisSession)this.getSession()));
        IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)analysisFile.getAdapter(IWorkbenchAdapter.class);
        result = workbenchAdapter != null ? workbenchAdapter.getLabel((Object)analysisFile) : analysisFile.getFullPath().toString();
        return result;
    }
}

