/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.viewer;

import java.util.Arrays;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.common.ui.tools.api.view.common.item.ItemDecorator;
import org.eclipse.sirius.diagram.sequence.description.SequenceDiagramDescription;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.ui.tools.api.views.common.item.ItemWrapper;
import org.eclipse.sirius.ui.tools.api.views.common.item.RepresentationDescriptionItem;
import org.eclipse.sirius.ui.tools.api.views.common.item.ViewpointItem;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.SystemColors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.navigator.IDescriptionProvider;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.model.copypaste.SharedCutPasteClipboard;
import org.polarsys.capella.common.ui.providers.MDEAdapterFactoryLabelProvider;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.CapellaNavigatorPlugin;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.RepresentationPackage;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.SessionLabelProviderHelper;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;

public class CapellaNavigatorLabelProvider
extends MDEAdapterFactoryLabelProvider
implements ILabelProvider,
IDescriptionProvider,
IFontProvider,
IColorProvider {
    private static final String STATUS_LINE_PATH_SEPARATOR = "::";
    private Font italicFont;
    private static final String DISABLED_REPRESENTATION_SUFFIX = "_disabled";

    public CapellaNavigatorLabelProvider() {
        Font currentFont = Display.getCurrent().getSystemFont();
        FontData[] datas = currentFont.getFontData();
        datas[0].setStyle(2);
        this.italicFont = new Font(currentFont.getDevice(), datas);
    }

    public Image getImage(Object object) {
        Image image = null;
        Optional<DRepresentationDescriptor> repDesc = this.getRepresentationDescriptor(object);
        if (repDesc.isPresent()) {
            image = super.getImage((Object)repDesc.get());
            if (!RepresentationHelper.isValid((DRepresentationDescriptor)repDesc.get())) {
                image = this.getDisabledImage(repDesc.get(), image);
            }
        } else if (object instanceof Session) {
            image = SessionLabelProviderHelper.getInstance().getSessionLabelProvider().getImage(object);
        } else if (object instanceof ItemDecorator) {
            image = ((ItemDecorator)object).getImage();
        } else if (object instanceof ViewpointItem) {
            image = CapellaNavigatorPlugin.getDefault().getImage("viewpoint.gif");
        } else if (object instanceof RepresentationDescriptionItem) {
            RepresentationDescriptionItem descriptionItem = (RepresentationDescriptionItem)object;
            image = !(descriptionItem.getWrappedObject() instanceof SequenceDiagramDescription) ? CapellaNavigatorPlugin.getDefault().getImage("diagram-type.gif") : super.getImage(((ItemWrapper)object).getWrappedObject());
        } else if (object instanceof ItemWrapper) {
            image = super.getImage(((ItemWrapper)object).getWrappedObject());
        } else if (object instanceof RepresentationPackage) {
            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        } else if (!(object instanceof IResource)) {
            image = super.getImage(object);
        }
        return image;
    }

    private Image getDisabledImage(DRepresentationDescriptor representationDescriptor, Image image) {
        StringBuilder sB = new StringBuilder();
        sB.append(DRepresentationDescriptor.class.getName());
        RepresentationDescription description = representationDescriptor.getDescription();
        if (description != null) {
            sB.append('_');
            sB.append(description.getClass().getName());
        }
        sB.append(DISABLED_REPRESENTATION_SUFFIX);
        String key = sB.toString();
        Image disabledImage = CapellaNavigatorPlugin.getDefault().getImageRegistry().get(key);
        if (disabledImage == null) {
            ImageDescriptor desc = ImageDescriptor.createFromImage((Image)image);
            ImageDescriptor disabledDesc = ImageDescriptor.createWithFlags((ImageDescriptor)desc, (int)1);
            CapellaNavigatorPlugin.getDefault().getImageRegistry().put(key, disabledDesc);
            disabledImage = CapellaNavigatorPlugin.getDefault().getImageRegistry().get(key);
        }
        return disabledImage;
    }

    private Optional<DRepresentationDescriptor> getRepresentationDescriptor(Object element) {
        return RepresentationHelper.getSelectedDescriptors(Arrays.asList(element)).stream().findFirst();
    }

    public String getText(Object object) {
        String text = null;
        if (object instanceof Session) {
            text = SessionLabelProviderHelper.getInstance().getSessionLabelProvider().getText(object);
        } else if (object instanceof ItemDecorator) {
            text = ((ItemDecorator)object).getText();
        } else if (object instanceof ItemWrapper) {
            text = super.getText(((ItemWrapper)object).getWrappedObject());
        } else {
            Session session;
            if (object instanceof RepresentationPackage) {
                return ((RepresentationPackage)object).getName();
            }
            IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)Platform.getAdapterManager().getAdapter(object, IWorkbenchAdapter.class);
            String string = text = workbenchAdapter != null ? workbenchAdapter.getLabel(object) : super.getText(object);
            if (object instanceof IFile && CapellaResourceHelper.isAirdResource((IResource)((IFile)object), (boolean)true) && (session = SessionHelper.getSession((IFile)((IFile)object))) != null && session.getStatus() == SessionStatus.DIRTY) {
                text = "*" + text;
            }
        }
        return text;
    }

    public Color getForeground(Object element) {
        Optional<DRepresentationDescriptor> repDesc = this.getRepresentationDescriptor(element);
        if (repDesc.isPresent()) {
            try {
                if (!RepresentationHelper.isValid((DRepresentationDescriptor)repDesc.get())) {
                    return VisualBindingManager.getDefault().getColorFromName(SystemColors.LIGHT_GRAY_LITERAL.getName());
                }
            }
            catch (IllegalStateException | NullPointerException runtimeException) {
                // empty catch block
            }
        }
        if (SharedCutPasteClipboard.getCutClipboard().isObjectCut(element)) {
            return VisualBindingManager.getDefault().getColorFromName(SystemColors.GRAY_LITERAL.getName());
        }
        return super.getForeground(element);
    }

    public String getDescription(Object element) {
        if (element instanceof ModelElement) {
            String slash = String.valueOf('/');
            ModelElement modelElement = (ModelElement)element;
            String path = modelElement.getFullLabel();
            if (path.startsWith(slash)) {
                path = path.substring(1);
            }
            return path.replaceAll(slash, STATUS_LINE_PATH_SEPARATOR);
        }
        EObject eObject = CapellaAdapterHelper.resolveEObject((Object)element);
        if (eObject instanceof DRepresentation) {
            DRepresentationDescriptor descriptor = RepresentationHelper.getRepresentationDescriptor((DRepresentation)((DRepresentation)eObject));
            return RepresentationHelper.getRepresentationFullPathText((DRepresentationDescriptor)descriptor);
        }
        if (eObject instanceof DRepresentationDescriptor) {
            return RepresentationHelper.getRepresentationFullPathText((DRepresentationDescriptor)((DRepresentationDescriptor)eObject));
        }
        EObject semanticElement = CapellaAdapterHelper.resolveBusinessObject((Object)element);
        if (semanticElement != null) {
            return EObjectLabelProviderHelper.getFullPathText((EObject)semanticElement);
        }
        return "";
    }

    public void dispose() {
        if (this.italicFont != null && !this.italicFont.isDisposed()) {
            this.italicFont.dispose();
            this.italicFont = null;
        }
        super.dispose();
    }

    public Font getFont(Object element) {
        if (element instanceof Part || SharedCutPasteClipboard.getCutClipboard().isObjectCut(element)) {
            return this.italicFont;
        }
        return super.getFont(element);
    }
}

