/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.drop;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.polarsys.capella.common.model.copypaste.SharedCopyPasteElements;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaCopyToClipboardCommand;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaPasteCommand;
import org.polarsys.capella.core.platform.sirius.ui.commands.PasteCommandHelper;

public class CapellaDragAndDropCommand
extends DragAndDropCommand {
    public CapellaDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
        super(domain, owner, location, operations, operation, collection);
    }

    protected boolean prepareDropMoveOn() {
        Collection<EObject> pastedElements = this.enrichPastedElements(this.owner, this.collection);
        this.dropCommand = new CompoundCommand();
        PasteCommandHelper.createPasteCommands(pastedElements, (CompoundCommand)((CompoundCommand)this.dropCommand), (EObject)((EObject)this.owner), null, (EditingDomain)this.domain, (int)-1, (boolean)true);
        this.dragCommand = RemoveCommand.create((EditingDomain)this.domain, pastedElements);
        return this.dragCommand.canExecute() && this.dropCommand.canExecute();
    }

    protected boolean prepareDropCopyOn() {
        boolean result = false;
        this.dragCommand = new CapellaCopyToClipboardCommand(this.domain, this.collection, null);
        if (this.dragCommand.canExecute()) {
            this.dragCommand.execute();
            this.isDragCommandExecuted = true;
            this.dropCommand = new CommandWrapper((Command)new CapellaPasteCommand(this.domain, this.owner, null, -1)){

                public void execute() {
                    super.execute();
                    CapellaDragAndDropCommand.this.domain.getClipboard().clear();
                    SharedCopyPasteElements.getInstance().clear();
                }
            };
            if (this.dropCommand.canExecute()) {
                result = true;
            } else {
                this.dragCommand.undo();
                this.isDragCommandExecuted = false;
            }
        }
        return result;
    }

    protected Collection<EObject> enrichPastedElements(Object owner, Collection<?> collection) {
        HashSet<EObject> pastedElements = new HashSet<EObject>();
        pastedElements.addAll(collection.stream().filter(EObject.class::isInstance).map(EObject.class::cast).collect(Collectors.toList()));
        if (owner instanceof EObject && !CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)((EObject)owner)))) {
            List partsToMoveWithComponent = collection.stream().filter(Component.class::isInstance).map(Component.class::cast).flatMap(component -> component.getRepresentingParts().stream()).filter(part -> !collection.contains(part)).collect(Collectors.toList());
            pastedElements.addAll(partsToMoveWithComponent);
            List componentsToMoveWithPart = collection.stream().filter(Part.class::isInstance).map(Part.class::cast).filter(part -> part.getAbstractType() != null).map(part -> part.getAbstractType()).filter(component -> !collection.contains(component)).collect(Collectors.toList());
            pastedElements.addAll(componentsToMoveWithPart);
        }
        return pastedElements;
    }
}

