/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions.move.representation;

import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.move.representation.Messages;

public class MoveRepresentationAction
extends Action {
    private static final ImageDescriptor ACTION_IMAGE_DESCRIPTOR = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/others/forward.gif");
    private DAnalysis targetAnalysis;
    private DAnalysisSession session;
    private Collection<DRepresentationDescriptor> descriptors;

    public MoveRepresentationAction(DAnalysisSession session, Collection<DRepresentationDescriptor> descriptors, DAnalysis targetAnalysis) {
        String actionLabel = String.valueOf(Messages.MoveRepresentationAction_Title) + targetAnalysis.eResource().getURI();
        this.setId(actionLabel);
        this.setText(actionLabel);
        this.setImageDescriptor(ACTION_IMAGE_DESCRIPTOR);
        this.targetAnalysis = targetAnalysis;
        this.session = session;
        this.descriptors = descriptors;
    }

    public void run() {
        ExecutionManager executionManager = TransactionHelper.getExecutionManager(this.descriptors);
        if (executionManager == null) {
            return;
        }
        executionManager.execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                IEditingSession uiSession = SessionUIManager.INSTANCE.getUISession((Session)MoveRepresentationAction.this.session);
                if (uiSession != null) {
                    for (DRepresentationDescriptor descriptor : MoveRepresentationAction.this.descriptors) {
                        this.closeOpenedEditor(uiSession, descriptor);
                    }
                }
                for (DRepresentationDescriptor descriptor : MoveRepresentationAction.this.descriptors) {
                    MoveRepresentationAction.this.session.moveRepresentation(MoveRepresentationAction.this.targetAnalysis, descriptor);
                }
                try {
                    ISelectionProvider selectionProvider = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getSelectionProvider();
                    ISelection currentSelection = selectionProvider.getSelection();
                    selectionProvider.setSelection(currentSelection);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }

            private void closeOpenedEditor(IEditingSession uiSession, DRepresentationDescriptor descriptor) {
                DialectEditor editor;
                if (descriptor.isLoadedRepresentation() && (editor = uiSession.getEditor(descriptor.getRepresentation())) != null) {
                    editor.getEditorSite().getPage().closeEditor((IEditorPart)editor, false);
                }
            }
        });
    }
}

