/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.capella;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.common.tools.api.util.SiriusCrossReferenceAdapter;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementFunction;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink;
import org.polarsys.capella.core.data.fa.FunctionalChainReference;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.data.migration.contribution.AbstractMigrationContribution;
import org.polarsys.capella.core.model.helpers.FunctionalChainExt;
import org.polarsys.capella.core.model.helpers.FunctionalExchangeExt;

public class FunctionalChainMigrationContribution
extends AbstractMigrationContribution {
    HashSet<MigrationContext> proceedingContexts = new HashSet();
    Map<FunctionalChainInvolvement, Set<FunctionalChainInvolvement>> fci2NextFcis = new HashMap<FunctionalChainInvolvement, Set<FunctionalChainInvolvement>>();
    Map<FunctionalChainInvolvementLink, FunctionalChainInvolvementFunction> fciLink2FciFunctions = new HashMap<FunctionalChainInvolvementLink, FunctionalChainInvolvementFunction>();

    @Override
    public String getQName(EObject peekObject, String typeQName, EStructuralFeature feature, Resource resource, XMLHelper helper, MigrationContext context) {
        if (typeQName.equals("org.polarsys.capella.core.data.fa:FunctionalChainInvolvement")) {
            this.proceedingContexts.add(context);
            return "org.polarsys.capella.core.data.fa:FunctionalChainInvolvementLink";
        }
        return super.getQName(peekObject, typeQName, feature, resource, helper, context);
    }

    @Override
    public boolean ignoreSetFeatureValue(EObject peekObject, EStructuralFeature feature, Object value, int position, XMLResource resource, MigrationContext context) {
        if (this.proceedingContexts.contains(context) && peekObject instanceof FunctionalChainInvolvement && feature == FaPackage.Literals.FUNCTIONAL_CHAIN_INVOLVEMENT__NEXT_FUNCTIONAL_CHAIN_INVOLVEMENTS) {
            Set nextFCIs = this.fci2NextFcis.computeIfAbsent((FunctionalChainInvolvement)peekObject, key -> new HashSet());
            nextFCIs.add((FunctionalChainInvolvement)value);
            return true;
        }
        return super.ignoreSetFeatureValue(peekObject, feature, value, position, resource, context);
    }

    @Override
    public void unaryMigrationExecute(EObject object, MigrationContext context) {
        FunctionalChainInvolvementLink fcil;
        InvolvedElement involved;
        if (this.proceedingContexts.contains(context) && object instanceof FunctionalChainInvolvementLink && (involved = (fcil = (FunctionalChainInvolvementLink)object).getInvolved()) instanceof AbstractFunction) {
            FunctionalChainInvolvementFunction fcif = FaFactory.eINSTANCE.createFunctionalChainInvolvementFunction();
            this.fciLink2FciFunctions.put(fcil, fcif);
        }
        super.unaryMigrationExecute(object, context);
    }

    @Override
    public void postMigrationExecute(ExecutionManager executionManager, ResourceSet resourceSet, MigrationContext context) {
        if (this.proceedingContexts.contains(context)) {
            this.fciLink2FciFunctions.forEach(this::replaceFCILinkByFCIFunction);
            this.updateSourceTarget();
            this.updateHierarchicalContext();
        }
        super.postMigrationExecute(executionManager, resourceSet, context);
    }

    protected void replaceFCILinkByFCIFunction(FunctionalChainInvolvementLink fciLink, FunctionalChainInvolvementFunction fciFunction) {
        EList eAllStructuralFeatures = fciLink.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature feature : eAllStructuralFeatures) {
            if (feature.isDerived() || !fciFunction.eClass().getEAllStructuralFeatures().contains((Object)feature)) continue;
            fciFunction.eSet(feature, fciLink.eGet(feature));
        }
        TransactionalEditingDomain domain = TransactionHelper.getEditingDomain((EObject)fciLink);
        if (domain instanceof SemanticEditingDomainFactory.SemanticEditingDomain) {
            SemanticEditingDomainFactory.SemanticEditingDomain editingDomain = (SemanticEditingDomainFactory.SemanticEditingDomain)domain;
            SiriusCrossReferenceAdapter crossReferencer = editingDomain.getCrossReferencer();
            Collection inverseReferences = crossReferencer.getInverseReferences((EObject)fciLink, editingDomain.getCrossReferencer().isResolveProxyEnabled());
            for (EStructuralFeature.Setting setting : inverseReferences) {
                EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                if (!eStructuralFeature.isMany()) {
                    setting.getEObject().eSet(eStructuralFeature, (Object)fciFunction);
                    continue;
                }
                EList list = (EList)setting.getEObject().eGet(eStructuralFeature);
                if (!list.contains((Object)fciLink)) continue;
                list.remove((Object)fciLink);
                list.add((Object)fciFunction);
            }
        }
        if (this.fci2NextFcis.keySet().contains(fciLink)) {
            this.fci2NextFcis.put((FunctionalChainInvolvement)fciFunction, this.fci2NextFcis.get(fciLink));
            this.fci2NextFcis.remove(fciLink);
        }
        for (Set<FunctionalChainInvolvement> nextFcis : this.fci2NextFcis.values()) {
            if (!nextFcis.contains(fciLink)) continue;
            nextFcis.remove(fciLink);
            nextFcis.add((FunctionalChainInvolvement)fciFunction);
        }
    }

    protected void updateSourceTarget() {
        for (Map.Entry<FunctionalChainInvolvement, Set<FunctionalChainInvolvement>> entry : this.fci2NextFcis.entrySet()) {
            if (entry.getKey() instanceof FunctionalChainInvolvementLink) {
                for (FunctionalChainInvolvement fci : entry.getValue()) {
                    if (!(fci instanceof FunctionalChainInvolvementFunction)) continue;
                    ((FunctionalChainInvolvementLink)entry.getKey()).setTarget((FunctionalChainInvolvementFunction)fci);
                }
            }
            if (!(entry.getKey() instanceof FunctionalChainInvolvementFunction)) continue;
            for (FunctionalChainInvolvement link : entry.getValue()) {
                if (!(link instanceof FunctionalChainInvolvementLink)) continue;
                ((FunctionalChainInvolvementLink)link).setSource((FunctionalChainInvolvementFunction)entry.getKey());
            }
        }
    }

    protected void updateHierarchicalContext() {
        HashMap<FunctionalChainReference, List<List<FunctionalChainInvolvement>>> firstFlatHierachicalContextsMap = new HashMap<FunctionalChainReference, List<List<FunctionalChainInvolvement>>>();
        HashMap<FunctionalChainReference, List<List<FunctionalChainInvolvement>>> lastFlatHierachicalContextsMap = new HashMap<FunctionalChainReference, List<List<FunctionalChainInvolvement>>>();
        HashMap<FunctionalChainInvolvementLink, List<FunctionalChainInvolvement>> fciLink2SourceFciAndContext = new HashMap<FunctionalChainInvolvementLink, List<FunctionalChainInvolvement>>();
        HashMap<FunctionalChainInvolvementLink, List<FunctionalChainInvolvement>> fciLink2TargetFciAndContext = new HashMap<FunctionalChainInvolvementLink, List<FunctionalChainInvolvement>>();
        for (Map.Entry<FunctionalChainInvolvement, Set<FunctionalChainInvolvement>> entry : this.fci2NextFcis.entrySet()) {
            if (entry.getKey() instanceof FunctionalChainReference) {
                for (FunctionalChainInvolvement fci : entry.getValue()) {
                    InvolvedElement involved = fci.getInvolved();
                    if (!(fci instanceof FunctionalChainInvolvementLink) || !(involved instanceof FunctionalExchange)) continue;
                    this.calculateSourceHierarchicalContext(lastFlatHierachicalContextsMap, fciLink2SourceFciAndContext, (FunctionalChainReference)entry.getKey(), (FunctionalExchange)involved, (FunctionalChainInvolvementLink)fci);
                }
            }
            if (!(entry.getKey() instanceof FunctionalChainInvolvementLink)) continue;
            FunctionalChainInvolvementLink fciLink = (FunctionalChainInvolvementLink)entry.getKey();
            for (FunctionalChainInvolvement involvement : entry.getValue()) {
                InvolvedElement involved;
                if (!(involvement instanceof FunctionalChainReference) || !((involved = fciLink.getInvolved()) instanceof FunctionalExchange)) continue;
                this.calculateTargetHierarchicalContext(firstFlatHierachicalContextsMap, fciLink2TargetFciAndContext, fciLink, (FunctionalChainReference)involvement, (FunctionalExchange)involved);
            }
        }
        this.updateSourceHierarchicalContext(fciLink2SourceFciAndContext);
        this.updateTargetHierarchicalContext(fciLink2TargetFciAndContext);
    }

    protected void updateTargetHierarchicalContext(Map<FunctionalChainInvolvementLink, List<FunctionalChainInvolvement>> fciLink2TargetFciAndContext) {
        for (Map.Entry<FunctionalChainInvolvementLink, List<FunctionalChainInvolvement>> entry : fciLink2TargetFciAndContext.entrySet()) {
            FunctionalChainInvolvementLink fciLink = entry.getKey();
            List<FunctionalChainInvolvement> targetFciAndContext = entry.getValue();
            fciLink.setTarget((FunctionalChainInvolvementFunction)targetFciAndContext.get(0));
            int i = 1;
            while (i < targetFciAndContext.size()) {
                fciLink.getTargetReferenceHierarchy().add((Object)((FunctionalChainReference)targetFciAndContext.get(i)));
                ++i;
            }
        }
    }

    protected void updateSourceHierarchicalContext(Map<FunctionalChainInvolvementLink, List<FunctionalChainInvolvement>> fciLink2SourceFciAndContext) {
        for (Map.Entry<FunctionalChainInvolvementLink, List<FunctionalChainInvolvement>> entry : fciLink2SourceFciAndContext.entrySet()) {
            FunctionalChainInvolvementLink fciLink = entry.getKey();
            List<FunctionalChainInvolvement> sourceFciAndContext = entry.getValue();
            fciLink.setSource((FunctionalChainInvolvementFunction)sourceFciAndContext.get(0));
            int i = 1;
            while (i < sourceFciAndContext.size()) {
                fciLink.getSourceReferenceHierarchy().add((Object)((FunctionalChainReference)sourceFciAndContext.get(i)));
                ++i;
            }
        }
    }

    protected void calculateTargetHierarchicalContext(Map<FunctionalChainReference, List<List<FunctionalChainInvolvement>>> firstFlatHierachicalContextsMap, Map<FunctionalChainInvolvementLink, List<FunctionalChainInvolvement>> fciLink2TargetFciAndContext, FunctionalChainInvolvementLink fcil, FunctionalChainReference fcr, FunctionalExchange fe) {
        List firstFlatHierachicalContexts;
        List firstFCIAndContext;
        AbstractFunction targetFunction = FunctionalExchangeExt.getTargetFunction((FunctionalExchange)fe);
        InvolvedElement fcInvolved = fcr.getInvolved();
        if (fcInvolved instanceof FunctionalChain && !(firstFCIAndContext = (firstFlatHierachicalContexts = firstFlatHierachicalContextsMap.computeIfAbsent(fcr, FunctionalChainExt::getFirstFlatHierachicalContexts)).stream().filter(fciHierarchicalContext -> ((FunctionalChainInvolvement)fciHierarchicalContext.get(0)).getInvolved() == targetFunction).findFirst().orElse(Collections.emptyList())).isEmpty()) {
            fciLink2TargetFciAndContext.put(fcil, firstFCIAndContext);
        }
    }

    protected void calculateSourceHierarchicalContext(Map<FunctionalChainReference, List<List<FunctionalChainInvolvement>>> lastFlatHierachicalContextsMap, Map<FunctionalChainInvolvementLink, List<FunctionalChainInvolvement>> fciLink2SourceFciAndContext, FunctionalChainReference fcr, FunctionalExchange fe, FunctionalChainInvolvementLink fcil) {
        List lastFlatHierachicalContexts;
        List lastFCIAndContext;
        AbstractFunction sourceFunction = FunctionalExchangeExt.getSourceFunction((FunctionalExchange)fe);
        if (fcr.getInvolved() instanceof FunctionalChain && !(lastFCIAndContext = (lastFlatHierachicalContexts = lastFlatHierachicalContextsMap.computeIfAbsent(fcr, FunctionalChainExt::getLastFlatHierachicalContexts)).stream().filter(fciHierarchicalContext -> ((FunctionalChainInvolvement)fciHierarchicalContext.get(0)).getInvolved() == sourceFunction).findFirst().orElse(Collections.emptyList())).isEmpty()) {
            fciLink2SourceFciAndContext.put(fcil, lastFCIAndContext);
        }
    }

    @Override
    public void dispose(MigrationContext context) {
        super.dispose(context);
        this.proceedingContexts.clear();
        this.fci2NextFcis.clear();
        this.fciLink2FciFunctions.clear();
    }
}

