/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.capella;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.re.RePackage;
import org.polarsys.capella.core.data.capellacommon.TransfoLink;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.CapabilityPkg;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.ctx.SystemComponentPkg;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.ConfigurationItemPkg;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.la.CapabilityRealizationPkg;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.migration.UnknownEStructuralFeature;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.data.migration.contribution.AbstractMigrationContribution;
import org.polarsys.capella.core.data.oa.EntityPkg;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.oa.OperationalCapabilityPkg;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ModelElementExt;
import org.polarsys.capella.core.sirius.analysis.tool.StringUtil;

public class ActorRefactoringMigrationContribution
extends AbstractMigrationContribution {
    private static final List<UnknownEStructuralFeature> UNKNOWNED_FEATURES = new ArrayList<UnknownEStructuralFeature>();
    private static final Map<UnknownEStructuralFeature, EStructuralFeature> OLD_FEATURE_2_NEW_FEATURE;
    private static final Map<String, String> OLD_TYPE_2_NEW_TYPE;
    public static final Map<String, String> MAPPINGS;
    private static final Map<String, String> STYLES;
    private static final List<String> OLD_ACTOR_TYPES;
    private Map<String, String> archToOldContextIdsMap = new HashMap<String, String>();

    static {
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(CtxPackage.Literals.SYSTEM_ANALYSIS, "ownedSystem"));
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(LaPackage.Literals.LOGICAL_ARCHITECTURE, "ownedLogicalComponent"));
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(PaPackage.Literals.PHYSICAL_ARCHITECTURE, "ownedPhysicalComponent"));
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(EpbsPackage.Literals.EPBS_ARCHITECTURE, "ownedConfigurationItem"));
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(OaPackage.Literals.OPERATIONAL_ANALYSIS, "ownedOperationalContext"));
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(CtxPackage.Literals.SYSTEM_ANALYSIS, "ownedSystemContext"));
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(LaPackage.Literals.LOGICAL_ARCHITECTURE, "ownedLogicalContext"));
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(PaPackage.Literals.PHYSICAL_ARCHITECTURE, "ownedPhysicalContext"));
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(EpbsPackage.Literals.EPBS_ARCHITECTURE, "ownedEPBSContext"));
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(CtxPackage.Literals.SYSTEM_ANALYSIS, "ownedActorPkg"));
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(LaPackage.Literals.LOGICAL_ARCHITECTURE, "ownedLogicalActorPkg"));
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(PaPackage.Literals.PHYSICAL_ARCHITECTURE, "ownedPhysicalActorPkg"));
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(OaPackage.Literals.ENTITY_PKG, "ownedDataPkg"));
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(CtxPackage.Literals.SYSTEM_COMPONENT_PKG, "ownedDataPkg"));
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(LaPackage.Literals.LOGICAL_COMPONENT_PKG, "ownedDataPkg"));
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(PaPackage.Literals.PHYSICAL_COMPONENT_PKG, "ownedDataPkg"));
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(EpbsPackage.Literals.CONFIGURATION_ITEM_PKG, "ownedDataPkg"));
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(OaPackage.Literals.ENTITY_PKG, "ownedInterfacePkg"));
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(CtxPackage.Literals.SYSTEM_COMPONENT_PKG, "ownedInterfacePkg"));
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(LaPackage.Literals.LOGICAL_COMPONENT_PKG, "ownedInterfacePkg"));
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(PaPackage.Literals.PHYSICAL_COMPONENT_PKG, "ownedInterfacePkg"));
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(EpbsPackage.Literals.CONFIGURATION_ITEM_PKG, "ownedInterfacePkg"));
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(OaPackage.Literals.ENTITY_PKG, "ownedAbstractCapabilityPkg"));
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(CtxPackage.Literals.SYSTEM_COMPONENT_PKG, "ownedAbstractCapabilityPkg"));
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(LaPackage.Literals.LOGICAL_COMPONENT_PKG, "ownedAbstractCapabilityPkg"));
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(PaPackage.Literals.PHYSICAL_COMPONENT_PKG, "ownedAbstractCapabilityPkg"));
        UNKNOWNED_FEATURES.add(new UnknownEStructuralFeature(EpbsPackage.Literals.CONFIGURATION_ITEM_PKG, "ownedAbstractCapabilityPkg"));
        OLD_FEATURE_2_NEW_FEATURE = new HashMap<UnknownEStructuralFeature, EStructuralFeature>();
        OLD_FEATURE_2_NEW_FEATURE.put(new UnknownEStructuralFeature(CtxPackage.Literals.SYSTEM_COMPONENT, "ownedOperationalActorRealizations"), (EStructuralFeature)CsPackage.Literals.COMPONENT__OWNED_COMPONENT_REALIZATIONS);
        OLD_FEATURE_2_NEW_FEATURE.put(new UnknownEStructuralFeature(CtxPackage.Literals.SYSTEM_COMPONENT, "ownedOperationalEntityRealizations"), (EStructuralFeature)CsPackage.Literals.COMPONENT__OWNED_COMPONENT_REALIZATIONS);
        OLD_FEATURE_2_NEW_FEATURE.put(new UnknownEStructuralFeature(LaPackage.Literals.LOGICAL_COMPONENT, "ownedSystemActorRealizations"), (EStructuralFeature)CsPackage.Literals.COMPONENT__OWNED_COMPONENT_REALIZATIONS);
        OLD_FEATURE_2_NEW_FEATURE.put(new UnknownEStructuralFeature(LaPackage.Literals.LOGICAL_COMPONENT, "ownedSystemRealizations"), (EStructuralFeature)CsPackage.Literals.COMPONENT__OWNED_COMPONENT_REALIZATIONS);
        OLD_FEATURE_2_NEW_FEATURE.put(new UnknownEStructuralFeature(PaPackage.Literals.PHYSICAL_COMPONENT, "ownedLogicalActorRealizations"), (EStructuralFeature)CsPackage.Literals.COMPONENT__OWNED_COMPONENT_REALIZATIONS);
        OLD_FEATURE_2_NEW_FEATURE.put(new UnknownEStructuralFeature(PaPackage.Literals.PHYSICAL_COMPONENT, "ownedLogicalComponentRealizations"), (EStructuralFeature)CsPackage.Literals.COMPONENT__OWNED_COMPONENT_REALIZATIONS);
        OLD_FEATURE_2_NEW_FEATURE.put(new UnknownEStructuralFeature(OaPackage.Literals.ENTITY_PKG, "ownedFeatures"), (EStructuralFeature)CsPackage.Literals.COMPONENT_PKG__OWNED_PARTS);
        OLD_FEATURE_2_NEW_FEATURE.put(new UnknownEStructuralFeature(CtxPackage.Literals.SYSTEM_COMPONENT_PKG, "ownedFeatures"), (EStructuralFeature)CsPackage.Literals.COMPONENT_PKG__OWNED_PARTS);
        OLD_FEATURE_2_NEW_FEATURE.put(new UnknownEStructuralFeature(LaPackage.Literals.LOGICAL_COMPONENT_PKG, "ownedFeatures"), (EStructuralFeature)CsPackage.Literals.COMPONENT_PKG__OWNED_PARTS);
        OLD_FEATURE_2_NEW_FEATURE.put(new UnknownEStructuralFeature(PaPackage.Literals.PHYSICAL_COMPONENT_PKG, "ownedFeatures"), (EStructuralFeature)CsPackage.Literals.COMPONENT_PKG__OWNED_PARTS);
        OLD_FEATURE_2_NEW_FEATURE.put(new UnknownEStructuralFeature(EpbsPackage.Literals.CONFIGURATION_ITEM_PKG, "ownedFeatures"), (EStructuralFeature)CsPackage.Literals.COMPONENT_PKG__OWNED_PARTS);
        OLD_FEATURE_2_NEW_FEATURE.put(new UnknownEStructuralFeature(CtxPackage.Literals.SYSTEM_COMPONENT_PKG, "ownedActors"), (EStructuralFeature)CtxPackage.Literals.SYSTEM_COMPONENT_PKG__OWNED_SYSTEM_COMPONENTS);
        OLD_FEATURE_2_NEW_FEATURE.put(new UnknownEStructuralFeature(LaPackage.Literals.LOGICAL_COMPONENT_PKG, "ownedLogicalActors"), (EStructuralFeature)LaPackage.Literals.LOGICAL_COMPONENT_PKG__OWNED_LOGICAL_COMPONENTS);
        OLD_FEATURE_2_NEW_FEATURE.put(new UnknownEStructuralFeature(PaPackage.Literals.PHYSICAL_COMPONENT_PKG, "ownedPhysicalActors"), (EStructuralFeature)PaPackage.Literals.PHYSICAL_COMPONENT_PKG__OWNED_PHYSICAL_COMPONENTS);
        OLD_FEATURE_2_NEW_FEATURE.put(new UnknownEStructuralFeature(PaPackage.Literals.PHYSICAL_COMPONENT_PKG, "ownedComponents"), (EStructuralFeature)PaPackage.Literals.PHYSICAL_COMPONENT_PKG__OWNED_PHYSICAL_COMPONENTS);
        OLD_FEATURE_2_NEW_FEATURE.put(new UnknownEStructuralFeature(CtxPackage.Literals.CAPABILITY_INVOLVEMENT, "actor"), (EStructuralFeature)CtxPackage.Literals.CAPABILITY_INVOLVEMENT__SYSTEM_COMPONENT);
        OLD_FEATURE_2_NEW_FEATURE.put(new UnknownEStructuralFeature(CtxPackage.Literals.CAPABILITY, "ownedActorCapabilityInvolvements"), (EStructuralFeature)CtxPackage.Literals.CAPABILITY__OWNED_CAPABILITY_INVOLVEMENTS);
        OLD_FEATURE_2_NEW_FEATURE.put(new UnknownEStructuralFeature(CtxPackage.Literals.CAPABILITY, "ownedSystemCapabilityInvolvement"), (EStructuralFeature)CtxPackage.Literals.CAPABILITY__OWNED_CAPABILITY_INVOLVEMENTS);
        OLD_FEATURE_2_NEW_FEATURE.put(new UnknownEStructuralFeature(CtxPackage.Literals.MISSION_INVOLVEMENT, "actor"), (EStructuralFeature)CtxPackage.Literals.MISSION_INVOLVEMENT__SYSTEM_COMPONENT);
        OLD_FEATURE_2_NEW_FEATURE.put(new UnknownEStructuralFeature(CtxPackage.Literals.MISSION, "ownedActorMissionInvolvements"), (EStructuralFeature)CtxPackage.Literals.MISSION__OWNED_MISSION_INVOLVEMENTS);
        OLD_FEATURE_2_NEW_FEATURE.put(new UnknownEStructuralFeature(CtxPackage.Literals.MISSION, "ownedSystemMissionInvolvement"), (EStructuralFeature)CtxPackage.Literals.MISSION__OWNED_MISSION_INVOLVEMENTS);
        OLD_FEATURE_2_NEW_FEATURE.put(new UnknownEStructuralFeature(LaPackage.Literals.CAPABILITY_REALIZATION, "ownedActorCapabilityRealizations"), (EStructuralFeature)LaPackage.Literals.CAPABILITY_REALIZATION__OWNED_CAPABILITY_REALIZATION_INVOLVEMENTS);
        OLD_FEATURE_2_NEW_FEATURE.put(new UnknownEStructuralFeature(LaPackage.Literals.CAPABILITY_REALIZATION, "ownedSystemComponentCapabilityRealizations"), (EStructuralFeature)LaPackage.Literals.CAPABILITY_REALIZATION__OWNED_CAPABILITY_REALIZATION_INVOLVEMENTS);
        OLD_FEATURE_2_NEW_FEATURE.put(new UnknownEStructuralFeature(CtxPackage.Literals.SYSTEM_COMPONENT_PKG, "ownedActorPkgs"), (EStructuralFeature)CtxPackage.Literals.SYSTEM_COMPONENT_PKG__OWNED_SYSTEM_COMPONENT_PKGS);
        OLD_FEATURE_2_NEW_FEATURE.put(new UnknownEStructuralFeature(LaPackage.Literals.LOGICAL_COMPONENT_PKG, "ownedLogicalActorPkgs"), (EStructuralFeature)LaPackage.Literals.LOGICAL_COMPONENT_PKG__OWNED_LOGICAL_COMPONENT_PKGS);
        OLD_FEATURE_2_NEW_FEATURE.put(new UnknownEStructuralFeature(PaPackage.Literals.PHYSICAL_COMPONENT_PKG, "ownedPhysicalActorPkgs"), (EStructuralFeature)PaPackage.Literals.PHYSICAL_COMPONENT_PKG__OWNED_PHYSICAL_COMPONENT_PKGS);
        OLD_TYPE_2_NEW_TYPE = new HashMap<String, String>();
        OLD_TYPE_2_NEW_TYPE.put("org.polarsys.capella.core.data.oa:OperationalContext", "org.polarsys.capella.core.data.oa:EntityPkg");
        OLD_TYPE_2_NEW_TYPE.put("org.polarsys.capella.core.data.ctx:SystemContext", "org.polarsys.capella.core.data.ctx:SystemComponentPkg");
        OLD_TYPE_2_NEW_TYPE.put("org.polarsys.capella.core.data.la:LogicalContext", "org.polarsys.capella.core.data.la:LogicalComponentPkg");
        OLD_TYPE_2_NEW_TYPE.put("org.polarsys.capella.core.data.pa:PhysicalContext", "org.polarsys.capella.core.data.pa:PhysicalComponentPkg");
        OLD_TYPE_2_NEW_TYPE.put("org.polarsys.capella.core.data.epbs:EPBSContext", "org.polarsys.capella.core.data.epbs:ConfigurationItemPkg");
        OLD_TYPE_2_NEW_TYPE.put("org.polarsys.capella.core.data.ctx:ActorPkg", "org.polarsys.capella.core.data.ctx:SystemComponentPkg");
        OLD_TYPE_2_NEW_TYPE.put("org.polarsys.capella.core.data.la:LogicalActorPkg", "org.polarsys.capella.core.data.la:LogicalComponentPkg");
        OLD_TYPE_2_NEW_TYPE.put("org.polarsys.capella.core.data.pa:PhysicalActorPkg", "org.polarsys.capella.core.data.pa:PhysicalComponentPkg");
        OLD_TYPE_2_NEW_TYPE.put("org.polarsys.capella.core.data.ctx:OperationalActorRealization", "org.polarsys.capella.core.data.cs:ComponentRealization");
        OLD_TYPE_2_NEW_TYPE.put("org.polarsys.capella.core.data.ctx:OperationalEntityRealization", "org.polarsys.capella.core.data.cs:ComponentRealization");
        OLD_TYPE_2_NEW_TYPE.put("org.polarsys.capella.core.data.la:SystemActorRealization", "org.polarsys.capella.core.data.cs:ComponentRealization");
        OLD_TYPE_2_NEW_TYPE.put("org.polarsys.capella.core.data.la:SystemRealization", "org.polarsys.capella.core.data.cs:ComponentRealization");
        OLD_TYPE_2_NEW_TYPE.put("org.polarsys.capella.core.data.pa:LogicalActorRealization", "org.polarsys.capella.core.data.cs:ComponentRealization");
        OLD_TYPE_2_NEW_TYPE.put("org.polarsys.capella.core.data.pa:LogicalComponentRealization", "org.polarsys.capella.core.data.cs:ComponentRealization");
        OLD_TYPE_2_NEW_TYPE.put("org.polarsys.capella.core.data.ctx:System", "org.polarsys.capella.core.data.ctx:SystemComponent");
        OLD_TYPE_2_NEW_TYPE.put("org.polarsys.capella.core.data.oa:OperationalActor", "org.polarsys.capella.core.data.oa:Entity");
        OLD_TYPE_2_NEW_TYPE.put("org.polarsys.capella.core.data.ctx:Actor", "org.polarsys.capella.core.data.ctx:SystemComponent");
        OLD_TYPE_2_NEW_TYPE.put("org.polarsys.capella.core.data.la:LogicalActor", "org.polarsys.capella.core.data.la:LogicalComponent");
        OLD_TYPE_2_NEW_TYPE.put("org.polarsys.capella.core.data.pa:PhysicalActor", "org.polarsys.capella.core.data.pa:PhysicalComponent");
        OLD_TYPE_2_NEW_TYPE.put("org.polarsys.capella.core.data.ctx:ActorCapabilityInvolvement", "org.polarsys.capella.core.data.ctx:CapabilityInvolvement");
        OLD_TYPE_2_NEW_TYPE.put("org.polarsys.capella.core.data.ctx:SystemCapabilityInvolvement", "org.polarsys.capella.core.data.ctx:CapabilityInvolvement");
        OLD_TYPE_2_NEW_TYPE.put("org.polarsys.capella.core.data.ctx:ActorMissionInvolvement", "org.polarsys.capella.core.data.ctx:MissionInvolvement");
        OLD_TYPE_2_NEW_TYPE.put("org.polarsys.capella.core.data.ctx:SystemMissionInvolvement", "org.polarsys.capella.core.data.ctx:MissionInvolvement");
        OLD_TYPE_2_NEW_TYPE.put("org.polarsys.capella.core.data.cs:ActorCapabilityRealizationInvolvement", "org.polarsys.capella.core.data.capellacommon:CapabilityRealizationInvolvement");
        OLD_TYPE_2_NEW_TYPE.put("org.polarsys.capella.core.data.cs:SystemComponentCapabilityRealizationInvolvement", "org.polarsys.capella.core.data.capellacommon:CapabilityRealizationInvolvement");
        MAPPINGS = new HashMap<String, String>();
        MAPPINGS.put("CCRI%20SystemComponentCapabilityRealizationInvolvement", "CCRI%20involvement");
        MAPPINGS.put("CCRI%20ActorCapabilityRealizationInvolvement", "CCRI%20involvement");
        MAPPINGS.put("CCRI%20Actor", "CCRI%20Component");
        MAPPINGS.put("SC_Actor", "SC_System");
        MAPPINGS.put("Logical%20Actors", "LAB%20Logical%20Component");
        MAPPINGS.put("PAB_Actor", "PAB_PC");
        STYLES = new HashMap<String, String>();
        STYLES.put("CCRI%20SystemComponentCapabilityRealizationInvolvement", "CCRI%20involvement");
        STYLES.put("CCRI%20ActorCapabilityRealizationInvolvement", "CCRI%20involvement");
        STYLES.put("[name='CCRI%20Actor']/@style", "[name='CCRI%20Component']/@conditionnalStyles.0/@style");
        STYLES.put("[name='SC_Actor']/@style", "[name='SC_System']/@conditionnalStyles.0/@style");
        STYLES.put("[name='Logical%20Actors']/@style", "[name='LAB%20Logical%20Component']/@conditionnalStyles.0/@style");
        STYLES.put("[name='Logical%20Actors']/@conditionnalStyles.0/@style", "[name='LAB%20Logical%20Component']/@conditionnalStyles.0/@style");
        STYLES.put("Logical%20Actors", "LAB%20Logical%20Component");
        STYLES.put("[name='PAB_Actor']/@style", "[name='PAB_PC']/@conditionnalStyles.0/@style");
        STYLES.put("[name='PAB_Actor']/@conditionnalStyles.0/@style", "[name='PAB_PC']/@conditionnalStyles.0/@style");
        STYLES.put("[name='PAB_Actor']/@conditionnalStyles.1/@style", "[name='PAB_PC']/@conditionnalStyles.0/@style");
        STYLES.put("PAB_Actor", "PAB_PC");
        OLD_ACTOR_TYPES = Arrays.asList("org.polarsys.capella.core.data.oa:OperationalActor", "org.polarsys.capella.core.data.ctx:Actor", "org.polarsys.capella.core.data.la:LogicalActor", "org.polarsys.capella.core.data.pa:PhysicalActor");
    }

    @Override
    public EStructuralFeature getFeature(EObject object, String prefix, String name, boolean isElement) {
        UnknownEStructuralFeature featureToTest = new UnknownEStructuralFeature(object.eClass(), name);
        if (UNKNOWNED_FEATURES.contains(featureToTest)) {
            return ModellingcorePackage.Literals.MODEL_ELEMENT__OWNED_MIGRATED_ELEMENTS;
        }
        if (OLD_FEATURE_2_NEW_FEATURE.containsKey(featureToTest)) {
            return OLD_FEATURE_2_NEW_FEATURE.get(featureToTest);
        }
        return super.getFeature(object, prefix, name, isElement);
    }

    @Override
    public String getQName(EObject peekObject, String typeQName, EStructuralFeature feature, Resource resource, XMLHelper helper, MigrationContext context) {
        if (OLD_TYPE_2_NEW_TYPE.containsKey(typeQName)) {
            return OLD_TYPE_2_NEW_TYPE.get(typeQName);
        }
        return super.getQName(peekObject, typeQName, feature, resource, helper, context);
    }

    @Override
    public void unaryMigrationExecute(EObject currentElement, MigrationContext context) {
        StyleDescription reference;
        super.unaryMigrationExecute(currentElement, context);
        if (currentElement instanceof DRepresentationElement) {
            URI uri;
            Object reference2;
            EStructuralFeature feature = currentElement.eClass().getEStructuralFeature("actualMapping");
            if (feature != null && (reference2 = currentElement.eGet(feature)) != null && reference2 instanceof EObject && ((EObject)reference2).eIsProxy() && (uri = this.migrateMappings(((InternalEObject)reference2).eProxyURI())) != null) {
                ((InternalEObject)reference2).eSetProxyURI(uri);
            }
        } else if (currentElement instanceof Style && (reference = ((Style)currentElement).getDescription()) != null && reference instanceof EObject && reference.eIsProxy()) {
            URI uri = ((InternalEObject)reference).eProxyURI();
            if ((uri = this.migrateStyles(uri)) != null) {
                ((InternalEObject)reference).eSetProxyURI(uri);
            }
        }
    }

    private URI migrateMappings(URI uri) {
        boolean change = false;
        String fragment = uri.fragment();
        for (String mapping : MAPPINGS.keySet()) {
            if (!fragment.contains(mapping)) continue;
            fragment = fragment.replace(mapping, MAPPINGS.get(mapping));
            change = true;
        }
        if (change) {
            String uriValue = uri.toPlatformString(true);
            return URI.createPlatformPluginURI((String)uriValue, (boolean)true).appendFragment(fragment);
        }
        return null;
    }

    private URI migrateStyles(URI uri) {
        boolean change = false;
        String fragment = uri.fragment();
        for (String mapping : STYLES.keySet()) {
            if (!fragment.contains(mapping)) continue;
            fragment = fragment.replace(mapping, STYLES.get(mapping));
            change = true;
        }
        if (change) {
            String uriValue = uri.toPlatformString(true);
            return URI.createPlatformPluginURI((String)uriValue, (boolean)true).appendFragment(fragment);
        }
        return null;
    }

    @Override
    public void updateCreatedObject(EObject peekObject, EObject eObject, String typeQName, EStructuralFeature feature, XMLResource resource, XMLHelper helper, MigrationContext context) {
        if (OLD_ACTOR_TYPES.contains(typeQName) && eObject instanceof Component) {
            ((Component)eObject).setActor(true);
            ((Component)eObject).setHuman(true);
            if (typeQName.equals("org.polarsys.capella.core.data.pa:PhysicalActor") && eObject instanceof PhysicalComponent) {
                ((PhysicalComponent)eObject).setNature(PhysicalComponentNature.NODE);
            }
        } else if (eObject instanceof ComponentPkg) {
            ComponentPkg componentPkg = (ComponentPkg)eObject;
            String componentPkgId = null;
            if ("org.polarsys.capella.core.data.oa:OperationalContext".equals(typeQName) && componentPkg instanceof EntityPkg) {
                componentPkgId = ((EntityPkg)componentPkg).getId();
            } else if ("org.polarsys.capella.core.data.ctx:SystemContext".equals(typeQName) && componentPkg instanceof SystemComponentPkg) {
                componentPkgId = ((SystemComponentPkg)componentPkg).getId();
            } else if ("org.polarsys.capella.core.data.la:LogicalContext".equals(typeQName) && componentPkg instanceof LogicalComponentPkg) {
                componentPkgId = ((LogicalComponentPkg)componentPkg).getId();
            } else if ("org.polarsys.capella.core.data.pa:PhysicalContext".equals(typeQName) && componentPkg instanceof PhysicalComponentPkg) {
                componentPkgId = ((PhysicalComponentPkg)componentPkg).getId();
            } else if ("org.polarsys.capella.core.data.epbs:EPBSContext".equals(typeQName) && componentPkg instanceof ConfigurationItemPkg) {
                componentPkgId = ((ConfigurationItemPkg)componentPkg).getId();
            }
            if (!StringUtil.isNullOrEmpty((String)componentPkgId)) {
                BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)componentPkg);
                if (architecture == null) {
                    System.err.println("Null Block Architecture for " + componentPkgId);
                } else {
                    String architectureId = architecture.getId();
                    this.archToOldContextIdsMap.put(architectureId, componentPkgId);
                }
            }
        }
        super.updateCreatedObject(peekObject, eObject, typeQName, feature, resource, helper, context);
    }

    protected void fusionContainmentReferences(EObject source, EObject target, List<EStructuralFeature> excludedFeatures) {
        if (source.eClass() != target.eClass()) {
            return;
        }
        for (EReference reference : source.eClass().getEAllReferences()) {
            if (!reference.isContainment()) continue;
            Object refSourceObjs = source.eGet((EStructuralFeature)reference);
            Object refTargetObjs = target.eGet((EStructuralFeature)reference);
            if (!(refSourceObjs instanceof List) || !(refTargetObjs instanceof List)) continue;
            ((List)refTargetObjs).addAll((List)refSourceObjs);
        }
        EcoreUtil2.replaceReferencingFeatures((EObject)source, (EObject)target, (boolean)false, (boolean)false, excludedFeatures);
    }

    protected void reorganizeMigratedElements(BlockArchitecture architecture) {
        if (architecture instanceof OperationalAnalysis) {
            OperationalAnalysis oa = (OperationalAnalysis)architecture;
            this.reorganizeOperationalAnalysis(oa);
        } else if (architecture instanceof SystemAnalysis) {
            SystemAnalysis sa = (SystemAnalysis)architecture;
            this.reorganizeSystemAnalysis(sa);
        } else if (architecture instanceof LogicalArchitecture) {
            LogicalArchitecture la = (LogicalArchitecture)architecture;
            this.reorganizeLogicalArchitecture(la);
        } else if (architecture instanceof PhysicalArchitecture) {
            PhysicalArchitecture pa = (PhysicalArchitecture)architecture;
            this.reorganizePhysicalArchitecture(pa);
        } else if (architecture instanceof EPBSArchitecture) {
            EPBSArchitecture epbs = (EPBSArchitecture)architecture;
            this.reorganizeEPBSArchitecture(epbs);
        }
    }

    protected <T> List<T> filter(List<?> objects, Class<?> clazz) {
        return objects.stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    protected void reorganizeEPBSArchitecture(EPBSArchitecture epbs) {
        if (!epbs.getOwnedMigratedElements().isEmpty()) {
            List capabilityPkgs;
            List interfacePkgs;
            List dataPkgs;
            List items;
            ComponentPkg componentPkg = BlockArchitectureExt.getComponentPkg((BlockArchitecture)epbs, (boolean)true);
            String ePBSContextId = this.archToOldContextIdsMap.get(epbs.getId());
            if (ePBSContextId != null) {
                ModelElementExt.setObjectId((ModelElement)componentPkg, (String)ePBSContextId);
            }
            List migratedComponentPkgs = epbs.getOwnedMigratedElements().stream().filter(ConfigurationItemPkg.class::isInstance).collect(Collectors.toList());
            if (migratedComponentPkgs.size() == 1) {
                this.fusionContainmentReferences((EObject)migratedComponentPkgs.get(0), (EObject)((ConfigurationItemPkg)BlockArchitectureExt.getComponentPkg((BlockArchitecture)epbs, (boolean)true)), Arrays.asList(RePackage.Literals.CATALOG_ELEMENT_LINK__TARGET));
            }
            if (!(items = this.filter((List<?>)epbs.getOwnedMigratedElements(), ConfigurationItem.class)).isEmpty()) {
                epbs.getOwnedConfigurationItemPkg().getOwnedConfigurationItems().addAll(0, items);
            }
            if (!(dataPkgs = this.filter((List<?>)epbs.getOwnedConfigurationItemPkg().getOwnedMigratedElements(), DataPkg.class)).isEmpty()) {
                BlockArchitectureExt.getDataPkg((BlockArchitecture)epbs, (boolean)true).getOwnedDataPkgs().addAll(dataPkgs);
            }
            if (!(interfacePkgs = this.filter((List<?>)epbs.getOwnedConfigurationItemPkg().getOwnedMigratedElements(), InterfacePkg.class)).isEmpty()) {
                BlockArchitectureExt.getInterfacePkg((BlockArchitecture)epbs, (boolean)true).getOwnedInterfacePkgs().addAll(interfacePkgs);
            }
            if (!(capabilityPkgs = this.filter((List<?>)epbs.getOwnedConfigurationItemPkg().getOwnedMigratedElements(), CapabilityRealizationPkg.class)).isEmpty() && BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)epbs) instanceof CapabilityRealizationPkg) {
                ((CapabilityRealizationPkg)BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)epbs)).getOwnedCapabilityRealizationPkgs().addAll(capabilityPkgs);
            }
        }
    }

    protected void reorganizePhysicalArchitecture(PhysicalArchitecture pa) {
        if (!pa.getOwnedMigratedElements().isEmpty()) {
            List capabilityPkgs;
            List interfacePkgs;
            List dataPkgs;
            List items;
            ComponentPkg componentPkg = BlockArchitectureExt.getComponentPkg((BlockArchitecture)pa, (boolean)true);
            String physicalContextId = this.archToOldContextIdsMap.get(pa.getId());
            if (physicalContextId != null) {
                ModelElementExt.setObjectId((ModelElement)componentPkg, (String)physicalContextId);
            }
            List migratedComponentPkgs = pa.getOwnedMigratedElements().stream().filter(PhysicalComponentPkg.class::isInstance).collect(Collectors.toList());
            if (migratedComponentPkgs.size() == 2) {
                this.fusionContainmentReferences((EObject)migratedComponentPkgs.get(0), (EObject)pa.getOwnedPhysicalComponentPkg(), Arrays.asList(RePackage.Literals.CATALOG_ELEMENT_LINK__TARGET));
                this.fusionContainmentReferences((EObject)migratedComponentPkgs.get(1), (EObject)pa.getOwnedPhysicalComponentPkg(), Collections.emptyList());
            }
            if (!(items = this.filter((List<?>)pa.getOwnedMigratedElements(), PhysicalComponent.class)).isEmpty()) {
                pa.getOwnedPhysicalComponentPkg().getOwnedPhysicalComponents().addAll(0, items);
            }
            if (!(dataPkgs = this.filter((List<?>)pa.getOwnedPhysicalComponentPkg().getOwnedMigratedElements(), DataPkg.class)).isEmpty()) {
                BlockArchitectureExt.getDataPkg((BlockArchitecture)pa).getOwnedDataPkgs().addAll(dataPkgs);
            }
            if (!(interfacePkgs = this.filter((List<?>)pa.getOwnedPhysicalComponentPkg().getOwnedMigratedElements(), InterfacePkg.class)).isEmpty()) {
                BlockArchitectureExt.getInterfacePkg((BlockArchitecture)pa).getOwnedInterfacePkgs().addAll(interfacePkgs);
            }
            if (!(capabilityPkgs = this.filter((List<?>)pa.getOwnedPhysicalComponentPkg().getOwnedMigratedElements(), CapabilityRealizationPkg.class)).isEmpty() && BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)pa) instanceof CapabilityRealizationPkg) {
                ((CapabilityRealizationPkg)BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)pa)).getOwnedCapabilityRealizationPkgs().addAll(capabilityPkgs);
            }
        }
    }

    protected void reorganizeLogicalArchitecture(LogicalArchitecture la) {
        if (!la.getOwnedMigratedElements().isEmpty()) {
            List capabilityPkgs;
            List interfacePkgs;
            List dataPkgs;
            List items;
            ComponentPkg componentPkg = BlockArchitectureExt.getComponentPkg((BlockArchitecture)la, (boolean)true);
            String logicalContextId = this.archToOldContextIdsMap.get(la.getId());
            if (logicalContextId != null) {
                ModelElementExt.setObjectId((ModelElement)componentPkg, (String)logicalContextId);
            }
            List migratedComponentPkgs = la.getOwnedMigratedElements().stream().filter(LogicalComponentPkg.class::isInstance).collect(Collectors.toList());
            if (migratedComponentPkgs.size() == 2) {
                this.fusionContainmentReferences((EObject)migratedComponentPkgs.get(0), (EObject)la.getOwnedLogicalComponentPkg(), Arrays.asList(RePackage.Literals.CATALOG_ELEMENT_LINK__TARGET));
                this.fusionContainmentReferences((EObject)migratedComponentPkgs.get(1), (EObject)la.getOwnedLogicalComponentPkg(), Collections.emptyList());
            }
            if (!(items = this.filter((List<?>)la.getOwnedMigratedElements(), LogicalComponent.class)).isEmpty()) {
                la.getOwnedLogicalComponentPkg().getOwnedLogicalComponents().addAll(0, items);
            }
            if (!(dataPkgs = this.filter((List<?>)la.getOwnedLogicalComponentPkg().getOwnedMigratedElements(), DataPkg.class)).isEmpty()) {
                BlockArchitectureExt.getDataPkg((BlockArchitecture)la).getOwnedDataPkgs().addAll(dataPkgs);
            }
            if (!(interfacePkgs = this.filter((List<?>)la.getOwnedLogicalComponentPkg().getOwnedMigratedElements(), InterfacePkg.class)).isEmpty()) {
                BlockArchitectureExt.getInterfacePkg((BlockArchitecture)la).getOwnedInterfacePkgs().addAll(interfacePkgs);
            }
            if (!(capabilityPkgs = this.filter((List<?>)la.getOwnedLogicalComponentPkg().getOwnedMigratedElements(), CapabilityRealizationPkg.class)).isEmpty() && BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)la) instanceof CapabilityRealizationPkg) {
                ((CapabilityRealizationPkg)BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)la)).getOwnedCapabilityRealizationPkgs().addAll(capabilityPkgs);
            }
        }
    }

    protected void reorganizeSystemAnalysis(SystemAnalysis sa) {
        if (!sa.getOwnedMigratedElements().isEmpty()) {
            List capabilityPkgs;
            List interfacePkgs;
            List dataPkgs;
            List items;
            ComponentPkg componentPkg = BlockArchitectureExt.getComponentPkg((BlockArchitecture)sa, (boolean)true);
            String systemContextId = this.archToOldContextIdsMap.get(sa.getId());
            if (systemContextId != null) {
                ModelElementExt.setObjectId((ModelElement)componentPkg, (String)systemContextId);
            }
            List migratedComponentPkgs = sa.getOwnedMigratedElements().stream().filter(SystemComponentPkg.class::isInstance).collect(Collectors.toList());
            if (migratedComponentPkgs.size() == 2) {
                this.fusionContainmentReferences((EObject)migratedComponentPkgs.get(0), (EObject)sa.getOwnedSystemComponentPkg(), Arrays.asList(RePackage.Literals.CATALOG_ELEMENT_LINK__TARGET));
                this.fusionContainmentReferences((EObject)migratedComponentPkgs.get(1), (EObject)sa.getOwnedSystemComponentPkg(), Collections.emptyList());
            }
            if (!(items = this.filter((List<?>)sa.getOwnedMigratedElements(), SystemComponent.class)).isEmpty()) {
                sa.getOwnedSystemComponentPkg().getOwnedSystemComponents().addAll(0, items);
            }
            if (!(dataPkgs = this.filter((List<?>)sa.getOwnedSystemComponentPkg().getOwnedMigratedElements(), DataPkg.class)).isEmpty()) {
                BlockArchitectureExt.getDataPkg((BlockArchitecture)sa).getOwnedDataPkgs().addAll(dataPkgs);
            }
            if (!(interfacePkgs = this.filter((List<?>)sa.getOwnedSystemComponentPkg().getOwnedMigratedElements(), InterfacePkg.class)).isEmpty()) {
                BlockArchitectureExt.getInterfacePkg((BlockArchitecture)sa).getOwnedInterfacePkgs().addAll(interfacePkgs);
            }
            if (!(capabilityPkgs = this.filter((List<?>)sa.getOwnedSystemComponentPkg().getOwnedMigratedElements(), CapabilityPkg.class)).isEmpty() && BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)sa) instanceof CapabilityPkg) {
                ((CapabilityPkg)BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)sa)).getOwnedCapabilityPkgs().addAll(capabilityPkgs);
            }
        }
    }

    protected void reorganizeOperationalAnalysis(OperationalAnalysis oa) {
        if (!oa.getOwnedMigratedElements().isEmpty()) {
            List capabilityPkgs;
            List interfacePkgs;
            List dataPkgs;
            ComponentPkg componentPkg = BlockArchitectureExt.getComponentPkg((BlockArchitecture)oa, (boolean)true);
            String operationalContextId = this.archToOldContextIdsMap.get(oa.getId());
            if (operationalContextId != null) {
                ModelElementExt.setObjectId((ModelElement)componentPkg, (String)operationalContextId);
            }
            List migratedComponentPkgs = oa.getOwnedMigratedElements().stream().filter(EntityPkg.class::isInstance).collect(Collectors.toList());
            if (migratedComponentPkgs.size() == 1) {
                this.fusionContainmentReferences((EObject)migratedComponentPkgs.get(0), (EObject)oa.getOwnedEntityPkg(), Arrays.asList(RePackage.Literals.CATALOG_ELEMENT_LINK__TARGET));
            }
            if (!(dataPkgs = this.filter((List<?>)oa.getOwnedEntityPkg().getOwnedMigratedElements(), DataPkg.class)).isEmpty()) {
                BlockArchitectureExt.getDataPkg((BlockArchitecture)oa).getOwnedDataPkgs().addAll(dataPkgs);
            }
            if (!(interfacePkgs = this.filter((List<?>)oa.getOwnedEntityPkg().getOwnedMigratedElements(), InterfacePkg.class)).isEmpty()) {
                BlockArchitectureExt.getInterfacePkg((BlockArchitecture)oa).getOwnedInterfacePkgs().addAll(interfacePkgs);
            }
            if (!(capabilityPkgs = this.filter((List<?>)oa.getOwnedEntityPkg().getOwnedMigratedElements(), OperationalCapabilityPkg.class)).isEmpty()) {
                ((OperationalCapabilityPkg)BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)oa)).getOwnedOperationalCapabilityPkgs().addAll(capabilityPkgs);
            }
        }
    }

    protected void cleanUpMigratedElements(Resource resource) {
        ArrayList<BlockArchitecture> blockArchitecturesToReorganize = new ArrayList<BlockArchitecture>();
        ArrayList<ModelElement> elementsToClean = new ArrayList<ModelElement>();
        ArrayList<TransfoLink> transfoLinksToClean = new ArrayList<TransfoLink>();
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            EObject currentElement = (EObject)iterator.next();
            if (currentElement instanceof BlockArchitecture) {
                blockArchitecturesToReorganize.add((BlockArchitecture)currentElement);
            }
            if (currentElement instanceof ModelElement && !((ModelElement)currentElement).getOwnedMigratedElements().isEmpty()) {
                elementsToClean.add((ModelElement)currentElement);
            }
            if (!(currentElement instanceof TransfoLink) || ((TransfoLink)currentElement).getSource() != null || ((TransfoLink)currentElement).getTarget() != null) continue;
            transfoLinksToClean.add((TransfoLink)currentElement);
        }
        blockArchitecturesToReorganize.stream().forEach(architecture -> this.reorganizeMigratedElements((BlockArchitecture)architecture));
        elementsToClean.stream().forEach(element -> EcoreUtil.deleteAll((Collection)element.getOwnedMigratedElements(), (boolean)true));
        EcoreUtil.deleteAll(transfoLinksToClean, (boolean)false);
    }

    @Override
    public void unaryEndMigrationExecute(ExecutionManager executionManager, Resource resource, MigrationContext context) {
        this.cleanUpMigratedElements(resource);
        super.unaryEndMigrationExecute(executionManager, resource, context);
    }

    @Override
    public boolean ignoreSetFeatureValue(EObject peekObject, EStructuralFeature feature, Object value, int position, XMLResource resource, MigrationContext context) {
        if (feature == CsPackage.Literals.COMPONENT_PKG__OWNED_PARTS && !(value instanceof Part)) {
            return true;
        }
        if (feature == ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE && value instanceof ComponentPkg) {
            return true;
        }
        return super.ignoreSetFeatureValue(peekObject, feature, value, position, resource, context);
    }

    @Override
    public void dispose(MigrationContext context) {
        this.archToOldContextIdsMap.clear();
        super.dispose(context);
    }
}

