/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.aird;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.sirius.diagram.AppliedCompositeFilters;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.DModelElement;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.data.migration.contribution.AbstractMigrationContribution;
import org.polarsys.capella.core.diagram.helpers.DAnnotationHelper;

public class FilterMigrationContribution
extends AbstractMigrationContribution {
    private static final String MIGRATED_FITLER_EXT = ".filter";
    private static final String FRAGMENT_SEPARATOR = "\\@";
    private static final String FILTER_SEPARATOR = "\\'";
    private static final String FRAGMENT_FILTER_KEY = "filters";
    private static final String PLUGIN_TYPE = "plugin";
    private static final String VALID_PLUGIN = "org.polarsys.capella.core.sirius.analysis";
    private static final String DESCRIPTION_TYPE = "description";
    private static Map<String, String> filterNameExceptions = new HashMap<String, String>();
    private Map<DiagramDescription, Set<String>> validFilterNames = new HashMap<DiagramDescription, Set<String>>();

    static {
        filterNameExceptions.put("ShowEIExchangeContext", "show.ei.exchange.context.filter");
        filterNameExceptions.put("CEParam", "show.ce.param.filter");
        filterNameExceptions.put("CEEIParam", "show.ce.ei.param.filter");
        filterNameExceptions.put("ShowFEExchangeContex", "show.fe.exchange.context.filter");
        filterNameExceptions.put("ShowCEExchangeContext", "show.ce.exchange.context.filter");
    }

    @Override
    public void unaryMigrationExecute(EObject currentElement, MigrationContext context) {
        DRepresentationDescriptor descriptor;
        DAnnotation annotation;
        if (currentElement instanceof DSemanticDiagram) {
            DSemanticDiagram diagram = (DSemanticDiagram)currentElement;
            DiagramDescription diagramDescription = diagram.getDescription();
            ArrayList filterDescriptions = new ArrayList();
            filterDescriptions.addAll(diagram.getActivatedFilters());
            diagram.getOwnedDiagramElements().stream().forEach(e -> e.getGraphicalFilters().stream().filter(AppliedCompositeFilters.class::isInstance).map(AppliedCompositeFilters.class::cast).forEach(f -> {
                boolean bl = filterDescriptions.addAll(f.getCompositeFilterDescriptions());
            }));
            for (FilterDescription filterDescription : filterDescriptions) {
                InternalEObject internalObjectFilter;
                URI filterURI;
                if (!this.isInvalidFilter(filterDescription) || !this.shouldMigrateFilter(filterURI = (internalObjectFilter = (InternalEObject)filterDescription).eProxyURI())) continue;
                String invalidFilterName = this.extractFilterName(filterURI);
                String validFilterNameCandidate = FilterMigrationContribution.getValidFilterNameCandidate(invalidFilterName);
                if (this.isValidFilterName(diagramDescription, validFilterNameCandidate)) {
                    URI validFilterURI = this.getValidFilterURI(filterURI, invalidFilterName, validFilterNameCandidate);
                    internalObjectFilter.eSetProxyURI(validFilterURI);
                    continue;
                }
                System.err.println("[Migration] Invalid filter name: " + validFilterNameCandidate + " for " + diagramDescription.getName() + " " + diagram.getUid() + "and " + invalidFilterName);
            }
        } else if (currentElement instanceof DRepresentationDescriptor && (annotation = DAnnotationHelper.getAnnotation((String)"https://www.polarsys.org/capella/dannotation/DesactivatedFilters", (DModelElement)(descriptor = (DRepresentationDescriptor)currentElement), (boolean)false)) != null) {
            HashMap oldFilter2NewFilter = new HashMap();
            annotation.getDetails().stream().forEach(a -> {
                String oldFilterName = (String)a.getKey();
                String validFilterNameCandidate = FilterMigrationContribution.getValidFilterNameCandidate(oldFilterName);
                RepresentationDescription description = descriptor.getDescription();
                if (description instanceof DiagramDescription && !this.isValidFilterName((DiagramDescription)description, oldFilterName) && this.isValidFilterName((DiagramDescription)description, validFilterNameCandidate)) {
                    oldFilter2NewFilter.put(oldFilterName, validFilterNameCandidate);
                }
            });
            oldFilter2NewFilter.keySet().stream().forEach(k -> {
                String value = (String)annotation.getDetails().get(k);
                annotation.getDetails().removeKey(k);
                annotation.getDetails().put((Object)((String)oldFilter2NewFilter.get(k)), (Object)value);
            });
        }
    }

    protected boolean isInvalidFilter(FilterDescription filterDescription) {
        return filterDescription.eIsProxy() && filterDescription.getName().isEmpty();
    }

    private boolean isValidFilterName(DiagramDescription diagramDescription, String filterName) {
        Set validDiagramFilterNames = this.validFilterNames.computeIfAbsent(diagramDescription, desc -> desc.getFilters().stream().map(this::getExistingFilterName).collect(Collectors.toSet()));
        return validDiagramFilterNames.contains(filterName);
    }

    private String getExistingFilterName(FilterDescription filter) {
        if (filter instanceof InternalEObject && filter.eIsProxy()) {
            InternalEObject internalObjectFilter = (InternalEObject)filter;
            URI invalidFilterURI = internalObjectFilter.eProxyURI();
            return this.extractFilterName(invalidFilterURI);
        }
        return filter.getName();
    }

    private String extractFilterName(URI filterURI) {
        String filterFragment;
        String fragment = filterURI.fragment();
        String[] tokens = fragment.split(FRAGMENT_SEPARATOR);
        if (tokens.length > 0 && (filterFragment = tokens[tokens.length - 1]).startsWith(FRAGMENT_FILTER_KEY) && (tokens = filterFragment.split(FILTER_SEPARATOR)).length == 3) {
            return tokens[1].replaceAll("%20", " ");
        }
        return null;
    }

    private URI getValidFilterURI(URI invalidFilterURI, String invalidFilterName, String validFilterName) {
        String uriValue = invalidFilterURI.toPlatformString(true);
        String fragment = invalidFilterURI.fragment();
        String invalidEcondedFilterName = invalidFilterName.replaceAll(" ", "%20");
        fragment = fragment.replace(invalidEcondedFilterName, validFilterName);
        return URI.createPlatformPluginURI((String)uriValue, (boolean)true).appendFragment(fragment);
    }

    private boolean shouldMigrateFilter(URI filterURI) {
        String[] filterSegments = filterURI.segments();
        return filterSegments.length == 4 && PLUGIN_TYPE.equals(filterSegments[0]) && VALID_PLUGIN.equals(filterSegments[1]) && DESCRIPTION_TYPE.equals(filterSegments[2]);
    }

    public static String getValidFilterNameCandidate(String invalidFilterName) {
        String filterNameException = filterNameExceptions.get(invalidFilterName);
        if (filterNameException != null) {
            return filterNameException;
        }
        String validName = invalidFilterName.replaceAll("/", " ");
        validName = validName.replaceAll("\\(", " ");
        validName = validName.replaceAll("\\)", " ");
        validName = validName.replaceAll("\\[", " ");
        validName = validName.replaceAll("\\]", " ");
        validName = validName.replaceAll("&", " and ");
        validName = validName.replaceAll("PCs", "pcs");
        char[] validNameCharArray = validName.toCharArray();
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < validNameCharArray.length - 1) {
            char currentLetter = validNameCharArray[i];
            char nextLetter = validNameCharArray[i + 1];
            if (Character.isUpperCase(currentLetter) && Character.isLowerCase(nextLetter)) {
                builder.append(" ");
            }
            builder.append(currentLetter);
            ++i;
        }
        builder.append(validNameCharArray[validNameCharArray.length - 1]);
        String[] tokens = builder.toString().toLowerCase().split(" ");
        builder = new StringBuilder();
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token != null && !token.isEmpty() && !token.equals(" ")) {
                if (builder.length() != 0) {
                    builder.append(".");
                }
                builder.append(token);
            }
            ++n2;
        }
        return String.valueOf(builder.toString()) + MIGRATED_FITLER_EXT;
    }
}

