/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.aird;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.helper.SiriusUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.widgets.Display;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.fa.FunctionalChainReference;
import org.polarsys.capella.core.data.migration.aird.AirdMigrationRunnable;
import org.polarsys.capella.core.data.migration.aird.Messages;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.diagram.helpers.DiagramHelper;

public class FCDDiagramMigrationRunnable
extends AirdMigrationRunnable {
    public FCDDiagramMigrationRunnable(IFile file) {
        super(file);
    }

    @Override
    public String getName() {
        return Messages.MigrationAction_FCDDiagramMigration;
    }

    @Override
    public IStatus run(MigrationContext context, boolean checkVersion) {
        IFile airdFile = this.getFile();
        URI airdURI = URI.createPlatformResourceURI((String)airdFile.getFullPath().toString(), (boolean)true);
        Session session = SessionManager.INSTANCE.getSession(airdURI, (IProgressMonitor)new NullProgressMonitor());
        session.open((IProgressMonitor)new NullProgressMonitor());
        List fcdDiagrams = DialectManager.INSTANCE.getAllLoadedRepresentations(session).stream().filter(DSemanticDiagram.class::isInstance).map(DSemanticDiagram.class::cast).filter(diagram -> diagram.getDescription().getName().equals("Functional Chain Description") || diagram.getDescription().getName().equals("Operational Process Description")).collect(Collectors.toList());
        for (DSemanticDiagram diagram2 : fcdDiagrams) {
            if (diagram2.getOwnedDiagramElements().stream().noneMatch(element -> element.getMapping().getName().equals("FC_FunctionalChain"))) continue;
            Display.getDefault().syncExec(() -> {
                DiagramHelper.getService().offScreenDiagramCopyLayout(diagram2, context.getShell());
                this.cleanOldRCRMapping(diagram2);
                this.refreshDiagramInTransaction(diagram2);
                this.collapseAllFCRContainer((DDiagram)diagram2);
                this.refreshDiagramInTransaction(diagram2);
                this.pasteLayoutInTransaction(context, diagram2);
            });
        }
        session.save((IProgressMonitor)new NullProgressMonitor());
        session.close((IProgressMonitor)new NullProgressMonitor());
        return Status.OK_STATUS;
    }

    protected void cleanOldRCRMapping(DSemanticDiagram diagram) {
        final List oldMappingFCRs = diagram.getOwnedDiagramElements().stream().filter(element -> element.getMapping().getName().equals("FC_FunctionalChain")).collect(Collectors.toList());
        TransactionHelper.getExecutionManager((EObject)diagram).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                oldMappingFCRs.stream().forEach(SiriusUtil::delete);
            }
        });
    }

    protected void pasteLayoutInTransaction(final MigrationContext context, final DSemanticDiagram diagram) {
        TransactionHelper.getExecutionManager((EObject)diagram).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                DiagramHelper.getService().offScreenDiagramPasteLayout(diagram, context.getShell());
            }
        });
    }

    protected void refreshDiagramInTransaction(final DSemanticDiagram diagram) {
        TransactionHelper.getExecutionManager((EObject)diagram).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                DialectManager.INSTANCE.refresh((DRepresentation)diagram, true, (IProgressMonitor)new NullProgressMonitor());
            }
        });
    }

    protected void collapseAllFCRContainer(DDiagram diagram) {
        diagram.getDiagramElements().stream().filter(diagramElement -> diagramElement.getTarget() instanceof FunctionalChainReference).map(DNodeContainer.class::cast).map(node -> node.getOwnedDiagramElements().stream().filter(DNodeContainer.class::isInstance).map(DNodeContainer.class::cast).findFirst().get()).forEach(node -> DiagramHelper.collapseContainer((TransactionalEditingDomain)TransactionHelper.getEditingDomain((EObject)node), (DNodeContainer)node));
    }
}

