/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.platform.sirius.customisation;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.internal.preferences.DefaultPreferences;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.common.tools.api.util.ReflectionHelper;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.ui.business.api.preferences.SiriusUIPreferencesKeys;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.polarsys.capella.common.platform.sirius.customisation.uicallback.SiriusUiCallBack;

public class SiriusCustomizationPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.polarsys.capella.common.platform.sirius.customisation";
    private static SiriusCustomizationPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        try {
            PlatformUI.getPreferenceStore().setDefault("PROMPT_WHEN_SAVEABLE_STILL_OPEN", false);
            SiriusEditPlugin.getPlugin().setUiCallback((UICallBack)new SiriusUiCallBack(SiriusEditPlugin.getPlugin().getUiCallback()));
            this.customizeSiriusDefaultPreferences();
        }
        catch (Exception e) {
            this.getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, e.getMessage(), (Throwable)e));
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static SiriusCustomizationPlugin getDefault() {
        return plugin;
    }

    private void customizeSiriusDefaultPreferences() {
        IEclipsePreferences siriusPreferences = DefaultScope.INSTANCE.getNode("org.eclipse.sirius");
        siriusPreferences.putBoolean(SiriusPreferencesKeys.PREF_EMPTY_AIRD_FRAGMENT_ON_CONTROL.name(), true);
        this.applyCommandLineCustomizations(siriusPreferences);
        IEclipsePreferences transPreferences = DefaultScope.INSTANCE.getNode("org.eclipse.sirius.common.ui");
        transPreferences.putBoolean("DEFENSIVE_VALIDATE_EDIT", false);
        this.applyCommandLineCustomizations(transPreferences);
        IEclipsePreferences editPreferences = DefaultScope.INSTANCE.getNode("org.eclipse.sirius.ui");
        editPreferences.putBoolean(SiriusUIPreferencesKeys.PREF_SAVE_WHEN_NO_EDITOR.name(), false);
        editPreferences.putBoolean(SiriusUIPreferencesKeys.PREF_RELOAD_ON_LAST_EDITOR_CLOSE.name(), false);
        editPreferences.putInt(SiriusUIPreferencesKeys.PREF_SCALE_LEVEL_DIAGRAMS_ON_EXPORT.name(), 2);
        editPreferences.putBoolean(SiriusUIPreferencesKeys.PREF_DISPLAY_VSM_USER_FIXED_COLOR_IN_PALETTE.name(), false);
        this.applyCommandLineCustomizations(editPreferences);
        IEclipsePreferences diagramPreferences = DefaultScope.INSTANCE.getNode("org.eclipse.sirius.diagram");
        diagramPreferences.putBoolean("Sirius.Connectors.JumpLink.enableOverride", true);
        diagramPreferences.putInt("Sirius.Connectors.JumpLink.status", 3);
        diagramPreferences.putInt("Sirius.Connectors.JumpLink.type", 3);
        this.applyCommandLineCustomizations(diagramPreferences);
    }

    private void applyCommandLineCustomizations(IEclipsePreferences preferencesNode) {
        if (preferencesNode instanceof DefaultPreferences) {
            try {
                ReflectionHelper.invokeMethod((Object)preferencesNode, DefaultPreferences.class, (String)"applyCommandLineDefaults", (Class[])new Class[0], (Object[])new Object[0], (boolean)true);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                this.getLog().log((IStatus)new Status(4, PLUGIN_ID, 4, "Failed to apply plugin customization from command line arguments for plugin org.polarsys.capella.common.platform.sirius.customisation", (Throwable)e));
            }
        }
    }
}

