/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.information;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.helpers.capellacore.services.GeneralizableElementExt;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.ExchangeItemElement;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.utils.ListExt;

public class GetAvailable_ExchangeItemElement_ReferencedProperties
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<EObject> availableElements = this.getAvailableElements(capellaElement);
        return availableElements;
    }

    public List<EObject> getAvailableElements(CapellaElement element) {
        List<Object> availableElements = new ArrayList<EObject>();
        if (element instanceof ExchangeItemElement) {
            availableElements.addAll(this.getRule_MQRY_ExchangeItemElement_AvailableProperties_11((ExchangeItemElement)element));
            availableElements = ListExt.removeDuplicates(availableElements);
        }
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_ExchangeItemElement_AvailableProperties_11(ExchangeItemElement exchange) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        BlockArchitecture currentBlockArchitecture = SystemEngineeringExt.getRootBlockArchitecture((ModelElement)exchange);
        if (currentBlockArchitecture != null) {
            availableElements.addAll(this.getElementsFromBlockArchitecture(currentBlockArchitecture, exchange));
            for (BlockArchitecture previousBlockArchitecture : BlockArchitectureExt.getPreviousBlockArchitectures((BlockArchitecture)currentBlockArchitecture)) {
                availableElements.addAll(this.getElementsFromBlockArchitecture(previousBlockArchitecture, exchange));
            }
        }
        return availableElements;
    }

    private List<CapellaElement> getElementsFromBlockArchitecture(BlockArchitecture arch, ExchangeItemElement exchangeItemEle) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        AbstractType abstractType = exchangeItemEle.getAbstractType();
        if (abstractType instanceof Class) {
            Class cls = (Class)abstractType;
            List allSuperGeneralizableElements = GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)cls);
            allSuperGeneralizableElements.add(cls);
            for (GeneralizableElement generalizableElement : allSuperGeneralizableElements) {
                Class genEleClass;
                EList properties;
                if (!(generalizableElement instanceof Class) || (properties = (genEleClass = (Class)generalizableElement).getContainedProperties()).isEmpty()) continue;
                availableElements.addAll((Collection<CapellaElement>)properties);
            }
        }
        availableElements.remove(exchangeItemEle);
        return availableElements;
    }

    public List<CapellaElement> getCurrentElements(CapellaElement element, boolean onlyGenerated) {
        ArrayList<CapellaElement> currentElements = new ArrayList<CapellaElement>();
        if (element instanceof ExchangeItemElement) {
            ExchangeItemElement exchange = (ExchangeItemElement)element;
            currentElements.addAll((Collection<CapellaElement>)exchange.getReferencedProperties());
        }
        return currentElements;
    }
}

