/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.cs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeAllocation;
import org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.LogicalComponentExt;
import org.polarsys.capella.core.model.helpers.PartExt;
import org.polarsys.capella.core.model.helpers.PhysicalComponentExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.utils.ListExt;

public class GetAvailable_PhysicalLink_AllocatedComponentExchanges
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<EObject> availableElements = this.getAvailableElements(capellaElement);
        return availableElements;
    }

    public List<EObject> getAvailableElements(CapellaElement element) {
        List<Object> availableElements = new ArrayList<EObject>();
        BlockArchitecture arch = SystemEngineeringExt.getRootBlockArchitecture((ModelElement)element);
        if (arch == null) {
            return availableElements;
        }
        if (element instanceof PhysicalLink) {
            PhysicalLink link = (PhysicalLink)element;
            Component sourceComponent = PhysicalLinkExt.getSourceComponent((PhysicalLink)link);
            Component targetComponent = PhysicalLinkExt.getTargetComponent((PhysicalLink)link);
            if (sourceComponent != null && targetComponent != null) {
                availableElements.addAll(GetAvailable_PhysicalLink_AllocatedComponentExchanges.getAvailableExchanges(sourceComponent, targetComponent));
            }
            ArrayList<EObject> allReadyAllocatedConnection = new ArrayList<EObject>();
            for (EObject eObject : availableElements) {
                if (!(eObject instanceof ComponentExchange)) continue;
                ComponentExchange connection = (ComponentExchange)eObject;
                EList incomingTraces = connection.getIncomingTraces();
                for (AbstractTrace abstractTrace : incomingTraces) {
                    if (!(abstractTrace instanceof ComponentExchangeAllocation) || ((ComponentExchangeAllocation)abstractTrace).getComponentExchangeAllocator() == element) continue;
                    allReadyAllocatedConnection.add(eObject);
                }
            }
            availableElements.removeAll(allReadyAllocatedConnection);
        }
        availableElements = ListExt.removeDuplicates(availableElements);
        return availableElements;
    }

    public static List<CapellaElement> getAvailableExchanges(Component sourceComponent, Component targetComponent) {
        AbstractType abstractType;
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        ArrayList<Component> sourceDeployedElements = new ArrayList<Component>(1);
        ArrayList<Component> targetDeployedElements = new ArrayList<Component>(1);
        Collection sourceComponents = ComponentExt.getAllSubUsedComponents((Component)sourceComponent);
        sourceComponents.add(sourceComponent);
        Collection targetComponents = ComponentExt.getAllSubUsedComponents((Component)targetComponent);
        targetComponents.add(targetComponent);
        for (Component component : sourceComponents) {
            if (component instanceof SystemComponent) {
                sourceDeployedElements.add(component);
                continue;
            }
            if (component instanceof LogicalComponent) {
                sourceDeployedElements.addAll(LogicalComponentExt.getAllSubComponents((LogicalComponent)((LogicalComponent)component)));
                continue;
            }
            if (!(component instanceof PhysicalComponent)) continue;
            for (AbstractTypedElement abstractTypedElement : component.getAbstractTypedElements()) {
                if (!(abstractTypedElement instanceof Part)) continue;
                for (DeployableElement deployableElement : Stream.concat(PartExt.getSubUsedParts((Part)((Part)abstractTypedElement)).stream(), PartExt.getAllDeployableElements((Part)((Part)abstractTypedElement)).stream()).collect(Collectors.toList())) {
                    if (!(deployableElement instanceof Part) || !((abstractType = ((Part)deployableElement).getAbstractType()) instanceof Component)) continue;
                    sourceDeployedElements.add((Component)abstractType);
                }
            }
        }
        for (Component component : targetComponents) {
            if (component instanceof SystemComponent) {
                targetDeployedElements.add(component);
                continue;
            }
            if (component instanceof LogicalComponent) {
                targetDeployedElements.addAll(LogicalComponentExt.getAllSubComponents((LogicalComponent)((LogicalComponent)component)));
                continue;
            }
            if (!(component instanceof PhysicalComponent)) continue;
            for (AbstractTypedElement abstractTypedElement : component.getAbstractTypedElements()) {
                if (!(abstractTypedElement instanceof Part)) continue;
                for (DeployableElement deployableElement : Stream.concat(PartExt.getSubUsedParts((Part)((Part)abstractTypedElement)).stream(), PartExt.getAllDeployableElements((Part)((Part)abstractTypedElement)).stream()).collect(Collectors.toList())) {
                    if (!(deployableElement instanceof Part) || !((abstractType = ((Part)deployableElement).getAbstractType()) instanceof Component)) continue;
                    targetDeployedElements.add((Component)abstractType);
                }
            }
        }
        availableElements.addAll(PhysicalComponentExt.findConnectionsBetweenPhysicalComponentes(sourceDeployedElements, targetDeployedElements));
        availableElements.addAll(PhysicalComponentExt.findConnectionsBetweenPhysicalComponentes(targetDeployedElements, sourceDeployedElements));
        return availableElements;
    }

    public List<CapellaElement> getCurrentElements(CapellaElement element, boolean onlyGenerated) {
        ArrayList<CapellaElement> currentElements = new ArrayList<CapellaElement>();
        if (element instanceof PhysicalLink) {
            PhysicalLink ele = (PhysicalLink)element;
            EList ownedComponentExchangeAllocation = ele.getOwnedComponentExchangeAllocations();
            for (ComponentExchangeAllocation ownedComponentExchangeAll : ownedComponentExchangeAllocation) {
                ComponentExchange componentExchangeAllocated = ownedComponentExchangeAll.getComponentExchangeAllocated();
                if (componentExchangeAllocated == null) continue;
                currentElements.add((CapellaElement)componentExchangeAllocated);
            }
        }
        return currentElements;
    }
}

