/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.ui.quickfix.resolver;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.SequenceLink;
import org.polarsys.capella.core.data.fa.properties.controllers.SequenceLinkLinksController;
import org.polarsys.capella.core.model.utils.NamingHelper;
import org.polarsys.capella.core.ui.toolkit.helpers.SelectionDialogHelper;
import org.polarsys.capella.core.validation.ui.ide.PluginActivator;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractCapellaMarkerResolution;

public class DWF_DF_18_Resolver
extends AbstractCapellaMarkerResolution {
    private final String PROCESS_ICON = "icons/full/obj16/capella_process.gif";
    private String overridenLabel;

    public DWF_DF_18_Resolver(String label) {
        this.overridenLabel = label;
        super.setContributorId("org.polarsys.capella.core.ui.resources");
        super.setImgKey("icons/full/obj16/capella_process.gif");
    }

    public void run(IMarker marker) {
        List modelElements = this.getModelElements(marker);
        if (!modelElements.isEmpty() && modelElements.get(0) instanceof SequenceLink) {
            this.openSelectionDialog((SequenceLink)modelElements.get(0), marker);
        }
    }

    protected void openSelectionDialog(final SequenceLink semanticElement, final IMarker marker) {
        AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

            public void run() {
                SequenceLinkLinksController controller = new SequenceLinkLinksController();
                EReference semanticFeature = FaPackage.eINSTANCE.getSequenceLink_Links();
                List currentElements = controller.readOpenValues((EObject)semanticElement, (EStructuralFeature)semanticFeature, false);
                List availableElements = controller.readOpenValues((EObject)semanticElement, (EStructuralFeature)semanticFeature, true);
                availableElements.removeAll(currentElements);
                String title = NamingHelper.getDefaultTitle((EObject)semanticElement);
                String message = NamingHelper.getDefaultMessage((EObject)semanticElement, (String)(semanticFeature != null ? semanticFeature.getName() : ""));
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                List allResults = SelectionDialogHelper.multiplePropertyTransfertDialogWizard((Shell)shell, (String)title, (String)message, (List)availableElements, (List)currentElements);
                if (allResults != null) {
                    controller.writeOpenValues((EObject)semanticElement, (EStructuralFeature)semanticFeature, allResults);
                    DWF_DF_18_Resolver.this.deleteMarker(marker);
                }
            }
        };
        TransactionHelper.getExecutionManager((EObject)semanticElement).execute((ICommand)command);
    }

    protected void deleteMarker(IMarker marker) {
        try {
            marker.delete();
        }
        catch (CoreException exception) {
            StatusManager.getManager().handle((IStatus)new Status(4, PluginActivator.getDefault().getPluginId(), exception.getMessage(), (Throwable)exception));
        }
    }

    public String getLabel() {
        return this.overridenLabel;
    }
}

