/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.scenario.fc2fs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacommon.TransfoLink;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.oa.OperationalProcess;
import org.polarsys.capella.core.model.helpers.AbstractCapabilityPkgExt;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.refmap.Pair;
import org.polarsys.capella.core.projection.common.TransitionHelper;
import org.polarsys.capella.core.transition.system.topdown.preferences.PreferenceHelper;
import org.polarsys.capella.core.ui.toolkit.helpers.SelectionDialogHelper;

public class FC2FSExt {
    private FC2FSExt() {
    }

    public static boolean isLogEnabled() {
        PreferenceHelper preferenceHelper = PreferenceHelper.getInstance();
        return preferenceHelper.isFC2FSLogEnabled();
    }

    public static boolean isCreateMsgWithReply(FunctionalChain fc) {
        PreferenceHelper preferenceHelper = PreferenceHelper.getInstance();
        if (fc instanceof OperationalProcess) {
            return preferenceHelper.isOP2OASCreateMsgWithReply();
        }
        return preferenceHelper.isFC2FSCreateMsgWithReply();
    }

    public static void addToModel(final Collection<Pair<FunctionalChain, Scenario>> fc2ScenarioPairs) {
        Session session = SessionManager.INSTANCE.getSession((EObject)fc2ScenarioPairs.iterator().next().getFirstValue());
        ExecutionManager manager = TransactionHelper.getExecutionManager((Session)session);
        manager.execute((ICommand)new AbstractReadWriteCommand(){
            Collection<Scenario> addedScenarions = new ArrayList<Scenario>();

            public void run() {
                for (Pair next : fc2ScenarioPairs) {
                    FunctionalChain fc = (FunctionalChain)next.getFirstValue();
                    Scenario scenario = (Scenario)next.getSecondValue();
                    AbstractCapability capability = FC2FSExt.getCapability(fc);
                    if (capability != null) {
                        String uniqueName = EcoreUtil2.getUniqueName((EObject)scenario, (EObject)capability, (EStructuralFeature)InteractionPackage.eINSTANCE.getAbstractCapability_OwnedScenarios(), (EAttribute)ModellingcorePackage.eINSTANCE.getAbstractNamedElement_Name(), (String)scenario.getName());
                        scenario.setName(uniqueName);
                        capability.getOwnedScenarios().add((Object)scenario);
                    }
                    this.addedScenarions.add(scenario);
                }
            }

            public Collection<?> getAffectedObjects() {
                return this.addedScenarions;
            }
        });
    }

    public static AbstractCapability getCapability(FunctionalChain functionalChain) {
        EObject eContainer = functionalChain.eContainer();
        if (eContainer instanceof AbstractCapability) {
            return (AbstractCapability)eContainer;
        }
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)functionalChain);
        AbstractCapabilityPkg capabilityPkg = BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)architecture);
        if (capabilityPkg != null) {
            List allCapabilities = AbstractCapabilityPkgExt.getAllAbstractCapabilities((AbstractCapabilityPkg)capabilityPkg);
            if (allCapabilities.size() == 1) {
                return (AbstractCapability)allCapabilities.iterator().next();
            }
            if (!allCapabilities.isEmpty()) {
                Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                return (AbstractCapability)SelectionDialogHelper.simplePropertySelectionDialogWizard(new ArrayList(allCapabilities), (Shell)shell);
            }
            return AbstractCapabilityPkgExt.createAbstractCapability((AbstractCapabilityPkg)capabilityPkg);
        }
        return null;
    }

    public static Collection<Scenario> getAvailableInitializedScenarios(FunctionalChain fc) {
        HashSet<Scenario> result = new HashSet<Scenario>();
        List referencers = EObjectExt.getReferencers((EObject)fc, (EClass)CapellacommonPackage.Literals.TRANSFO_LINK, (EReference)ModellingcorePackage.eINSTANCE.getAbstractTrace_TargetElement());
        BlockArchitecture fcBlockArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)fc);
        for (EObject referencer : referencers) {
            Scenario scenario;
            BlockArchitecture scenarioBlockArchitecture;
            if (!(referencer instanceof TransfoLink) || !(referencer.eContainer() instanceof Scenario) || !TransitionHelper.getService().isFunctionalScenario((Scenario)referencer.eContainer()) || !EcoreUtil.equals((EObject)fcBlockArchitecture, (EObject)(scenarioBlockArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)(scenario = (Scenario)referencer.eContainer()))))) continue;
            result.add(scenario);
        }
        return result;
    }

    public static Shell getActiveShell() {
        return Display.getDefault().getActiveShell();
    }
}

