/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.scenario.commands;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.projection.common.AbstractTransform;
import org.polarsys.capella.core.projection.common.TransitionHelper;
import org.polarsys.capella.core.projection.scenario.Messages;
import org.polarsys.capella.core.projection.scenario.commands.ESToISCommand;
import org.polarsys.capella.core.projection.scenario.topdown.TopDownTransform;

public class IStoISCommand
extends ESToISCommand {
    public IStoISCommand(Collection<EObject> rootElements) {
        super(rootElements);
    }

    public IStoISCommand(Collection<EObject> rootElements, IProgressMonitor progressMonitor) {
        super(rootElements, progressMonitor);
    }

    @Override
    public String getName() {
        if (this.rootElements != null && !this.rootElements.isEmpty()) {
            EObject element = (EObject)this.rootElements.iterator().next();
            if (TransitionHelper.getService().isIS2ISSALATransitionAvailable(element)) {
                return Messages.transitionIS2IS_SAtoLA_label;
            }
            if (TransitionHelper.getService().isIS2ISLAPATransitionAvailable(element)) {
                return Messages.transitionIS2IS_LAtoPA_label;
            }
            if (TransitionHelper.getService().isIS2ISPAEPBSTransitionAvailable(element)) {
                return Messages.transitionIS2IS_PAtoEPBS_label;
            }
        }
        return Messages.transitionIS2IS_label;
    }

    @Override
    protected AbstractTransform getTransformation(EObject element) {
        return new TopDownTransform();
    }

    @Override
    protected boolean isScenarioValid(Scenario scenario) {
        return TransitionHelper.getService().isIS2ISSALATransitionAvailable((EObject)scenario) || TransitionHelper.getService().isIS2ISLAPATransitionAvailable((EObject)scenario) || TransitionHelper.getService().isIS2ISPAEPBSTransitionAvailable((EObject)scenario);
    }
}

