/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.project.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.widgets.Composite;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.core.platform.sirius.ui.project.CapellaProjectActivator;
import org.polarsys.capella.core.platform.sirius.ui.project.internal.Messages;
import org.polarsys.capella.core.platform.sirius.ui.project.internal.ProjectContentsLocationArea;
import org.polarsys.capella.core.platform.sirius.ui.project.provider.IDefaultProjectLocationProvider;

public class CapellaProjectContentsLocationArea
extends ProjectContentsLocationArea {
    private static final String PROJECT_LOCATION_PROVIDER_EXTENSION_POINT_ID = "defaultProjectLocationProvider";
    private IDefaultProjectLocationProvider _defaultProjectLocationProvider;

    public CapellaProjectContentsLocationArea(ProjectContentsLocationArea.IErrorMessageReporter reporter_p, Composite composite_p, IProject startProject_p) {
        super(reporter_p, composite_p, startProject_p);
    }

    public CapellaProjectContentsLocationArea(ProjectContentsLocationArea.IErrorMessageReporter reporter_p, Composite composite_p) {
        super(reporter_p, composite_p);
    }

    @Override
    protected void createContents(Composite composite_p, boolean defaultEnabled_p) {
        super.createContents(composite_p, defaultEnabled_p);
        this.updateLocationField(this.getDefaultPathDisplayString());
    }

    protected IDefaultProjectLocationProvider getDefaultProjectLocationContribution() {
        Object instantiatedClass;
        IDefaultProjectLocationProvider contribution = null;
        IConfigurationElement[] configurationElements = ExtensionPointHelper.getConfigurationElements((String)CapellaProjectActivator.getDefault().getPluginId(), (String)PROJECT_LOCATION_PROVIDER_EXTENSION_POINT_ID);
        if (configurationElements.length > 0 && (instantiatedClass = ExtensionPointHelper.createInstance((IConfigurationElement)configurationElements[0], (String)"class")) instanceof IDefaultProjectLocationProvider) {
            contribution = (IDefaultProjectLocationProvider)instantiatedClass;
        }
        return contribution;
    }

    @Override
    protected String getDefaultPathDisplayString() {
        if (this._defaultProjectLocationProvider == null) {
            this._defaultProjectLocationProvider = this.getDefaultProjectLocationContribution();
        }
        if (this._defaultProjectLocationProvider == null) {
            return super.getDefaultPathDisplayString();
        }
        String defaultProjectLocation = this._defaultProjectLocationProvider.getDefaultProjectLocation();
        return defaultProjectLocation == null ? super.getDefaultPathDisplayString() : new Path(defaultProjectLocation).append(this.getProjectName()).toString();
    }

    @Override
    public void updateProjectName(String newName_p) {
        super.updateProjectName(newName_p);
        if (this._defaultProjectLocationProvider != null && this.isUseDefaultButtonChecked()) {
            this.updateLocationField(TextProcessor.process((String)this.getDefaultPathDisplayString()));
        }
    }

    @Override
    public String checkValidLocation() {
        String isValid = super.checkValidLocation();
        if (isValid == null) {
            String projectName = this.getProjectName();
            if (projectName.contains("&")) {
                isValid = NLS.bind((String)Messages.CapellaProjectContentsLocationArea_CapellaProjectContentsLocationArea_ErrorMessage_ForbiddenCharacter, (Object)Character.valueOf('&'));
                return isValid;
            }
            Object projectFolder = null;
            String defaultPathDisplayString = this.getDefaultPathDisplayString();
            if (this._defaultProjectLocationProvider != null && this.isUseDefaultButtonChecked()) {
                if (!"".equals(defaultPathDisplayString)) {
                    projectFolder = new Path(defaultPathDisplayString);
                } else {
                    isValid = this._defaultProjectLocationProvider.getErrorMessage();
                }
            } else {
                projectFolder = this.isDefault() ? new Path(defaultPathDisplayString) : new Path(this.getProjectLocation()).append(projectName);
            }
            if (projectFolder != null && projectFolder.toFile().exists()) {
                isValid = Messages.CapellaProjectContentsLocationArea_ErrorMessage_FolderAlreadyExists;
            }
        }
        return isValid;
    }

    @Override
    public String getProjectLocation() {
        String projectLocation = super.getProjectLocation();
        if (this._defaultProjectLocationProvider != null && this.isUseDefaultButtonChecked() && this._defaultProjectLocationProvider.getDefaultProjectLocation() != null) {
            projectLocation = new Path(projectLocation).removeLastSegments(1).toString();
        }
        return projectLocation;
    }

    protected boolean isUseDefaultButtonChecked() {
        return this.useDefaultsButton.getSelection();
    }

    @Override
    public boolean isDefault() {
        if (this._defaultProjectLocationProvider == null || this._defaultProjectLocationProvider.getDefaultProjectLocation() == null) {
            return super.isDefault();
        }
        return false;
    }
}

