/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.detachment.propertyvalue.command;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.capella.core.model.handler.crossreferencer.CapellaECrossReferenceAdapter;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;
import org.polarsys.capella.detachment.propertyvalue.messages.Messages;
import org.polarsys.capella.detachment.propertyvalues.scrutinizers.PropertyValuesScrutinizer;
import org.polarsys.kitalpha.model.common.commands.action.ModelCommand;
import org.polarsys.kitalpha.model.common.commands.exception.ModelCommandException;
import org.polarsys.kitalpha.model.common.scrutiny.analyzer.ModelScrutinyException;
import org.polarsys.kitalpha.model.common.scrutiny.interfaces.IScrutinize;
import org.polarsys.kitalpha.model.common.scrutiny.registry.ModelScrutinyRegistry;

public class PropertyValuesDeleteCommand
extends ModelCommand {
    Logger LOGGER = Logger.getLogger(PropertyValuesDeleteCommand.class);

    public void exec(ModelScrutinyRegistry analysis, Resource resource, IProgressMonitor monitor) throws ModelCommandException {
        try {
            ModelScrutinyRegistry.RegistryElement regElt = analysis.getRegistryElement(this.getModelAnalysisID());
            for (IScrutinize finder : regElt.getFinders()) {
                if (!(finder instanceof PropertyValuesScrutinizer)) continue;
                Object result = ((PropertyValuesScrutinizer)finder).getAnalysisResult();
                this.deleteProperties((Map<EObject, Boolean>)result, resource, monitor);
            }
            monitor.done();
        }
        catch (ModelScrutinyException e) {
            this.LOGGER.error((Object)Messages.PVDetachmentCommand_RuntimeError, (Throwable)e);
        }
    }

    private void deleteProperties(Map<EObject, Boolean> result, Resource resource, IProgressMonitor monitor) {
        if (result != null && !result.isEmpty()) {
            URI uri = resource.getURI();
            if (uri.lastSegment() == null || !uri.lastSegment().endsWith("aird")) {
                return;
            }
            resource.getURI();
            Session session = SessionManager.INSTANCE.getExistingSession(uri);
            TransactionalEditingDomain ed = null;
            ed = session != null ? session.getTransactionalEditingDomain() : TransactionUtil.getEditingDomain((Resource)resource);
            monitor.beginTask(Messages.PVDetachmentCommand_MonitorMessage, 1);
            this.installCapellaECrossReferencerAdapter(resource.getResourceSet(), (EditingDomain)ed);
            Collection<Object> elementsToDelete = this.getElementsToDelete(result);
            CapellaDeleteCommand deleteCommand = new CapellaDeleteCommand((EditingDomain)ed, elementsToDelete, false);
            if (deleteCommand.canExecute()) {
                ed.getCommandStack().execute((Command)deleteCommand);
            }
            monitor.worked(1);
        }
    }

    private void installCapellaECrossReferencerAdapter(ResourceSet set, EditingDomain ed) {
        Adapter adapter2;
        EList eAdapters = set.eAdapters();
        for (Adapter adapter2 : eAdapters) {
            if (!(adapter2 instanceof CapellaECrossReferenceAdapter)) continue;
            return;
        }
        adapter2 = new CapellaECrossReferenceAdapter(ed);
        eAdapters.add((Object)adapter2);
    }

    private Collection<Object> getElementsToDelete(Map<EObject, Boolean> result) {
        HashSet<Object> toDelete = new HashSet<Object>();
        for (Map.Entry<EObject, Boolean> e : result.entrySet()) {
            if (!e.getValue().booleanValue()) continue;
            toDelete.add(e.getKey());
        }
        return toDelete;
    }
}

