/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.property;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.polarsys.capella.common.flexibility.properties.property.AbstractProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IEditableProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyValueProperty;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.ui.properties.property.PropertiesServices;

public abstract class PropertyValueProperty
extends AbstractProperty
implements IEditableProperty,
IPropertyValueProperty {
    protected abstract String[] getPathProperty();

    protected void unsetPropertyValue(NamedElement element) {
        PropertiesServices.unsetProperty((CapellaElement)element, this.getPathProperty());
    }

    protected void setPropertyValue(NamedElement element, String value) {
        PropertiesServices.setPropertyValue((CapellaElement)element, this.getPathProperty(), value, true);
    }

    protected String getPropertyValue(NamedElement element) {
        return PropertiesServices.getPropertyValue((CapellaElement)element, this.getPathProperty(), "");
    }

    public Object getType() {
        return Integer.class;
    }

    public Object toType(Object value, IPropertyContext context) {
        if (value != null && !"".equals(value)) {
            return Integer.valueOf(value.toString());
        }
        return null;
    }

    public Object getValue(IPropertyContext context) {
        NamedElement element = (NamedElement)this.getSource(context);
        return Integer.valueOf(this.getPropertyValue(element));
    }

    public void setValue(IPropertyContext context) {
        Object value = context.getCurrentValue((IProperty)this);
        NamedElement element = (NamedElement)this.getSource(context);
        if (value != null && value instanceof Integer) {
            this.setPropertyValue(element, ((Integer)value).toString());
        } else {
            this.unsetPropertyValue(element);
        }
    }

    public IStatus validate(Object newValue, IPropertyContext context) {
        try {
            if (newValue != null && !"".equals(newValue)) {
                Integer.parseInt(newValue.toString());
            }
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return new Status(4, this.getId(), e.getMessage());
        }
    }
}

