/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.datavalue;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum UnaryOperator implements Enumerator
{
    UNSET(0, "UNSET", "UNSET"),
    NOT(1, "NOT", "NOT"),
    POS(2, "POS", "POS"),
    VAL(3, "VAL", "VAL"),
    SUC(4, "SUC", "SUC"),
    PRE(5, "PRE", "PRE");

    public static final int UNSET_VALUE = 0;
    public static final int NOT_VALUE = 1;
    public static final int POS_VALUE = 2;
    public static final int VAL_VALUE = 3;
    public static final int SUC_VALUE = 4;
    public static final int PRE_VALUE = 5;
    private static final UnaryOperator[] VALUES_ARRAY;
    public static final List<UnaryOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new UnaryOperator[]{UNSET, NOT, POS, VAL, SUC, PRE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static UnaryOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UnaryOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UnaryOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UnaryOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UnaryOperator get(int value) {
        switch (value) {
            case 0: {
                return UNSET;
            }
            case 1: {
                return NOT;
            }
            case 2: {
                return POS;
            }
            case 3: {
                return VAL;
            }
            case 4: {
                return SUC;
            }
            case 5: {
                return PRE;
            }
        }
        return null;
    }

    private UnaryOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

