/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.tiger.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacommon.GenericTrace;
import org.polarsys.capella.core.data.capellacommon.TransfoLink;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.ModelRoot;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.sharedmodel.SharedPkg;
import org.polarsys.capella.core.tiger.IResolver;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.TransfoException;
import org.polarsys.capella.core.tiger.impl.Transfo;

public class Query {
    private Query() {
    }

    private static List<AbstractTrace> getIncomingTraces(CapellaElement element, ITransfo transfo) {
        return element.getIncomingTraces();
    }

    private static List<AbstractTrace> getOutgoingTraces(CapellaElement element, ITransfo transfo) {
        return element.getOutgoingTraces();
    }

    public static IResolver getResolver(ITransfo transfo) {
        List<IResolver> resolvers = transfo.getResolvers();
        if (resolvers.size() > 0) {
            return resolvers.get(0);
        }
        return null;
    }

    public static boolean isElementTransformed(EObject object, ITransfo transfo) {
        return Query.retrieveTransformedElement(object, transfo) != null;
    }

    public static boolean isElementTransformed(EObject object, ITransfo transfo, EClass eTargetType) {
        return Query.retrieveTransformedElement(object, transfo, eTargetType) != null;
    }

    public static boolean isLinkOfTransfo(AbstractTrace link, ITransfo transfo) {
        if (transfo == null) {
            return false;
        }
        return Query.isValidUID(link, transfo) && transfo instanceof Transfo && ((Transfo)transfo).isValidLinkKind(link);
    }

    public static boolean isOneToManyTransformed(EObject object, ITransfo transfo) {
        return Query.retrieveTransformedElements(object, transfo).size() > 1;
    }

    public static boolean isOneToOneTransformed(EObject object, ITransfo transfo) {
        return Query.isOneToOneTransformed(object, transfo, null);
    }

    public static boolean isOneToOneTransformed(EObject object, ITransfo transfo, EClass target) {
        Object result = Query.retrieveTransformedElement(object, transfo, target);
        return result != null && (!(result instanceof List) || ((List)result).size() <= 1);
    }

    public static boolean isValidUID(AbstractTrace link_p, ITransfo transfo_p) {
        return !(link_p instanceof GenericTrace) || link_p instanceof TransfoLink;
    }

    public static List<String> retrieveContainmentRelationships(EObject element) {
        EClass clazz = element.eClass();
        EList features = clazz.getEAllContainments();
        ArrayList<String> relationshipNameList = new ArrayList<String>();
        for (Object featureObject : features) {
            EReference feature = (EReference)featureObject;
            if (!feature.isContainer()) continue;
            relationshipNameList.add(feature.getName());
        }
        return relationshipNameList;
    }

    public static EObject retrieveFirstTransformedElement(EObject object, ITransfo transfo) {
        return Query.retrieveFirstTransformedElement(object, transfo, null);
    }

    public static EObject retrieveFirstTransformedElement(EObject object, ITransfo transfo, EClass expectedTarget) {
        Object res = Query.retrieveTransformedElement(object, transfo, expectedTarget);
        if (res instanceof List) {
            List p = (List)res;
            return (EObject)p.get(0);
        }
        return (EObject)res;
    }

    public static ModelRoot retrieveModelRoot(EObject object) {
        EObject currentElement = object;
        while (currentElement != null) {
            if (currentElement instanceof ModelRoot) {
                return (ModelRoot)currentElement;
            }
            currentElement = currentElement.eContainer();
        }
        return null;
    }

    public static List<EObject> retrieveRelatedElements(EObject element, EReference relationshipString) {
        ArrayList<EObject> relatedElements = new ArrayList<EObject>();
        if (!relationshipString.isDerived()) {
            try {
                Object obj = element.eGet((EStructuralFeature)relationshipString);
                if (obj instanceof EObject) {
                    EObject eObject = (EObject)obj;
                    relatedElements.add(eObject);
                } else if (obj instanceof EList) {
                    EList eObject = (EList)obj;
                    relatedElements.addAll((Collection<EObject>)eObject);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return relatedElements;
    }

    public static List<EObject> retrieveRelatedElements(EObject element, EReference[] relationships) {
        ArrayList<EObject> relatedElements = new ArrayList<EObject>();
        EReference[] eReferenceArray = relationships;
        int n = relationships.length;
        int n2 = 0;
        while (n2 < n) {
            EReference relationship = eReferenceArray[n2];
            relatedElements.addAll(Query.retrieveRelatedElements(element, relationship));
            ++n2;
        }
        return relatedElements;
    }

    public static List<String> retrieveRelationships(EObject element) {
        EClass clazz = element.eClass();
        EList features = clazz.getEAllStructuralFeatures();
        ArrayList<String> relationshipNameList = new ArrayList<String>();
        for (Object featureObject : features) {
            EStructuralFeature feature = (EStructuralFeature)featureObject;
            relationshipNameList.add(feature.getName());
        }
        return relationshipNameList;
    }

    public static List<SharedPkg> retrieveSharedPkgs(EObject object) {
        EList objects = object.eContents();
        ArrayList<SharedPkg> sharedPkgs = new ArrayList<SharedPkg>();
        for (EObject obj : objects) {
            if (!(obj instanceof SharedPkg)) continue;
            SharedPkg sharedPkg = (SharedPkg)obj;
            sharedPkgs.add(sharedPkg);
        }
        return sharedPkgs;
    }

    public static List<SharedPkg> retrieveSharedPkgsOfElement(EObject object) {
        SystemEngineering systemEngineering = Query.retrieveSystemEngineering(object);
        return Query.retrieveSharedPkgs(systemEngineering.eContainer());
    }

    public static List<? extends EObject> retrieveSourceElements(EObject targetElement, ITransfo transfo, EClass expectedTarget) {
        ArrayList<TraceableElement> results = new ArrayList<TraceableElement>();
        if (targetElement instanceof CapellaElement) {
            CapellaElement element = (CapellaElement)targetElement;
            try {
                transfo.findCachedMatchingRule(targetElement);
            }
            catch (TransfoException transfoException) {
                // empty catch block
            }
            List<AbstractTrace> traceList = Query.getOutgoingTraces(element, transfo);
            for (AbstractTrace trace : traceList) {
                if (!Query.isLinkOfTransfo(trace, transfo)) continue;
                TraceableElement srcElement = trace.getTargetElement();
                if (expectedTarget != null && !EcoreUtil2.isEqualOrSuperClass((EClass)expectedTarget, (EClass)srcElement.eClass())) continue;
                results.add(srcElement);
            }
        }
        return results;
    }

    protected static SystemEngineering retrieveSystemEngineering(EObject object) {
        EObject currentElement = object.eContainer();
        while (currentElement != null) {
            if (currentElement instanceof SystemEngineering) {
                return (SystemEngineering)currentElement;
            }
            currentElement = currentElement.eContainer();
        }
        return null;
    }

    public static Object retrieveTransformedElement(EObject object, ITransfo transfo) {
        return Query.retrieveTransformedElement(object, transfo, null);
    }

    public static Object retrieveTransformedElement(EObject object, ITransfo transfo, EClass expectedTarget) {
        ArrayList<TraceableElement> result = new ArrayList<TraceableElement>();
        if (object instanceof CapellaElement) {
            CapellaElement element = (CapellaElement)object;
            try {
                transfo.findCachedMatchingRule(object);
            }
            catch (TransfoException transfoException) {
                // empty catch block
            }
            List<AbstractTrace> traceList = Query.getIncomingTraces(element, transfo);
            for (AbstractTrace trace : traceList) {
                if (!Query.isLinkOfTransfo(trace, transfo)) continue;
                TraceableElement srcElement = trace.getSourceElement();
                if (expectedTarget != null && !EcoreUtil2.isEqualOrSuperClass((EClass)expectedTarget, (EClass)srcElement.eClass())) continue;
                result.add(srcElement);
            }
        }
        if (result.size() == 0) {
            return null;
        }
        if (result.size() == 1) {
            return result.get(0);
        }
        return result;
    }

    public static List<? extends EObject> retrieveTransformedElements(EObject object, ITransfo transfo) {
        return Query.retrieveTransformedElements(object, transfo, null);
    }

    public static List<? extends EObject> retrieveTransformedElements(EObject object, ITransfo transfo, EClass expectedTarget) {
        ArrayList<TraceableElement> results = new ArrayList<TraceableElement>();
        if (object != null && object instanceof CapellaElement) {
            CapellaElement element = (CapellaElement)object;
            try {
                transfo.findCachedMatchingRule(object);
            }
            catch (TransfoException transfoException) {
                // empty catch block
            }
            List<AbstractTrace> traceList = Query.getIncomingTraces(element, transfo);
            for (AbstractTrace trace : traceList) {
                if (!Query.isLinkOfTransfo(trace, transfo)) continue;
                TraceableElement srcElement = trace.getSourceElement();
                if (expectedTarget != null && !EcoreUtil2.isEqualOrSuperClass((EClass)expectedTarget, (EClass)srcElement.eClass())) continue;
                results.add(srcElement);
            }
        }
        return results;
    }

    public static List<? extends EObject> retrieveUnattachedTransformedElements(EObject object, ITransfo transfo, EClass expectedTarget) {
        ArrayList<TraceableElement> result = new ArrayList<TraceableElement>();
        if (object instanceof CapellaElement) {
            CapellaElement element = (CapellaElement)object;
            try {
                transfo.findCachedMatchingRule(object);
            }
            catch (TransfoException transfoException) {
                // empty catch block
            }
            List<AbstractTrace> traceList = Query.getIncomingTraces(element, transfo);
            for (AbstractTrace trace : traceList) {
                if (!Query.isLinkOfTransfo(trace, transfo)) continue;
                TraceableElement srcElement = trace.getSourceElement();
                if (expectedTarget != null && !EcoreUtil2.isEqualOrSuperClass((EClass)expectedTarget, (EClass)srcElement.eClass()) || srcElement.eContainer() != null) continue;
                result.add(srcElement);
            }
        }
        return result;
    }
}

