/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.appenders.reportlogview.handler;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerHelpRegistry;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewPlugin;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.Messages;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.handler.AbstractDynamicContributionItem;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.handler.ReportMarkerResolution;

public class QuickfixHandler
extends AbstractDynamicContributionItem {
    public static final String PL_MARKER_RESOLUTION = "org.eclipse.ui.ide.markerResolution";
    private final String menuId = "org.polarsys.capella.core.validation.quickfix";
    private final String menuImage = "quickfix.gif";

    public static IMarkerHelpRegistry getMarkerRegistry() {
        return IDE.getMarkerHelpRegistry();
    }

    @Override
    protected boolean hasContributionItems() {
        return this.getContributionItems().length > 0;
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled();
    }

    @Override
    protected IContributionItem[] getContributionItems() {
        List<IMarker> selection = this.getSelectedMarkers();
        if (selection.isEmpty()) {
            return NO_CONTRIBUTION_ITEM;
        }
        ArrayList<IContributionItem> items = new ArrayList<IContributionItem>();
        IMarkerResolution[] iMarkerResolutionArray = QuickfixHandler.getMarkerRegistry().getResolutions(selection.get(0));
        int n = iMarkerResolutionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerResolution res = iMarkerResolutionArray[n2];
            HashSet<IMarker> markers = new HashSet<IMarker>();
            markers.add(selection.get(0));
            if (res instanceof WorkbenchMarkerResolution) {
                IMarker[] otherMarkers;
                IMarker[] iMarkerArray = otherMarkers = ((WorkbenchMarkerResolution)res).findOtherMarkers(selection.toArray(new IMarker[0]));
                int n3 = otherMarkers.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMarker otherMarker = iMarkerArray[n4];
                    markers.add(otherMarker);
                    ++n4;
                }
            }
            if (markers.containsAll(selection) && this.isCompatible(res, markers)) {
                items.add(this.createContributionItem(markers, res));
            }
            ++n2;
        }
        if (items.size() > 0) {
            ImageDescriptor image = MarkerViewPlugin.getDefault().getImageDescriptor("quickfix.gif");
            String text = Messages.MarkerView_Quickfix_Command_Name;
            MenuManager manager = new MenuManager(text, image, "org.polarsys.capella.core.validation.quickfix");
            for (IContributionItem item : items) {
                manager.add(item);
            }
            return new IContributionItem[]{manager};
        }
        return NO_CONTRIBUTION_ITEM;
    }

    protected boolean isCompatible(IMarkerResolution res, Collection<IMarker> markers) {
        if (res instanceof ReportMarkerResolution) {
            return ((ReportMarkerResolution)res).enabled(markers);
        }
        return true;
    }

    protected boolean isInQuickFixAllSimilar(IMarkerResolution res, Collection<IMarker> markers) {
        if (res instanceof ReportMarkerResolution) {
            return ((ReportMarkerResolution)res).quickFixAllSimilarEnabled(markers);
        }
        return true;
    }

    protected IContributionItem createContributionItem(final Collection<IMarker> markers, final IMarkerResolution resolution) {
        return new ActionContributionItem((IAction)new Action(){

            public String getText() {
                return resolution.getLabel();
            }

            public ImageDescriptor getImageDescriptor() {
                Image img;
                ImageDescriptor imgDesc = null;
                imgDesc = resolution instanceof IMarkerResolution2 ? ((img = ((IMarkerResolution2)resolution).getImage()) != null ? ImageDescriptor.createFromImage((Image)img) : super.getImageDescriptor()) : super.getImageDescriptor();
                return imgDesc;
            }

            public String getDescription() {
                String desc = null;
                desc = resolution instanceof IMarkerResolution2 ? ((IMarkerResolution2)resolution).getDescription() : super.getDescription();
                return desc;
            }

            public void run() {
                IRunnableWithProgress resolutionsRunnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        if (resolution instanceof WorkbenchMarkerResolution) {
                            ((WorkbenchMarkerResolution)resolution).run(markers.toArray(new IMarker[0]), monitor);
                        } else {
                            for (IMarker marker : markers) {
                                resolution.run(marker);
                            }
                        }
                    }
                };
                ProgressMonitorDialog context = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                try {
                    PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, resolutionsRunnable, null);
                }
                catch (InvocationTargetException exception) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.polarsys.capella.common.tools.report.appenders.reportlogview", exception.getMessage(), (Throwable)exception));
                }
                catch (InterruptedException exception) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.polarsys.capella.common.tools.report.appenders.reportlogview", exception.getMessage(), (Throwable)exception));
                }
            }
        });
    }
}

