/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.appenders.reportlogview;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IStateListener;
import org.eclipse.core.commands.State;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.polarsys.capella.common.mdsofa.common.constant.ICommonConstants;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.AbstractMarkerViewContentProvider;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.CanonicalContentProvider;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.CategoryContentProvider;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.IMarkerSource;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.IViewerRefresh;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.LightMarkerRegistry;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewColumns;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewFilter;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewTree;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.RuleIdContentProvider;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.SeverityContentProvider;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.ViewerRefresh;

public class MarkerView
extends ViewPart {
    public static final String MARKER_NUMBER = "idNumber";
    public static final String GROUP_COMMAND = "org.polarsys.capella.common.tools.report.appenders.reportlogview.logview.group";
    public static final String VIEW_ID = "org.polarsys.capella.common.tools.report.appenders.reportlogview.logview";
    public static final String MARKER_ID = "org.polarsys.capella.common.tools.report.appenders.reportlogview.logview";
    private static final String CAPELLA_PROJECT_EXPLORER_ID = "capella.project.explorer";
    private MarkerViewHelper helper;
    private MarkerViewColumns columns;
    private AbstractMarkerViewContentProvider contentProvider;
    private IResourceChangeListener resourceListener;
    private TreeViewer viewer;
    private MarkerViewFilter filter;
    private IMarkerSource lightMarkers;
    private IMarkerSource resourceMarkers;
    private ISelectionListener selectionListener;
    private IStateListener flavourStateListener;

    public void createPartControl(Composite parent) {
        MarkerViewTree tree = new MarkerViewTree(parent, 268503042);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.viewer = new TreeViewer((Tree)tree);
        this.viewer.setUseHashlookup(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        this.createContextMenu();
        this.hookSelectionListeners();
        this.addLinkWithEditorSupport();
        this.lightMarkers = LightMarkerRegistry.getInstance();
        this.helper = new MarkerViewHelper(this.lightMarkers, "org.polarsys.capella.common.tools.report.appenders.reportlogview.logview");
        this.columns = new MarkerViewColumns(this.viewer);
        this.filter = this.createFilter((Viewer)this.viewer);
        this.viewer.setFilters(new ViewerFilter[]{this.filter});
        ICommandService commandService = (ICommandService)this.getSite().getService(ICommandService.class);
        Command flavourCommand = commandService.getCommand(GROUP_COMMAND);
        State flavourState = flavourCommand.getState("org.eclipse.ui.commands.radioState");
        String value = flavourState.getValue().toString();
        Flavour flavour = Flavour.valueOf(value);
        this.setFlavour(flavour);
        this.hookFlavourStateListener(flavourState);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.viewer.setInput((Object)workspace.getRoot());
    }

    private void addLinkWithEditorSupport() {
        new OpenAndLinkWithEditorHelper((StructuredViewer)this.viewer){

            protected void activate(ISelection selection) {
                int currentMode = OpenStrategy.getOpenMethod();
                try {
                    OpenStrategy.setOpenMethod((int)0);
                    MarkerView.this.openSelectedMarkers(selection);
                }
                finally {
                    OpenStrategy.setOpenMethod((int)currentMode);
                }
            }

            protected void linkToEditor(ISelection selection) {
            }

            protected void open(ISelection selection, boolean activate) {
                MarkerView.this.openSelectedMarkers(selection);
            }
        };
    }

    protected void openSelectedMarkers(ISelection selection) {
        IViewPart part;
        IShowInSource source = (IShowInSource)this.getAdapter(IShowInSource.class);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (part = window.getActivePage().findView(CAPELLA_PROJECT_EXPLORER_ID)) != null) {
            IShowInTarget showInTarget = (IShowInTarget)part.getAdapter(IShowInTarget.class);
            showInTarget.show(new ShowInContext(null, source.getShowInContext().getSelection()));
        }
    }

    private void hookFlavourStateListener(State state) {
        this.flavourStateListener = new IStateListener(){

            public void handleStateChange(State state, Object oldValue) {
                MarkerView.this.setFlavour(Flavour.valueOf(state.getValue().toString()));
            }
        };
        state.addListener(this.flavourStateListener);
    }

    protected void hookSelectionListeners() {
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (part != MarkerView.this) {
                    MarkerView.this.filter.setSelection(selection);
                }
            }
        };
        this.getSite().getPage().addSelectionListener(this.selectionListener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    protected void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                MarkerView.this.fillContextMenu(m);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager m) {
        m.add((IContributionItem)new Separator("navigation"));
        m.add((IContributionItem)new Separator("use"));
        m.add((IContributionItem)new Separator("settings"));
        m.add((IContributionItem)new Separator("additions"));
    }

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    public void dispose() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (this.resourceListener != null && workspace != null) {
            workspace.removeResourceChangeListener(this.resourceListener);
        }
        if (this.lightMarkers != null && this.contentProvider != null) {
            this.lightMarkers.removeListener(this.contentProvider);
        }
        if (this.selectionListener != null) {
            this.getSite().getPage().removeSelectionListener(this.selectionListener);
        }
        if (this.flavourStateListener != null) {
            ICommandService commandService = (ICommandService)this.getSite().getService(ICommandService.class);
            Command command = commandService.getCommand(GROUP_COMMAND);
            State state = command.getState("org.eclipse.ui.commands.radioState");
            state.removeListener(this.flavourStateListener);
        }
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    private void hookProvider(AbstractMarkerViewContentProvider newProvider) {
        try {
            this.viewer.getTree().setRedraw(false);
            if (this.contentProvider != null) {
                this.lightMarkers.removeListener(this.contentProvider);
            }
            if (this.resourceMarkers != null) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceMarkers);
            }
            this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
            this.columns.update(newProvider);
            this.viewer.setContentProvider((IContentProvider)newProvider);
            this.lightMarkers.addListener(newProvider);
            this.expandToDefault();
            this.contentProvider = newProvider;
        }
        finally {
            this.viewer.getTree().setRedraw(true);
        }
    }

    public void setAutomaticRefresh(boolean enabled) {
        if (enabled) {
            this.contentProvider.setViewerRefresh(this.getDefaultRefresh());
        } else {
            this.contentProvider.setViewerRefresh(null);
        }
    }

    public boolean isAutomaticRefresh() {
        return this.contentProvider.getViewerRefresh() != null;
    }

    private void setFlavour(Flavour flavour) {
        if (flavour == Flavour.RULE) {
            this.hookProvider(new RuleIdContentProvider(this.viewer, this.helper, this.getCurrentRefresh()));
        } else if (flavour == Flavour.CATEGORY) {
            this.hookProvider(new CategoryContentProvider(this.viewer, this.helper, this.getCurrentRefresh()));
        } else if (flavour == Flavour.SEVERITY) {
            this.hookProvider(new SeverityContentProvider(this.viewer, this.helper, this.getCurrentRefresh()));
        } else if (flavour == Flavour.NONE) {
            this.hookProvider(new CanonicalContentProvider(this.viewer, this.helper, this.getCurrentRefresh()));
        }
    }

    public String getHtml() {
        StringBuilder res = new StringBuilder();
        res.append("<html> \n");
        res.append("<head> \n");
        res.append("<title>Problems saved on " + new Date() + "</title> \n");
        res.append("<head> \n");
        res.append("<body> \n");
        res.append("<table border=\"1\"> \n");
        res.append("<tr> \n");
        int[] columnOrder = this.viewer.getTree().getColumnOrder();
        int i = 0;
        while (i < columnOrder.length) {
            TreeColumn c = this.viewer.getTree().getColumn(columnOrder[i]);
            res.append("<th> \n");
            res.append(c.getText());
            res.append("</th> \n");
            ++i;
        }
        res.append("</tr> \n");
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        CanonicalContentProvider provider = new CanonicalContentProvider(this.viewer, this.helper, null);
        provider.inputChanged(null, null, root);
        Object[] elements = provider.getElements(root);
        this.viewer.getComparator().sort(null, elements);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            boolean filtered = false;
            ViewerFilter[] viewerFilterArray = this.viewer.getFilters();
            int n3 = viewerFilterArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ViewerFilter f = viewerFilterArray[n4];
                if (!f.select((Viewer)this.viewer, (Object)root, e)) {
                    filtered = true;
                }
                ++n4;
            }
            if (!filtered) {
                res.append("<tr> \n");
                int i2 = 0;
                while (i2 < columnOrder.length) {
                    res.append("<td> \n");
                    CellLabelProvider label = this.viewer.getLabelProvider(columnOrder[i2]);
                    if (label instanceof ColumnLabelProvider) {
                        String text = ((ColumnLabelProvider)label).getText(e);
                        if (text == null) {
                            text = "";
                        }
                        res.append(StringEscapeUtils.escapeHtml((String)text));
                        res.append("\n");
                    }
                    res.append("</td> \n");
                    ++i2;
                }
                res.append("</tr> \n");
            }
            ++n2;
        }
        return res.toString();
    }

    protected MarkerViewFilter createFilter(Viewer v) {
        return new MarkerViewFilter(v);
    }

    public void clear() {
        try {
            this.getViewer().getTree().setRedraw(false);
            this.getViewer().setSelection((ISelection)StructuredSelection.EMPTY);
            IViewerRefresh oldRefresh = this.contentProvider.getViewerRefresh();
            this.contentProvider.setViewerRefresh(null);
            this.contentProvider.clear();
            this.getViewer().refresh();
            this.contentProvider.setViewerRefresh(oldRefresh);
        }
        finally {
            this.viewer.getTree().setRedraw(true);
        }
    }

    public List<IMarkerSource> getMarkerSources() {
        return Arrays.asList(this.lightMarkers);
    }

    public String getSelectionAsText() {
        StringBuilder builder = new StringBuilder();
        String result = null;
        ISelection selection = this.getViewer().getSelection();
        if (selection instanceof IStructuredSelection) {
            Object[] elements = ((IStructuredSelection)selection).toArray();
            int[] columnOrder = this.viewer.getTree().getColumnOrder();
            int ele = 0;
            while (ele < elements.length) {
                Object element = elements[ele];
                int col = 0;
                while (col < columnOrder.length) {
                    CellLabelProvider label = this.viewer.getLabelProvider(columnOrder[col]);
                    if (label instanceof ColumnLabelProvider) {
                        builder.append(((ColumnLabelProvider)label).getText(element));
                        if (col < columnOrder.length - 1) {
                            builder.append(" | ");
                        }
                    }
                    if (ele < elements.length - 1) {
                        builder.append(ICommonConstants.LINE_SEPARATOR);
                    }
                    ++col;
                }
                ++ele;
            }
        }
        if (builder.length() > 0) {
            result = builder.toString();
        }
        return result;
    }

    private IViewerRefresh getDefaultRefresh() {
        return new ViewerRefresh(this, 100L, TimeUnit.MILLISECONDS);
    }

    private IViewerRefresh getCurrentRefresh() {
        IViewerRefresh refresh = null;
        refresh = this.contentProvider != null ? this.contentProvider.getViewerRefresh() : this.getDefaultRefresh();
        return refresh;
    }

    public void expandToDefault() {
        ITreeContentProvider provider = (ITreeContentProvider)this.viewer.getContentProvider();
        HashSet<Object> expanded = new HashSet<Object>();
        for (IMarkerSource source : this.getMarkerSources()) {
            for (IMarker marker : source.getMarkers()) {
                Object parent = provider.getParent((Object)marker);
                if (parent == null || parent == this.viewer.getInput()) continue;
                Object grandparent = provider.getParent(parent);
                while (grandparent != null && grandparent != this.viewer.getInput()) {
                    expanded.add(grandparent);
                    grandparent = provider.getParent(grandparent);
                }
            }
        }
        Object input = this.viewer.getInput();
        if (input != null) {
            expanded.add(this.viewer.getInput());
        }
        this.viewer.setExpandedElements(expanded.toArray());
    }

    public static enum Flavour {
        CATEGORY,
        SEVERITY,
        NONE,
        RULE;

    }
}

