/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.price.design.service.nodes;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.vp.price.price.PartPrice;
import org.polarsys.capella.vp.price.price.Price;
import org.polarsys.capella.vp.price.services.PriceCapellaService;
import org.polarsys.kitalpha.emde.model.ElementExtension;

public class PriceLevelHelper {
    private PriceCapellaService maPriceService = new PriceCapellaService();

    public int computePrice(EObject eObject) {
        int m = this.maPriceService.computePrice(eObject);
        ((PartPrice)this.maPriceService.getPriceObject(eObject)).setCurrentPrice(m);
        return m;
    }

    public boolean isPriceOverhead(EObject eObject, EObject view, EObject container) {
        if (eObject instanceof Price) {
            return this.evaluatePriceStatus(eObject, PriceStatus.OVERHEAD);
        }
        return this.computePartStatus((Part)eObject, view, container, PriceStatus.OVERHEAD);
    }

    public boolean isPriceSaturated(EObject eObject, EObject view, EObject container) {
        if (eObject instanceof Price) {
            return this.evaluatePriceStatus(eObject, PriceStatus.SATURATED);
        }
        return this.computePartStatus((Part)eObject, view, container, PriceStatus.SATURATED);
    }

    private boolean computePartStatus(Part part, EObject view, EObject container, PriceStatus flag) {
        Price currentPCPrice = this.getPriceExtension(part);
        if (currentPCPrice != null) {
            return this.evaluatePriceStatus((EObject)currentPCPrice, flag);
        }
        return false;
    }

    private Price getPriceExtension(Part part) {
        EList extensions = part.getOwnedExtensions();
        for (ElementExtension elementExtension : extensions) {
            if (!(elementExtension instanceof Price)) continue;
            return (Price)elementExtension;
        }
        return null;
    }

    private boolean evaluatePriceStatus(EObject eObject, PriceStatus flag) {
        int current = this.maPriceService.computePrice(eObject);
        int maxValue = ((Price)eObject).getMaxValue();
        if (maxValue <= 0) {
            return false;
        }
        switch (flag) {
            case OVERHEAD: {
                return current > maxValue;
            }
            case SATURATED: {
                return current != 0 && current == maxValue;
            }
        }
        return false;
    }

    private static enum PriceStatus {
        OVERHEAD,
        SATURATED;

    }
}

