/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.launch;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.buildship.core.internal.configuration.RunConfiguration;
import org.eclipse.buildship.core.internal.console.ProcessDescription;
import org.eclipse.buildship.core.internal.gradle.GradleProgressAttributes;
import org.eclipse.buildship.core.internal.i18n.CoreMessages;
import org.eclipse.buildship.core.internal.launch.BaseLaunchRequestJob;
import org.eclipse.buildship.core.internal.launch.TestTarget;
import org.eclipse.buildship.core.internal.workspace.InternalGradleBuild;
import org.gradle.tooling.TestLauncher;

public final class RunGradleJvmTestLaunchRequestJob
extends BaseLaunchRequestJob<TestLauncher> {
    private final ImmutableList<TestTarget> testTargets;
    private final RunConfiguration runConfig;

    public RunGradleJvmTestLaunchRequestJob(List<TestTarget> testTargets, RunConfiguration runConfig) {
        super("Launching Gradle Tests");
        this.testTargets = ImmutableList.copyOf(testTargets);
        this.runConfig = (RunConfiguration)Preconditions.checkNotNull((Object)runConfig);
    }

    @Override
    protected String getJobTaskName() {
        return "Launch Gradle test classes";
    }

    @Override
    protected RunConfiguration getRunConfig() {
        return this.runConfig;
    }

    @Override
    protected ProcessDescription createProcessDescription() {
        String processName = this.createProcessName(this.runConfig.getProjectConfiguration().getProjectDir());
        return new TestLaunchProcessDescription(processName);
    }

    private String createProcessName(File workingDir) {
        return String.format("[Gradle Project] %s in %s (%s)", Joiner.on((char)' ').join(RunGradleJvmTestLaunchRequestJob.collectSimpleNames(this.testTargets)), workingDir.getAbsolutePath(), DateFormat.getDateTimeInstance(2, 2).format(new Date()));
    }

    @Override
    protected TestLauncher createLaunch(InternalGradleBuild gradleBuild, RunConfiguration runConfiguration, GradleProgressAttributes invocationAttributes, ProcessDescription processDescription) {
        TestLauncher launcher = gradleBuild.newTestLauncher(runConfiguration, invocationAttributes);
        for (TestTarget testTarget : this.testTargets) {
            testTarget.apply(launcher);
        }
        return launcher;
    }

    @Override
    protected void executeLaunch(TestLauncher launcher) {
        launcher.run();
    }

    @Override
    protected void writeExtraConfigInfo(GradleProgressAttributes invocationAttributes) {
        invocationAttributes.writeConfig(String.format("%s: %s", CoreMessages.RunConfiguration_Label_Tests, Joiner.on((char)' ').join(RunGradleJvmTestLaunchRequestJob.collectQualifiedNames(this.testTargets))));
    }

    private static Collection<String> collectQualifiedNames(ImmutableList<TestTarget> testTargets) {
        return FluentIterable.from(testTargets).transform((Function)new Function<TestTarget, String>(){

            public String apply(TestTarget testTarget) {
                return testTarget.getQualifiedName();
            }
        }).toSet();
    }

    private static Collection<String> collectSimpleNames(ImmutableList<TestTarget> testTargets) {
        return FluentIterable.from(testTargets).transform((Function)new Function<TestTarget, String>(){

            public String apply(TestTarget testTarget) {
                return testTarget.getSimpleName();
            }
        }).toSet();
    }

    private final class TestLaunchProcessDescription
    extends BaseLaunchRequestJob.BaseProcessDescription {
        public TestLaunchProcessDescription(String processName) {
            super(processName, RunGradleJvmTestLaunchRequestJob.this, RunGradleJvmTestLaunchRequestJob.this.runConfig);
        }

        @Override
        public boolean isRerunnable() {
            return true;
        }

        @Override
        public void rerun() {
            RunGradleJvmTestLaunchRequestJob job = new RunGradleJvmTestLaunchRequestJob((List<TestTarget>)RunGradleJvmTestLaunchRequestJob.this.testTargets, RunGradleJvmTestLaunchRequestJob.this.runConfig);
            job.schedule();
        }
    }
}

