/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.gradleware.tooling.toolingmodel.OmniEclipseGradleBuild;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniGradleProject;
import com.gradleware.tooling.toolingmodel.OmniProjectTask;
import com.gradleware.tooling.toolingmodel.OmniTaskSelector;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.util.Maybe;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.gradle.LoadEclipseGradleBuildsJob;
import org.eclipse.buildship.core.workspace.ModelProvider;
import org.eclipse.buildship.ui.view.task.ProjectNode;
import org.eclipse.buildship.ui.view.task.ProjectTaskNode;
import org.eclipse.buildship.ui.view.task.TaskGroupNode;
import org.eclipse.buildship.ui.view.task.TaskNode;
import org.eclipse.buildship.ui.view.task.TaskSelectorNode;
import org.eclipse.buildship.ui.view.task.TaskView;
import org.eclipse.buildship.ui.view.task.TaskViewContent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.PlatformUI;

public final class TaskViewContentProvider
implements ITreeContentProvider {
    private static final Object[] NO_CHILDREN = new Object[0];
    private final TaskView taskView;

    public TaskViewContentProvider(TaskView taskView) {
        this.taskView = (TaskView)Preconditions.checkNotNull((Object)taskView);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput == null) {
            return;
        }
        TaskViewContent content = (TaskViewContent)TaskViewContent.class.cast(newInput);
        LoadEclipseGradleBuildsJob loadEclipseGradleBuildsJob = new LoadEclipseGradleBuildsJob(content.getModelFetchStrategy(), content.getRootProjectConfigurations());
        loadEclipseGradleBuildsJob.addJobChangeListener((IJobChangeListener)new RefreshTasksViewAfterJobDone(this.taskView));
        loadEclipseGradleBuildsJob.schedule();
    }

    public Object[] getElements(Object input) {
        ImmutableList.Builder result = ImmutableList.builder();
        if (input instanceof TaskViewContent) {
            TaskViewContent content = (TaskViewContent)input;
            for (ProjectConfiguration projectConfiguration : content.getRootProjectConfigurations()) {
                result.addAll(this.createTopLevelProjectNodes(projectConfiguration));
            }
        }
        return result.build().toArray();
    }

    private List<ProjectNode> createTopLevelProjectNodes(ProjectConfiguration projectConfiguration) {
        OmniEclipseGradleBuild gradleBuild = this.fetchCachedEclipseGradleBuild(projectConfiguration.getRequestAttributes());
        if (gradleBuild == null) {
            return ImmutableList.of();
        }
        ArrayList allProjectNodes = Lists.newArrayList();
        this.collectProjectNodesRecursively(gradleBuild.getRootEclipseProject(), null, allProjectNodes);
        return allProjectNodes;
    }

    private OmniEclipseGradleBuild fetchCachedEclipseGradleBuild(FixedRequestAttributes fixedRequestAttributes) {
        ModelProvider modelProvider = CorePlugin.gradleWorkspaceManager().getGradleBuild(fixedRequestAttributes).getModelProvider();
        return modelProvider.fetchEclipseGradleBuild(FetchStrategy.FROM_CACHE_ONLY, null, null);
    }

    private void collectProjectNodesRecursively(OmniEclipseProject eclipseProject, ProjectNode parentProjectNode, List<ProjectNode> allProjectNodes) {
        OmniGradleProject gradleProject = eclipseProject.getGradleProject();
        Optional workspaceProject = CorePlugin.workspaceOperations().findProjectByLocation(eclipseProject.getProjectDirectory());
        ProjectNode projectNode = new ProjectNode(parentProjectNode, eclipseProject, gradleProject, (Optional<IProject>)workspaceProject);
        allProjectNodes.add(projectNode);
        for (OmniEclipseProject childProject : eclipseProject.getChildren()) {
            this.collectProjectNodesRecursively(childProject, projectNode, allProjectNodes);
        }
    }

    public boolean hasChildren(Object element) {
        return element instanceof ProjectNode || element instanceof TaskGroupNode;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof ProjectNode) {
            return this.childrenOf((ProjectNode)parent);
        }
        if (parent instanceof TaskGroupNode) {
            return this.childrenOf((TaskGroupNode)parent);
        }
        return NO_CHILDREN;
    }

    private Object[] childrenOf(ProjectNode projectNode) {
        if (this.taskView.getState().isGroupTasks()) {
            return this.groupNodesFor(projectNode).toArray();
        }
        return this.taskNodesFor(projectNode).toArray();
    }

    private Set<TaskGroupNode> groupNodesFor(ProjectNode projectNode) {
        HashSet result = Sets.newHashSet();
        result.add(TaskGroupNode.getDefault(projectNode));
        for (OmniProjectTask projectTask : projectNode.getGradleProject().getProjectTasks()) {
            result.add(TaskGroupNode.forName(projectNode, (Maybe<String>)projectTask.getGroup()));
        }
        for (OmniTaskSelector taskSelector : projectNode.getGradleProject().getTaskSelectors()) {
            result.add(TaskGroupNode.forName(projectNode, (Maybe<String>)taskSelector.getGroup()));
        }
        return result;
    }

    private List<TaskNode> taskNodesFor(ProjectNode projectNode) {
        ArrayList taskNodes = Lists.newArrayList();
        for (OmniProjectTask projectTask : projectNode.getGradleProject().getProjectTasks()) {
            taskNodes.add(new ProjectTaskNode(projectNode, projectTask));
        }
        for (OmniTaskSelector taskSelector : projectNode.getGradleProject().getTaskSelectors()) {
            taskNodes.add(new TaskSelectorNode(projectNode, taskSelector));
        }
        return taskNodes;
    }

    private Object[] childrenOf(TaskGroupNode groupNode) {
        return groupNode.getTaskNodes().toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof ProjectNode) {
            return ((ProjectNode)element).getParentProjectNode();
        }
        if (element instanceof TaskNode) {
            return ((TaskNode)element).getParentProjectNode();
        }
        if (element instanceof TaskGroupNode) {
            return ((TaskGroupNode)element).getProjectNode();
        }
        return null;
    }

    public void dispose() {
    }

    private static final class RefreshTasksViewAfterJobDone
    extends JobChangeAdapter {
        private final TaskView taskView;

        private RefreshTasksViewAfterJobDone(TaskView taskView) {
            this.taskView = (TaskView)Preconditions.checkNotNull((Object)taskView);
        }

        public void done(IJobChangeEvent event) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    taskView.refresh();
                }
            });
        }
    }
}

