/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.execution;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.gradleware.tooling.toolingmodel.OmniGradleBuild;
import com.gradleware.tooling.toolingmodel.OmniGradleProject;
import com.gradleware.tooling.toolingmodel.Path;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.util.Maybe;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.gradle.Specs;
import org.eclipse.buildship.core.launch.GradleRunConfigurationAttributes;
import org.eclipse.buildship.core.util.progress.ToolingApiWorkspaceJob;
import org.eclipse.buildship.core.workspace.ModelProvider;
import org.eclipse.buildship.ui.UiPlugin;
import org.eclipse.buildship.ui.util.editor.EditorUtils;
import org.eclipse.buildship.ui.view.execution.OperationItem;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.task.TaskOperationDescriptor;
import org.gradle.tooling.events.test.JvmTestOperationDescriptor;

public final class OpenTestSourceFileJob
extends ToolingApiWorkspaceJob {
    private final ImmutableList<OperationItem> operationItems;
    private final GradleRunConfigurationAttributes runConfigurationAttributes;

    public OpenTestSourceFileJob(List<OperationItem> operationItems, GradleRunConfigurationAttributes runConfigurationAttributes) {
        super("Opening test source files");
        this.operationItems = ImmutableList.copyOf(operationItems);
        this.runConfigurationAttributes = (GradleRunConfigurationAttributes)Preconditions.checkNotNull((Object)runConfigurationAttributes);
    }

    protected void runToolingApiJobInWorkspace(IProgressMonitor monitor) throws Exception {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.operationItems.size());
        for (OperationItem operationItem : this.operationItems) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.searchForTestSource(operationItem, subMonitor.newChild(1));
        }
    }

    private void searchForTestSource(OperationItem operationItem, SubMonitor monitor) throws CoreException {
        OperationDescriptor operationDescriptor = (OperationDescriptor)operationItem.getAdapter(OperationDescriptor.class);
        if (operationDescriptor instanceof JvmTestOperationDescriptor) {
            JvmTestOperationDescriptor testOperationDescriptor = (JvmTestOperationDescriptor)operationDescriptor;
            String className = testOperationDescriptor.getClassName();
            Optional<Path> projectPath = this.findProjectPath(operationDescriptor);
            if (className != null && projectPath.isPresent()) {
                String methodName = testOperationDescriptor.getMethodName();
                this.searchForTestSource(className, methodName, (Path)projectPath.get(), monitor);
            }
        }
    }

    private Optional<Path> findProjectPath(OperationDescriptor operationDescriptor) {
        OperationDescriptor parent = operationDescriptor.getParent();
        if (parent != null) {
            if (parent instanceof TaskOperationDescriptor) {
                Path taskPath = Path.from((String)((TaskOperationDescriptor)parent).getTaskPath());
                return Optional.of((Object)taskPath.dropLastSegment());
            }
            return this.findProjectPath(parent);
        }
        return Optional.absent();
    }

    private void searchForTestSource(String className, String methodName, Path projectPath, SubMonitor monitor) throws CoreException {
        monitor.setTaskName(String.format("Open test source file for class %s.", className));
        monitor.setWorkRemaining(2);
        Optional<IProject> project = this.findProjectContainingTest(projectPath, (IProgressMonitor)monitor);
        boolean found = this.searchForJavaTest(className, methodName, project, (IProgressMonitor)monitor.newChild(1));
        if (!found) {
            this.searchForGroovyTest(className, methodName, project, monitor.newChild(1));
        }
    }

    private boolean searchForJavaTest(String className, String methodName, Optional<IProject> project, IProgressMonitor monitor) throws CoreException {
        SearchEngine searchEngine = new SearchEngine();
        SearchPattern pattern = SearchPattern.createPattern((String)className, (int)0, (int)0, (int)0);
        ShowTestSourceFileSearchRequester requester = new ShowTestSourceFileSearchRequester(methodName);
        searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, this.createSearchScope(project, monitor), (SearchRequestor)requester, monitor);
        return requester.isFoundJavaTestSourceFile();
    }

    private void searchForGroovyTest(String className, String methodName, Optional<IProject> project, SubMonitor monitor) throws CoreException {
        IWorkspaceRoot searchScope = project.isPresent() ? (IContainer)project.get() : ResourcesPlugin.getWorkspace().getRoot();
        searchScope.accept((IResourceVisitor)new ShowTestSourceFileResourceVisitor(methodName, className, (List)ImmutableList.of((Object)"groovy")));
    }

    private Optional<IProject> findProjectContainingTest(Path projectPath, IProgressMonitor monitor) {
        Maybe projectDirectory;
        FixedRequestAttributes requestAttributes = this.runConfigurationAttributes.toFixedRequestAttributes();
        ModelProvider modelProvider = CorePlugin.gradleWorkspaceManager().getGradleBuild(requestAttributes).getModelProvider();
        OmniGradleBuild gradleBuild = modelProvider.fetchGradleBuild(FetchStrategy.LOAD_IF_NOT_CACHED, this.getToken(), monitor);
        Optional gradleProject = gradleBuild.getRootProject().tryFind(Specs.gradleProjectMatchesProjectPath((Path)projectPath));
        if (gradleProject.isPresent() && (projectDirectory = ((OmniGradleProject)gradleProject.get()).getProjectDirectory()).isPresent() && projectDirectory.get() != null) {
            return CorePlugin.workspaceOperations().findProjectByLocation((File)projectDirectory.get());
        }
        return Optional.absent();
    }

    private IJavaSearchScope createSearchScope(Optional<IProject> candidate, IProgressMonitor monitor) throws CoreException {
        IProject project;
        if (candidate.isPresent() && (project = (IProject)candidate.get()).isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature")) {
            return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{JavaCore.create((IProject)project)});
        }
        return SearchEngine.createWorkspaceScope();
    }

    private static final class ShowTestSourceFileResourceVisitor
    implements IResourceVisitor {
        private static final String BIN_FOLDER_NAME = "bin";
        private final String methodName;
        private final String className;
        private final ImmutableList<String> fileExtensions;

        private ShowTestSourceFileResourceVisitor(String methodName, String className, List<String> fileExtensions) {
            this.methodName = methodName;
            this.className = (String)Preconditions.checkNotNull((Object)className);
            this.fileExtensions = ImmutableList.copyOf(fileExtensions);
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() != 1 || !this.fileExtensions.contains((Object)resource.getFileExtension())) {
                return true;
            }
            String classNameToPath = this.className.replaceAll(Pattern.quote("."), "/");
            String projectRelativePath = resource.getProjectRelativePath().toString();
            if (projectRelativePath.startsWith(BIN_FOLDER_NAME) || !projectRelativePath.contains(classNameToPath)) {
                return true;
            }
            final IFile file = (IFile)resource.getAdapter(IFile.class);
            if (file == null) {
                return true;
            }
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    IEditorPart editor = EditorUtils.openInInternalEditor(file, true);
                    IRegion region = this.getClassOrMethodRegion(file);
                    if (region != null) {
                        EditorUtils.selectAndReveal(region.getOffset(), region.getLength(), editor, file);
                    }
                }
            });
            return false;
        }

        private IRegion getClassOrMethodRegion(IFile file) {
            if (this.methodName == null) {
                try {
                    FindReplaceDocumentAdapter documentAdapter = this.createFindReplaceDocumentAdapter(file);
                    return this.find(documentAdapter, Files.getNameWithoutExtension((String)file.getName()));
                }
                catch (Exception e) {
                    return null;
                }
            }
            try {
                FindReplaceDocumentAdapter documentAdapter = this.createFindReplaceDocumentAdapter(file);
                IRegion region = this.find(documentAdapter, this.methodName);
                if (region == null) {
                    documentAdapter = this.createFindReplaceDocumentAdapter(file);
                    return this.find(documentAdapter, Files.getNameWithoutExtension((String)file.getName()));
                }
                return region;
            }
            catch (Exception e) {
                return null;
            }
        }

        private FindReplaceDocumentAdapter createFindReplaceDocumentAdapter(IFile file) throws CoreException {
            TextFileDocumentProvider textFileDocumentProvider = new TextFileDocumentProvider();
            textFileDocumentProvider.connect((Object)file);
            IDocument document = textFileDocumentProvider.getDocument((Object)file);
            return new FindReplaceDocumentAdapter(document);
        }

        private IRegion find(FindReplaceDocumentAdapter findReplaceDocumentAdapter, String findString) throws BadLocationException {
            return findReplaceDocumentAdapter.find(0, findString, true, true, false, false);
        }
    }

    private final class ShowTestSourceFileSearchRequester
    extends SearchRequestor {
        private final String methodName;
        private final AtomicBoolean foundJavaTestSourceFile;

        private ShowTestSourceFileSearchRequester(String methodName) {
            this.methodName = methodName;
            this.foundJavaTestSourceFile = new AtomicBoolean(false);
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            if (match.getElement() instanceof IType) {
                this.foundJavaTestSourceFile.set(true);
                IType classElement = (IType)match.getElement();
                IJavaElement methodElement = this.findMethod(this.methodName, classElement);
                this.openInEditor((IJavaElement)(methodElement != null ? methodElement : classElement));
            }
        }

        private IJavaElement findMethod(String methodName, IType type) {
            IStatus status = JavaConventionsUtil.validateMethodName((String)methodName, (IJavaElement)type);
            if (!status.isOK()) {
                return null;
            }
            IMethod method = type.getMethod(methodName, new String[0]);
            if (method != null && method.exists()) {
                return method;
            }
            try {
                for (IMethod methodItem : type.getMethods()) {
                    if (!methodItem.getElementName().equals(methodName)) continue;
                    return methodItem;
                }
                return null;
            }
            catch (JavaModelException e) {
                return null;
            }
        }

        private void openInEditor(final IJavaElement javaElement) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        JavaUI.openInEditor((IJavaElement)javaElement);
                    }
                    catch (Exception e) {
                        String message = String.format("Cannot open Java element %s in editor.", javaElement);
                        UiPlugin.logger().error(message, (Throwable)e);
                    }
                }
            });
        }

        private boolean isFoundJavaTestSourceFile() {
            return this.foundJavaTestSourceFile.get();
        }
    }
}

