/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.workspace;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.buildship.core.util.collections.AdapterFunction;
import org.eclipse.buildship.core.workspace.SynchronizeGradleProjectsJob;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public final class ProjectSynchronizer {
    public static void execute(ExecutionEvent event) {
        List<IProject> selectedProjects = ProjectSynchronizer.collectSelectedProjects(event);
        if (selectedProjects.isEmpty()) {
            return;
        }
        SynchronizeGradleProjectsJob synchronizeJob = new SynchronizeGradleProjectsJob(selectedProjects);
        synchronizeJob.schedule();
    }

    private static List<IProject> collectSelectedProjects(ExecutionEvent event) {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)currentSelection;
            ImmutableList selectedProjects = FluentIterable.from((Iterable)selection.toList()).transform((Function)new AdapterFunction(IProject.class, Platform.getAdapterManager())).filter(Predicates.notNull()).filter(org.eclipse.buildship.ui.util.predicate.Predicates.hasGradleNature()).toList();
            return selectedProjects;
        }
        return ImmutableList.of();
    }
}

