/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import com.google.common.base.Optional;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.launch.GradleRunConfigurationAttributes;
import org.eclipse.buildship.ui.util.nodeselection.NodeSelection;
import org.eclipse.buildship.ui.util.nodeselection.SelectionSpecificAction;
import org.eclipse.buildship.ui.view.CommandBackedAction;
import org.eclipse.buildship.ui.view.task.TaskNodeSelectionUtils;
import org.eclipse.buildship.ui.view.task.TaskViewActionStateRules;
import org.eclipse.buildship.ui.view.task.TaskViewMessages;

public final class CreateRunConfigurationAction
extends CommandBackedAction
implements SelectionSpecificAction {
    public CreateRunConfigurationAction(String commandId) {
        super(commandId);
        this.setText(TaskViewMessages.Action_CreateRunConfiguration_Text);
        this.setToolTipText(TaskViewMessages.Action_CreateRunConfiguration_Tooltip);
    }

    @Override
    public boolean isVisibleFor(NodeSelection selection) {
        return (TaskViewActionStateRules.taskScopedTaskExecutionActionsVisibleFor(selection) || TaskViewActionStateRules.projectScopedTaskExecutionActionsVisibleFor(selection)) && this.isValidSelection(selection);
    }

    @Override
    public boolean isEnabledFor(NodeSelection selection) {
        return (TaskViewActionStateRules.taskScopedTaskExecutionActionsEnabledFor(selection) || TaskViewActionStateRules.projectScopedTaskExecutionActionsEnabledFor(selection)) && this.isValidSelection(selection);
    }

    private boolean isValidSelection(NodeSelection selection) {
        Optional<GradleRunConfigurationAttributes> attributes = TaskNodeSelectionUtils.tryGetRunConfigurationAttributes(selection);
        return !attributes.isPresent() || !CorePlugin.gradleLaunchConfigurationManager().getRunConfiguration((GradleRunConfigurationAttributes)attributes.get()).isPresent();
    }

    @Override
    public void setEnabledFor(NodeSelection selection) {
        this.setEnabled(this.isEnabledFor(selection));
    }
}

