/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.gradle;

import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingmodel.util.Pair;
import java.util.List;
import org.gradle.util.GradleVersion;

public final class Limitations {
    private final GradleVersion targetVersion;

    public Limitations(GradleVersion targetVersion) {
        this.targetVersion = targetVersion;
    }

    public List<Pair<GradleVersion, String>> getLimitations() {
        ImmutableList.Builder limitations = ImmutableList.builder();
        this.addIfNeeded("2.1", "No cancellation support", (ImmutableList.Builder<Pair<GradleVersion, String>>)limitations);
        this.addIfNeeded("2.4", "No test progress visualization", (ImmutableList.Builder<Pair<GradleVersion, String>>)limitations);
        this.addIfNeeded("2.5", "No build/task progress visualization", (ImmutableList.Builder<Pair<GradleVersion, String>>)limitations);
        this.addIfNeeded("2.5", "No improved project classpath generation with all transitive dependencies as direct dependencies", (ImmutableList.Builder<Pair<GradleVersion, String>>)limitations);
        this.addIfNeeded("2.6", "No running of tests from the Executions View", (ImmutableList.Builder<Pair<GradleVersion, String>>)limitations);
        this.addIfNeeded("2.6", "No rerunning of failed tests from the Executions View", (ImmutableList.Builder<Pair<GradleVersion, String>>)limitations);
        this.addIfNeeded("2.7", "No running of test classes and methods from the Editor", (ImmutableList.Builder<Pair<GradleVersion, String>>)limitations);
        return limitations.build();
    }

    private void addIfNeeded(String version, String limitation, ImmutableList.Builder<Pair<GradleVersion, String>> limitations) {
        GradleVersion gradleVersion = GradleVersion.version((String)version);
        if (this.targetVersion.getBaseVersion().compareTo(gradleVersion) < 0) {
            limitations.add(this.createLimitation(gradleVersion, limitation));
        }
    }

    private Pair<GradleVersion, String> createLimitation(GradleVersion version, String limitation) {
        return new Pair((Object)version, (Object)(limitation + " in Gradle versions <" + version.getVersion() + "."));
    }
}

