/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.WeakHashMap;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.reflect.ObjectInstantiationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectInstantiator
implements Instantiator {
    public static final Instantiator INSTANCE = new DirectInstantiator();
    private final ConstructorCache constructorCache = new ConstructorCache();

    public static <T> T instantiate(Class<? extends T> type, Object ... params) {
        return INSTANCE.newInstance(type, params);
    }

    private DirectInstantiator() {
    }

    @Override
    public <T> T newInstance(Class<? extends T> type, Object ... params) {
        try {
            Constructor<?> match = this.doGetConstructor(type, this.constructorCache.get(type), params);
            return type.cast(match.newInstance(params));
        }
        catch (InvocationTargetException e) {
            throw new ObjectInstantiationException(type, e.getCause());
        }
        catch (Exception e) {
            throw new ObjectInstantiationException(type, (Throwable)e);
        }
    }

    private <T> Constructor<?> doGetConstructor(Class<? extends T> type, Constructor<?>[] constructors, Object[] params) {
        Constructor<?> match = null;
        if (constructors.length > 0) {
            for (Constructor<?> constructor : constructors) {
                if (!DirectInstantiator.isMatch(constructor, params)) continue;
                if (match != null) {
                    throw new IllegalArgumentException(String.format("Found multiple public constructors for %s which accept parameters %s.", type, Arrays.toString(params)));
                }
                match = constructor;
            }
        }
        if (match == null) {
            throw new IllegalArgumentException(String.format("Could not find any public constructor for %s which accepts parameters %s.", type, Arrays.toString(params)));
        }
        return match;
    }

    private static boolean isMatch(Constructor<?> constructor, Object ... params) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        if (parameterTypes.length != params.length) {
            return false;
        }
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            Class<?> parameterType = parameterTypes[i];
            if (!(parameterType.isPrimitive() ? !JavaReflectionUtil.getWrapperTypeForPrimitiveType(parameterType).isInstance(param) : param != null && !parameterType.isInstance(param))) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @VisibleForTesting
    public static class ConstructorCache {
        private final Object lock = new Object();
        private final WeakHashMap<Class<?>, WeakReference<Constructor<?>[]>> cache = new WeakHashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Constructor<?>[] get(Class<?> key) {
            Constructor[] ctrs;
            WeakReference<Constructor<?>[]> cached;
            Object object = this.lock;
            synchronized (object) {
                cached = this.cache.get(key);
            }
            if (cached != null && (ctrs = (Constructor[])cached.get()) != null) {
                return ctrs;
            }
            return this.getAndCache(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Constructor<?>[] getAndCache(Class<?> key) {
            Constructor<?>[] ctors = key.getConstructors();
            WeakReference<Constructor<?>[]> value = new WeakReference<Constructor<?>[]>(ctors);
            Object object = this.lock;
            synchronized (object) {
                this.cache.put(key, value);
            }
            return ctors;
        }
    }
}

